/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.EntityRegistryTableModel;
import com.paterva.maltego.entity.manager.forms.EditEntityTypeAction;
import com.paterva.maltego.entity.manager.forms.NewEntityTypeBasicAction;
import com.paterva.maltego.entity.manager.imex.ExportEntitiesAction;
import com.paterva.maltego.entity.manager.imex.ImportEntitiesAction;
import com.paterva.maltego.entity.registry.RestoreEntitiesAction;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.table.ETableColumnSelectionDecorator;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class EntityManagerForm
extends JPanel {
    private EntityRegistry _registry;
    private final EntityRegistryTableModel _model;
    private JButton _exportButton;
    private JButton _importButton;
    private JButton _newButton;
    private JButton _restoreButton;
    private ETable _table;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public EntityManagerForm() {
        this((EntityRegistry)null);
    }

    public EntityManagerForm(EntityRegistry entityRegistry) {
        this._registry = entityRegistry;
        this.initComponents();
        this._restoreButton.setVisible("true".equals(System.getProperty("maltego.entities.can_restore", "false")));
        this._model = new EntityRegistryTableModel(this.registry());
        this._table.setModel((TableModel)((Object)this._model));
        EditableTableDecorator editableTableDecorator = new EditableTableDecorator();
        editableTableDecorator.addEditDelete((JTable)this._table, new TableButtonListener(){

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(TableButtonEvent tableButtonEvent) {
                void maltegoEntitySpec;
                int[] nArray = tableButtonEvent.getSelectedRows();
                ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
                Object object = nArray;
                int n = ((int[])object).length;
                boolean bl = false;
                while (maltegoEntitySpec < n) {
                    int n2 = object[maltegoEntitySpec];
                    arrayList.add(EntityManagerForm.this._model.getRow(EntityManagerForm.this._table.convertRowIndexToModel(n2)));
                    ++maltegoEntitySpec;
                }
                object = arrayList.size() > 1 ? (Object)("Would you like to delete these " + arrayList.size() + " selected entities?" + StringUtilities.newLine() + "This might affect the way your graphs are displayed.") : (Object)("Would you like to delete the " + ((MaltegoEntitySpec)arrayList.get(0)).getDisplayName() + " entity?" + StringUtilities.newLine() + "This might affect the way your graphs are displayed.");
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation(object, "Delete entity?", 1)) == NotifyDescriptor.YES_OPTION) {
                    for (MaltegoEntitySpec maltegoEntitySpec2 : arrayList) {
                        EntityManagerForm.this.registry().remove(maltegoEntitySpec2.getTypeName());
                    }
                }
            }
        }, new TableButtonListener(){

            public void actionPerformed(TableButtonEvent tableButtonEvent) {
                MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)EntityManagerForm.this._model.getRow(EntityManagerForm.this._table.convertRowIndexToModel(tableButtonEvent.getSelectedRows()[0]));
                ((EditEntityTypeAction)SystemAction.get(EditEntityTypeAction.class)).edit(maltegoEntitySpec);
            }
        });
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(20);
        ETableColumnSelectionDecorator eTableColumnSelectionDecorator = new ETableColumnSelectionDecorator();
        eTableColumnSelectionDecorator.makeSelectable(this._table, EntityRegistryTableModel.Columns, new boolean[]{true, true, true, false, false, false}, new String[]{"Image", null, null, null, null, null});
        this._table.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        PaddedTableCellRenderer paddedTableCellRenderer = new PaddedTableCellRenderer();
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)paddedTableCellRenderer);
        this._table.setAutoCreateColumnsFromModel(false);
    }

    private EntityRegistry registry() {
        if (this._registry == null) {
            return EntityRegistry.getDefault();
        }
        return this._registry;
    }

    public ETable getEntityTable() {
        return this._table;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._newButton = new JButton();
        this._importButton = new JButton();
        this._exportButton = new JButton();
        this._restoreButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._table = new ETable();
        this.setLayout(new BorderLayout());
        this._newButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._newButton.text"));
        this._newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityManagerForm.this._newButtonActionPerformed(actionEvent);
            }
        });
        this._importButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._importButton.text"));
        this._importButton.setMaximumSize(new Dimension(84, 23));
        this._importButton.setMinimumSize(new Dimension(84, 23));
        this._importButton.setPreferredSize(new Dimension(84, 23));
        this._importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityManagerForm.this._importButtonActionPerformed(actionEvent);
            }
        });
        this._exportButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._exportButton.text"));
        this._exportButton.setMaximumSize(new Dimension(84, 23));
        this._exportButton.setMinimumSize(new Dimension(84, 23));
        this._exportButton.setPreferredSize(new Dimension(84, 23));
        this._exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityManagerForm.this._exportButtonActionPerformed(actionEvent);
            }
        });
        this._restoreButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._restoreButton.text"));
        this._restoreButton.setMaximumSize(new Dimension(84, 23));
        this._restoreButton.setMinimumSize(new Dimension(84, 23));
        this._restoreButton.setPreferredSize(new Dimension(84, 23));
        this._restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityManagerForm.this._restoreButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this._importButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._exportButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._restoreButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this._newButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._newButton).addComponent(this._importButton, -2, -1, -2).addComponent(this._exportButton, -2, -1, -2).addComponent(this._restoreButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "First");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this._table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._table.setGridColor((Color)SystemColor.control);
        this._table.setRowHeight(20);
        this.jScrollPane1.setViewportView((Component)this._table);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    private void _newButtonActionPerformed(ActionEvent actionEvent) {
        ((NewEntityTypeBasicAction)SystemAction.get(NewEntityTypeBasicAction.class)).performAction();
    }

    private void _importButtonActionPerformed(ActionEvent actionEvent) {
        ((ImportEntitiesAction)SystemAction.get(ImportEntitiesAction.class)).perform();
    }

    private void _exportButtonActionPerformed(ActionEvent actionEvent) {
        ((ExportEntitiesAction)SystemAction.get(ExportEntitiesAction.class)).perform();
    }

    private void _restoreButtonActionPerformed(ActionEvent actionEvent) {
        String string = "Restore Default Entities?";
        String string2 = "Are you sure you want to restore all the default entities? Note that custom entities will not be affected but modification to the default entities will be reverted.";
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
            ((RestoreEntitiesAction)SystemAction.get(RestoreEntitiesAction.class)).perform(true);
        }
    }
}

