/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.typing.DisplayDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;

class DisplayDescriptorNode
extends AbstractNode {
    public DisplayDescriptorNode(DisplayDescriptor displayDescriptor) {
        super(Children.LEAF, Lookups.singleton((Object)displayDescriptor));
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        Sheet.Set set2 = Sheet.createPropertiesSet();
        set2.setName("main");
        set.setName("display");
        set2.setDisplayName("Basic information");
        set.setDisplayName("Display information");
        DisplayDescriptor displayDescriptor = (DisplayDescriptor)this.getLookup().lookup(DisplayDescriptor.class);
        try {
            Node.Property property = this.createReflectionProperty(displayDescriptor, String.class, "DisplayName", "Display name", "The name displayed to the user.");
            Node.Property property2 = this.createReflectionProperty(displayDescriptor, String.class, "Description", "Description", "Short description of this property.");
            Node.Property property3 = this.createReflectionProperty(displayDescriptor, String.class, "getName", null, "Name", "The unique name that references this property.");
            Node.Property property4 = this.createReadOnlyProperty(String.class, displayDescriptor.getTypeDescriptor().toString(), "Type", "The data type of this property.");
            Node.Property property5 = this.createReflectionProperty(displayDescriptor, String.class, "GroupName", "Group", "Optional group name under which this property is visually ordered.");
            RequiredProperty requiredProperty = new RequiredProperty(displayDescriptor);
            ReadonlyProperty readonlyProperty = new ReadonlyProperty(displayDescriptor);
            FormatProperty formatProperty = null;
            if (displayDescriptor.getTypeDescriptor().getFormatAdapter() != null) {
                formatProperty = new FormatProperty(displayDescriptor);
            }
            set2.put(property3);
            set2.put(property4);
            set2.put((Node.Property)requiredProperty);
            set2.put((Node.Property)readonlyProperty);
            set.put(property);
            set.put(property2);
            if (formatProperty != null) {
                set.put((Node.Property)formatProperty);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        sheet.put(set2);
        sheet.put(set);
        return sheet;
    }

    private Node.Property createReadOnlyProperty(Class<?> clazz, final Object object, String string, String string2) {
        PropertySupport.ReadOnly readOnly = new PropertySupport.ReadOnly(string, clazz, string, string2){

            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                return object;
            }
        };
        return readOnly;
    }

    private Node.Property createReflectionProperty(Object object, Class<?> clazz, String string, String string2, String string3) throws NoSuchMethodException {
        PropertySupport.Reflection reflection = new PropertySupport.Reflection(object, clazz, string);
        reflection.setName(string2);
        reflection.setDisplayName(string2);
        reflection.setShortDescription(string3);
        return reflection;
    }

    private Node.Property createReflectionProperty(Object object, Class<?> clazz, String string, String string2, String string3, String string4) throws NoSuchMethodException {
        PropertySupport.Reflection reflection = new PropertySupport.Reflection(object, clazz, string, string2);
        reflection.setName(string3);
        reflection.setDisplayName(string3);
        reflection.setShortDescription(string4);
        return reflection;
    }

    public String getDisplayName() {
        DisplayDescriptor displayDescriptor = (DisplayDescriptor)this.getLookup().lookup(DisplayDescriptor.class);
        return displayDescriptor.getDisplayName();
    }

    public String getShortDescription() {
        DisplayDescriptor displayDescriptor = (DisplayDescriptor)this.getLookup().lookup(DisplayDescriptor.class);
        return displayDescriptor.getDescription();
    }

    private static class ReadonlyProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public ReadonlyProperty(DisplayDescriptor displayDescriptor) {
            super("reaonly", Boolean.class, "Read only", "Indicates that this property cannot be set by the user.");
            this._descriptor = displayDescriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this._descriptor.isReadonly());
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setReadonly(((Boolean)object).booleanValue());
        }
    }

    private static class RequiredProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public RequiredProperty(DisplayDescriptor displayDescriptor) {
            super("required", Boolean.class, "Required", "Indicates that this property cannot be left blank.");
            this._descriptor = displayDescriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(!this._descriptor.isNullable());
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setNullable((Boolean)object == false);
        }
    }

    private static class FormatProperty
    extends PropertySupport.ReadWrite {
        private DisplayDescriptor _descriptor;

        public FormatProperty(DisplayDescriptor displayDescriptor) {
            super("format", String.class, "Format", "Optional format specifier used when rendering values (highly dependant on data type).");
            this._descriptor = displayDescriptor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Format format = this._descriptor.getFormat();
            return this._descriptor.getTypeDescriptor().getFormatString(format);
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this._descriptor.setFormat(this._descriptor.getTypeDescriptor().getFormat((String)object));
        }
    }
}

