/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class PropertyDescriptorProperty
extends Node.Property {
    private DataSource _data;
    private PropertyDescriptor _descriptor;
    private static final ImageIcon EMPTY_ICON = new ImageIcon();

    public PropertyDescriptorProperty(PropertyDescriptor propertyDescriptor, DataSource dataSource) {
        this(propertyDescriptor.getType(), propertyDescriptor, dataSource);
    }

    protected PropertyDescriptorProperty(Class clazz, PropertyDescriptor propertyDescriptor, DataSource dataSource) {
        super(clazz);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        this._data = dataSource;
        this._descriptor = propertyDescriptor;
        this.setName(propertyDescriptor.getName());
        this.setShortDescription(propertyDescriptor.getDescription());
        this.setDisplayName(propertyDescriptor.getDisplayName());
        this.refresh();
    }

    public DataSource getDataSource() {
        return this._data;
    }

    public void setDataSource(DataSource dataSource) {
        this._data = dataSource;
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        return this._descriptor;
    }

    public String getHtmlDisplayName() {
        if (this._descriptor.getHtmlDisplayName() == null) {
            String string;
            String string2;
            block8: {
                string2 = "";
                string = "";
                if (!this.getPropertyDescriptor().isNullable()) {
                    try {
                        Object object = this.getValue();
                        if (object == null || object.toString().isEmpty()) {
                            string2 = "<font color=\"#FF0000\">";
                            string = " *</font>";
                            break block8;
                        }
                        string = "<font color=\"#FF0000\"> *</font> ";
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                } else if (this.getPropertyDescriptor().isHidden()) {
                    string2 = string2 + "<font color=\"#808080\">";
                    string = "</font>" + string;
                }
            }
            return string2 + this.getDisplayName() + string;
        }
        return this._descriptor.getHtmlDisplayName();
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        Object object = this._data.getValue(this._descriptor);
        this.updateDisplay(object);
        return object;
    }

    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this._data.setValue(this._descriptor, object);
        this.updateDisplay(object);
    }

    public boolean isHidden() {
        return this._descriptor.isHidden();
    }

    public boolean canWrite() {
        return !this._descriptor.isReadonly();
    }

    public boolean canRead() {
        return true;
    }

    public void refresh() {
        if (this._descriptor.getImage() != null) {
            this.setValue("nameIcon", new ImageIcon(ImageUtilities.loadImage((String)this._descriptor.getImage())));
        } else {
            this.setValue("nameIcon", EMPTY_ICON);
        }
    }

    protected void updateDisplay(Object object) {
    }
}

