/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.editing.controls.SimpleColorButton;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditorSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.openide.explorer.propertysheet.InplaceEditor;

class ColorPropertyEditor
extends InplacePropertyEditorSupport {
    public ColorPropertyEditor() {
        super(Color.class, null);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        int n = 3;
        Color color = Color.WHITE;
        Object object = this.getValue();
        if (object instanceof Color) {
            color = (Color)object;
        }
        graphics.setColor(color);
        graphics.fillRect(3, 3, rectangle.width - 6, rectangle.height - 6);
    }

    @Override
    public InplaceEditor createEditor() {
        return new ColorInplaceEditor();
    }

    private static class ColorInplaceEditor
    extends InplacePropertyEditor<SimpleColorButton> {
        public ColorInplaceEditor() {
            super(new SimpleColorButton());
        }

        public Object getValue() {
            return ((SimpleColorButton)this.getEditorControl()).getSelectedColor();
        }

        public void setValue(Object object) {
            ((SimpleColorButton)this.getEditorControl()).setSelectedColor((Color)object);
        }

        @Override
        public void reset(Object object) {
            this.setValue(object);
        }
    }
}

