class TourRegistry
  TOURS = {
    first_sign_in: Gem::Version.new('2.0.0.rc2'),
    projects_show: Gem::Version.new('1.11.0')
  }

  def self.display_for?(tour, user)
    latest_version  = TOURS.fetch(tour)
    preference_name = "last_#{tour}".to_sym
    latest_version > Gem::Version.new(user.preferences.send(preference_name))
  end

  def self.displayed_for!(tour, user)
    preference_name = "last_#{tour}="
    user.preferences.send(preference_name, TOURS.fetch(tour).to_s)
    user.save
  end
end