app_root = '/opt/dradispro/dradispro/current'
working_directory app_root
pid "#{app_root}/tmp/pids/dradispro-unicorn.pid"

worker_processes ENV['UNICORN_WORKERS'] || 2

ENV['RAILS_RELATIVE_URL_ROOT'] = '/pro'

# Combine Ruby 2.0 or REE with "preload_app true" for memory savings
# http://rubyenterpriseedition.com/faq.html#adapt_apps_for_cow
preload_app true
GC.respond_to?(:copy_on_write_friendly=) and
  GC.copy_on_write_friendly = true

if ENV['RACK_ENV'] == 'production'
  # restart inactive workers
  timeout 30

  # listen on unix socket (for nginx)
  listen "#{app_root}/tmp/sockets/unicorn.sock", backlog: 128

  # logs
  stderr_path "#{app_root}/log/unicorn.err.log"
  stdout_path "#{app_root}/log/unicorn.out.log"
else
  listen '127.0.0.1:3000'
end

# Make sure we get the latest Gemfile when doing a hot-reload of unicorn.
# See:
#   www.justinappears.com/blog/2-no-downtime-deploys-with-unicorn/#changing-the-source-location-on-deploy-and-using-bundler
before_exec do |server|
  ENV["BUNDLE_GEMFILE"] = "#{app_root}/Gemfile"
end

before_fork do |server, worker|
  # Give the workers some time to boot
  sleep(rand * 0.5) if ENV['RACK_ENV'] == 'production'


  # Disconnect since the database connection will not carry over
  if defined? ActiveRecord::Base
    ActiveRecord::Base.connection.disconnect!
  end

  ##
  # When sent a USR2, Unicorn will suffix its pidfile with .oldbin and
  # immediately start loading up a new version of itself (loaded with a new
  # version of our app). When this new Unicorn is completely loaded
  # it will begin spawning workers. The first worker spawned will check to
  # see if an .oldbin pidfile exists. If so, this means we've just booted up
  # a new Unicorn and need to tell the old one that it can now die. To do so
  # we send it a QUIT.
  #
  # Using this method we get 0 downtime deploys.

  # Quit the old unicorn process
  old_pid = "#{server.config[:pid]}.oldbin"
  if File.exists?(old_pid) && server.pid != old_pid
    begin
      Process.kill("QUIT", File.read(old_pid).to_i)
    rescue Errno::ENOENT, Errno::ESRCH
      # someone else did our job for us
    end
  end
end

after_fork do |server, worker|
  # Start up the database connection again in the worker
  if defined?(ActiveRecord::Base)
    ActiveRecord::Base.establish_connection
  end
end