/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.codegen.ClassGen;
import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.annotations.Annotation;
import jadx.core.dex.attributes.annotations.AnnotationsList;
import jadx.core.dex.attributes.annotations.MethodParameters;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnnotationGen {
    private final ClassNode cls;
    private final ClassGen classGen;

    public AnnotationGen(ClassNode cls, ClassGen classGen) {
        this.cls = cls;
        this.classGen = classGen;
    }

    public void addForClass(CodeWriter code) {
        this.add(this.cls, code);
    }

    public void addForMethod(CodeWriter code, MethodNode mth) {
        this.add(mth, code);
    }

    public void addForField(CodeWriter code, FieldNode field) {
        this.add(field, code);
    }

    public void addForParameter(CodeWriter code, MethodParameters paramsAnnotations, int n) {
        AnnotationsList aList = paramsAnnotations.getParamList().get(n);
        if (aList == null || aList.isEmpty()) {
            return;
        }
        for (Annotation a : aList.getAll()) {
            this.formatAnnotation(code, a);
            code.add(' ');
        }
    }

    private void add(IAttributeNode node, CodeWriter code) {
        AnnotationsList aList = node.get(AType.ANNOTATION_LIST);
        if (aList == null || aList.isEmpty()) {
            return;
        }
        for (Annotation a : aList.getAll()) {
            String aCls = a.getAnnotationClass();
            if (aCls.startsWith("dalvik.annotation.")) continue;
            code.startLine();
            this.formatAnnotation(code, a);
        }
    }

    private void formatAnnotation(CodeWriter code, Annotation a) {
        code.add('@');
        this.classGen.useType(code, a.getType());
        Map<String, Object> vl = a.getValues();
        if (!vl.isEmpty()) {
            code.add('(');
            if (vl.size() == 1 && vl.containsKey("value")) {
                this.encodeValue(code, vl.get("value"));
            } else {
                Iterator<Map.Entry<String, Object>> it = vl.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Object> e = it.next();
                    code.add(e.getKey());
                    code.add(" = ");
                    this.encodeValue(code, e.getValue());
                    if (!it.hasNext()) continue;
                    code.add(", ");
                }
            }
            code.add(')');
        }
    }

    public void addThrows(MethodNode mth, CodeWriter code) {
        Annotation an = mth.getAnnotation("dalvik.annotation.Throws");
        if (an != null) {
            Object exs = an.getDefaultValue();
            code.add(" throws ");
            Iterator it = ((List)exs).iterator();
            while (it.hasNext()) {
                ArgType ex = (ArgType)it.next();
                this.classGen.useType(code, ex);
                if (!it.hasNext()) continue;
                code.add(", ");
            }
        }
    }

    public Object getAnnotationDefaultValue(String name) {
        Annotation an = this.cls.getAnnotation("dalvik.annotation.AnnotationDefault");
        if (an != null) {
            Annotation defAnnotation = (Annotation)an.getDefaultValue();
            return defAnnotation.getValues().get(name);
        }
        return null;
    }

    public void encodeValue(CodeWriter code, Object val) {
        if (val == null) {
            code.add("null");
            return;
        }
        if (val instanceof String) {
            code.add(StringUtils.unescapeString((String)val));
        } else if (val instanceof Integer) {
            code.add(TypeGen.formatInteger((Integer)val));
        } else if (val instanceof Character) {
            code.add(StringUtils.unescapeChar(((Character)val).charValue()));
        } else if (val instanceof Boolean) {
            code.add(Boolean.TRUE.equals(val) ? "true" : "false");
        } else if (val instanceof Float) {
            code.add(TypeGen.formatFloat(((Float)val).floatValue()));
        } else if (val instanceof Double) {
            code.add(TypeGen.formatDouble((Double)val));
        } else if (val instanceof Long) {
            code.add(TypeGen.formatLong((Long)val));
        } else if (val instanceof Short) {
            code.add(TypeGen.formatShort((Short)val));
        } else if (val instanceof Byte) {
            code.add(TypeGen.formatByte((Byte)val));
        } else if (val instanceof ArgType) {
            this.classGen.useType(code, (ArgType)val);
            code.add(".class");
        } else if (val instanceof FieldInfo) {
            FieldInfo field = (FieldInfo)val;
            InsnGen.makeStaticFieldAccess(code, field, this.classGen);
        } else if (val instanceof Iterable) {
            code.add('{');
            Iterator it = ((Iterable)val).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.encodeValue(code, obj);
                if (!it.hasNext()) continue;
                code.add(", ");
            }
            code.add('}');
        } else if (val instanceof Annotation) {
            this.formatAnnotation(code, (Annotation)val);
        } else {
            throw new JadxRuntimeException("Can't decode value: " + val + " (" + val.getClass() + ")");
        }
    }
}

