/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import com.android.dex.FieldId;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;

public class FieldInfo {
    private final ClassInfo declClass;
    private final String name;
    private final ArgType type;

    public FieldInfo(ClassInfo declClass, String name, ArgType type) {
        this.declClass = declClass;
        this.name = name;
        this.type = type;
    }

    public static FieldInfo fromDex(DexNode dex, int index) {
        FieldId field = dex.getFieldId(index);
        return new FieldInfo(ClassInfo.fromDex(dex, field.getDeclaringClassIndex()), dex.getString(field.getNameIndex()), dex.getType(field.getTypeIndex()));
    }

    public static String getNameById(DexNode dex, int ind) {
        return dex.getString(dex.getFieldId(ind).getNameIndex());
    }

    public String getName() {
        return this.name;
    }

    public ArgType getType() {
        return this.type;
    }

    public ClassInfo getDeclClass() {
        return this.declClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        if (!this.name.equals(fieldInfo.name)) {
            return false;
        }
        if (!this.type.equals(fieldInfo.type)) {
            return false;
        }
        return this.declClass.equals(fieldInfo.declClass);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.declClass.hashCode();
        return result;
    }

    public String toString() {
        return this.declClass + "." + this.name + " " + this.type;
    }
}

