/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dx.io.instructions.FillArrayDataPayloadDecodedInstruction;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.exceptions.JadxRuntimeException;

public final class FillArrayNode
extends InsnNode {
    private final Object data;
    private ArgType elemType;

    public FillArrayNode(int resReg, FillArrayDataPayloadDecodedInstruction payload) {
        super(InsnType.FILL_ARRAY, 0);
        ArgType elType;
        switch (payload.getElementWidthUnit()) {
            case 1: {
                elType = ArgType.unknown(PrimitiveType.BOOLEAN, PrimitiveType.BYTE);
                break;
            }
            case 2: {
                elType = ArgType.unknown(PrimitiveType.SHORT, PrimitiveType.CHAR);
                break;
            }
            case 4: {
                elType = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT);
                break;
            }
            case 8: {
                elType = ArgType.unknown(PrimitiveType.LONG, PrimitiveType.DOUBLE);
                break;
            }
            default: {
                throw new JadxRuntimeException("Unknown array element width: " + payload.getElementWidthUnit());
            }
        }
        this.setResult(InsnArg.reg(resReg, ArgType.array(elType)));
        this.data = payload.getData();
        this.elemType = elType;
    }

    public Object getData() {
        return this.data;
    }

    public ArgType getElementType() {
        return this.elemType;
    }

    public void mergeElementType(ArgType foundElemType) {
        ArgType r = ArgType.merge(this.elemType, foundElemType);
        if (r != null) {
            this.elemType = r;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FillArrayNode) || !super.equals(obj)) {
            return false;
        }
        FillArrayNode that = (FillArrayNode)obj;
        return this.elemType.equals(that.elemType) && this.data == that.data;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.elemType.hashCode() + this.data.hashCode();
    }
}

