/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.codegen.TypeGen;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.utils.exceptions.JadxRuntimeException;

public final class LiteralArg
extends InsnArg {
    public static final LiteralArg TRUE = new LiteralArg(1L, ArgType.BOOLEAN);
    public static final LiteralArg FALSE = new LiteralArg(0L, ArgType.BOOLEAN);
    private final long literal;

    public LiteralArg(long value, ArgType type) {
        if (value != 0L) {
            ArgType m;
            if (type.isObject()) {
                throw new JadxRuntimeException("Wrong literal type: " + type + " for value: " + value);
            }
            if (!(type.isTypeKnown() || type.contains(PrimitiveType.LONG) || type.contains(PrimitiveType.DOUBLE) || (m = ArgType.merge(type, ArgType.NARROW_NUMBERS)) == null)) {
                type = m;
            }
        }
        this.literal = value;
        this.type = type;
    }

    public long getLiteral() {
        return this.literal;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public boolean isInteger() {
        PrimitiveType type = this.type.getPrimitiveType();
        return type == PrimitiveType.INT || type == PrimitiveType.BYTE || type == PrimitiveType.CHAR || type == PrimitiveType.SHORT || type == PrimitiveType.LONG;
    }

    public int hashCode() {
        return (int)(this.literal ^ this.literal >>> 32) + 31 * this.getType().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralArg that = (LiteralArg)o;
        return this.literal == that.literal && this.getType().equals(that.getType());
    }

    public String toString() {
        try {
            String value = TypeGen.literalToString(this.literal, this.getType());
            if (this.getType().equals(ArgType.BOOLEAN) && (value.equals("true") || value.equals("false"))) {
                return value;
            }
            return "(" + value + " " + this.type + ")";
        }
        catch (JadxRuntimeException ex) {
            return "(" + this.literal + " " + this.type + ")";
        }
    }
}

