/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.BlockProcessingHelper;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlockMakerVisitor
extends AbstractVisitor {
    private static final Set<InsnType> SEPARATE_INSNS = EnumSet.of(InsnType.RETURN, InsnType.IF, InsnType.SWITCH, InsnType.MONITOR_ENTER, InsnType.MONITOR_EXIT);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        mth.initBasicBlocks();
        BlockMakerVisitor.splitBasicBlocks(mth);
        BlockMakerVisitor.processBlocksTree(mth);
        BlockProcessingHelper.visit(mth);
        mth.finishBasicBlocks();
    }

    private static void splitBasicBlocks(MethodNode mth) {
        InsnNode prevInsn = null;
        HashMap<Integer, BlockNode> blocksMap = new HashMap<Integer, BlockNode>();
        BlockNode curBlock = BlockMakerVisitor.startNewBlock(mth, 0);
        mth.setEnterBlock(curBlock);
        for (InsnNode insn : mth.getInstructions()) {
            if (insn == null) continue;
            boolean startNew = false;
            if (prevInsn != null) {
                BlockNode block;
                InsnType type = prevInsn.getType();
                if (type == InsnType.GOTO || type == InsnType.THROW || SEPARATE_INSNS.contains((Object)type)) {
                    if (type == InsnType.RETURN || type == InsnType.THROW) {
                        mth.addExitBlock(curBlock);
                    }
                    block = BlockMakerVisitor.startNewBlock(mth, insn.getOffset());
                    if (type == InsnType.MONITOR_ENTER || type == InsnType.MONITOR_EXIT) {
                        BlockMakerVisitor.connect(curBlock, block);
                    }
                    curBlock = block;
                    startNew = true;
                } else {
                    boolean bl = startNew = BlockMakerVisitor.isSplitByJump(prevInsn, insn) || SEPARATE_INSNS.contains((Object)insn.getType()) || BlockMakerVisitor.isDoWhile(blocksMap, curBlock, insn);
                    if (startNew) {
                        block = BlockMakerVisitor.startNewBlock(mth, insn.getOffset());
                        BlockMakerVisitor.connect(curBlock, block);
                        curBlock = block;
                    }
                }
            }
            if (insn.contains(AFlag.TRY_ENTER)) {
                BlockNode block;
                if (insn.getOffset() != 0 && !startNew) {
                    block = BlockMakerVisitor.startNewBlock(mth, insn.getOffset());
                    BlockMakerVisitor.connect(curBlock, block);
                    curBlock = block;
                }
                blocksMap.put(insn.getOffset(), curBlock);
                block = BlockMakerVisitor.startNewBlock(mth, -1);
                curBlock.add(AFlag.SYNTHETIC);
                SplitterBlockAttr splitter = new SplitterBlockAttr(curBlock);
                block.addAttr(splitter);
                curBlock.addAttr(splitter);
                BlockMakerVisitor.connect(curBlock, block);
                curBlock = block;
            } else {
                blocksMap.put(insn.getOffset(), curBlock);
            }
            curBlock.getInstructions().add(insn);
            prevInsn = insn;
        }
        BlockMakerVisitor.setupConnections(mth, blocksMap);
    }

    private static void setupConnections(MethodNode mth, Map<Integer, BlockNode> blocksMap) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                List jumps = insn.getAll(AType.JUMP);
                for (JumpInfo jump : jumps) {
                    BlockNode srcBlock = BlockMakerVisitor.getBlock(jump.getSrc(), blocksMap);
                    BlockNode thisBlock = BlockMakerVisitor.getBlock(jump.getDest(), blocksMap);
                    BlockMakerVisitor.connect(srcBlock, thisBlock);
                }
                CatchAttr catches = insn.get(AType.CATCH_BLOCK);
                SplitterBlockAttr spl = block.get(AType.SPLITTER_BLOCK);
                if (catches == null || spl == null) continue;
                BlockNode splitterBlock = spl.getBlock();
                boolean tryEnd = insn.contains(AFlag.TRY_LEAVE);
                for (ExceptionHandler h : catches.getTryBlock().getHandlers()) {
                    BlockNode handlerBlock = BlockMakerVisitor.getBlock(h.getHandleOffset(), blocksMap);
                    if (splitterBlock != handlerBlock) {
                        BlockMakerVisitor.connect(splitterBlock, handlerBlock);
                    }
                    if (!tryEnd) continue;
                    BlockMakerVisitor.connect(block, handlerBlock);
                }
            }
        }
    }

    private static boolean isSplitByJump(InsnNode prevInsn, InsnNode currentInsn) {
        List pJumps = prevInsn.getAll(AType.JUMP);
        for (JumpInfo jump : pJumps) {
            if (jump.getSrc() != prevInsn.getOffset()) continue;
            return true;
        }
        List cJumps = currentInsn.getAll(AType.JUMP);
        for (JumpInfo jump : cJumps) {
            if (jump.getDest() != currentInsn.getOffset()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDoWhile(Map<Integer, BlockNode> blocksMap, BlockNode curBlock, InsnNode insn) {
        IfNode ifs;
        BlockNode targetBlock;
        return insn.getType() == InsnType.IF && (targetBlock = blocksMap.get((ifs = (IfNode)insn).getTarget())) == curBlock;
    }

    private static void processBlocksTree(MethodNode mth) {
        BlockMakerVisitor.computeDominators(mth);
        BlockMakerVisitor.markReturnBlocks(mth);
        int i = 0;
        while (BlockMakerVisitor.modifyBlocksTree(mth)) {
            BlockMakerVisitor.clearBlocksState(mth);
            BlockMakerVisitor.computeDominators(mth);
            BlockMakerVisitor.markReturnBlocks(mth);
            if (i++ > 100) {
                throw new AssertionError((Object)("Can't fix method cfg: " + mth));
            }
        }
        BlockMakerVisitor.computeDominanceFrontier(mth);
        BlockMakerVisitor.registerLoops(mth);
        BlockMakerVisitor.processNestedLoops(mth);
    }

    private static BlockNode getBlock(int offset, Map<Integer, BlockNode> blocksMap) {
        BlockNode block = blocksMap.get(offset);
        assert (block != null);
        return block;
    }

    private static void connect(BlockNode from, BlockNode to) {
        if (!from.getSuccessors().contains(to)) {
            from.getSuccessors().add(to);
        }
        if (!to.getPredecessors().contains(from)) {
            to.getPredecessors().add(from);
        }
    }

    private static void removeConnection(BlockNode from, BlockNode to) {
        from.getSuccessors().remove(to);
        to.getPredecessors().remove(from);
    }

    private static BlockNode startNewBlock(MethodNode mth, int offset) {
        BlockNode block = new BlockNode(mth.getBasicBlocks().size(), offset);
        mth.getBasicBlocks().add(block);
        return block;
    }

    private static void computeDominators(MethodNode mth) {
        boolean changed;
        List<BlockNode> basicBlocks = mth.getBasicBlocks();
        int nBlocks = basicBlocks.size();
        for (int i = 0; i < nBlocks; ++i) {
            BlockNode block = basicBlocks.get(i);
            block.setId(i);
            block.setDoms(new BitSet(nBlocks));
            block.getDoms().set(0, nBlocks);
        }
        BlockNode entryBlock = mth.getEnterBlock();
        entryBlock.getDoms().clear();
        entryBlock.getDoms().set(entryBlock.getId());
        BitSet dset = new BitSet(nBlocks);
        do {
            changed = false;
            for (BlockNode block : basicBlocks) {
                if (block == entryBlock) continue;
                BitSet d = block.getDoms();
                if (!changed) {
                    dset.clear();
                    dset.or(d);
                }
                for (BlockNode pred : block.getPredecessors()) {
                    d.and(pred.getDoms());
                }
                d.set(block.getId());
                if (changed || d.equals(dset)) continue;
                changed = true;
            }
        } while (changed);
        BlockMakerVisitor.markLoops(mth);
        for (BlockNode block : basicBlocks) {
            block.getDoms().clear(block.getId());
        }
        for (BlockNode block : basicBlocks) {
            BlockNode idom;
            if (block == entryBlock) continue;
            List<BlockNode> preds = block.getPredecessors();
            if (preds.size() == 1) {
                idom = preds.get(0);
            } else {
                BitSet bs = new BitSet(block.getDoms().length());
                bs.or(block.getDoms());
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    BlockNode dom = basicBlocks.get(i);
                    bs.andNot(dom.getDoms());
                    i = bs.nextSetBit(i + 1);
                }
                if (bs.cardinality() != 1) {
                    throw new JadxRuntimeException("Can't find immediate dominator for block " + block + " in " + bs + " preds:" + preds);
                }
                idom = basicBlocks.get(bs.nextSetBit(0));
            }
            block.setIDom(idom);
            idom.addDominatesOn(block);
        }
    }

    private static void computeDominanceFrontier(MethodNode mth) {
        for (BlockNode exit : mth.getExitBlocks()) {
            exit.setDomFrontier(EmptyBitSet.EMPTY);
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockMakerVisitor.computeBlockDF(mth, block);
        }
    }

    private static void computeBlockDF(MethodNode mth, BlockNode block) {
        for (BlockNode c : block.getDominatesOn()) {
            BlockMakerVisitor.computeBlockDF(mth, c);
        }
        BitSet domFrontier = null;
        for (BlockNode s : block.getSuccessors()) {
            if (s.getIDom() == block) continue;
            if (domFrontier == null) {
                domFrontier = new BitSet();
            }
            domFrontier.set(s.getId());
        }
        for (BlockNode c : block.getDominatesOn()) {
            BitSet frontier = c.getDomFrontier();
            int p = frontier.nextSetBit(0);
            while (p >= 0) {
                if (mth.getBasicBlocks().get(p).getIDom() != block) {
                    if (domFrontier == null) {
                        domFrontier = new BitSet();
                    }
                    domFrontier.set(p);
                }
                p = frontier.nextSetBit(p + 1);
            }
        }
        if (domFrontier == null || domFrontier.cardinality() == 0) {
            domFrontier = EmptyBitSet.EMPTY;
        }
        block.setDomFrontier(domFrontier);
    }

    private static void markReturnBlocks(MethodNode mth) {
        mth.getExitBlocks().clear();
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!BlockUtils.checkLastInsnType(block, InsnType.RETURN)) continue;
            block.add(AFlag.RETURN);
            mth.getExitBlocks().add(block);
        }
    }

    private static void markLoops(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (BlockNode succ : block.getSuccessors()) {
                if (!block.getDoms().get(succ.getId())) continue;
                succ.add(AFlag.LOOP_START);
                block.add(AFlag.LOOP_END);
                LoopInfo loop = new LoopInfo(succ, block);
                succ.addAttr(AType.LOOP, loop);
                block.addAttr(AType.LOOP, loop);
            }
        }
    }

    private static void registerLoops(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!block.contains(AFlag.LOOP_START)) continue;
            for (LoopInfo loop : block.getAll(AType.LOOP)) {
                mth.registerLoop(loop);
            }
        }
    }

    private static void processNestedLoops(MethodNode mth) {
        if (mth.getLoopsCount() == 0) {
            return;
        }
        for (LoopInfo outLoop : mth.getLoops()) {
            for (LoopInfo innerLoop : mth.getLoops()) {
                if (outLoop == innerLoop || !outLoop.getLoopBlocks().containsAll(innerLoop.getLoopBlocks())) continue;
                LoopInfo parentLoop = innerLoop.getParentLoop();
                if (parentLoop != null) {
                    if (parentLoop.getLoopBlocks().containsAll(outLoop.getLoopBlocks())) {
                        outLoop.setParentLoop(parentLoop);
                        innerLoop.setParentLoop(outLoop);
                        continue;
                    }
                    parentLoop.setParentLoop(outLoop);
                    continue;
                }
                innerLoop.setParentLoop(outLoop);
            }
        }
    }

    private static boolean modifyBlocksTree(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockNode loopEnd;
            if (block.getPredecessors().isEmpty() && block != mth.getEnterBlock()) {
                throw new JadxRuntimeException("Unreachable block: " + block);
            }
            List loops = block.getAll(AType.LOOP);
            if (loops.size() > 1) {
                boolean oneHeader = true;
                for (LoopInfo loop : loops) {
                    if (loop.getStart() == block) continue;
                    oneHeader = false;
                    break;
                }
                if (oneHeader) {
                    BlockNode newLoopHeader = BlockMakerVisitor.startNewBlock(mth, block.getStartOffset());
                    newLoopHeader.add(AFlag.SYNTHETIC);
                    BlockMakerVisitor.connect(newLoopHeader, block);
                    for (LoopInfo la : loops) {
                        BlockNode node = la.getEnd();
                        BlockMakerVisitor.removeConnection(node, block);
                        BlockMakerVisitor.connect(node, newLoopHeader);
                    }
                    return true;
                }
            }
            if (loops.size() != 1) continue;
            LoopInfo loop = (LoopInfo)loops.get(0);
            List<Edge> edges = loop.getExitEdges();
            if (!edges.isEmpty()) {
                boolean change = false;
                for (Edge edge : edges) {
                    BlockNode target = edge.getTarget();
                    if (target.contains(AFlag.SYNTHETIC)) continue;
                    BlockMakerVisitor.insertBlockBetween(mth, edge.getSource(), target);
                    change = true;
                }
                if (change) {
                    return true;
                }
            }
            if ((loopEnd = loop.getEnd()).getPredecessors().size() <= 1) continue;
            boolean change = false;
            ArrayList<BlockNode> nodes = new ArrayList<BlockNode>(loopEnd.getPredecessors());
            for (BlockNode pred : nodes) {
                if (pred.contains(AFlag.SYNTHETIC)) continue;
                BlockMakerVisitor.insertBlockBetween(mth, pred, loopEnd);
                change = true;
            }
            if (!change) continue;
            return true;
        }
        return BlockMakerVisitor.splitReturn(mth);
    }

    private static BlockNode insertBlockBetween(MethodNode mth, BlockNode source, BlockNode target) {
        BlockNode newBlock = BlockMakerVisitor.startNewBlock(mth, target.getStartOffset());
        newBlock.add(AFlag.SYNTHETIC);
        BlockMakerVisitor.removeConnection(source, target);
        BlockMakerVisitor.connect(source, newBlock);
        BlockMakerVisitor.connect(newBlock, target);
        return newBlock;
    }

    private static boolean splitReturn(MethodNode mth) {
        if (mth.getExitBlocks().size() != 1) {
            return false;
        }
        BlockNode exitBlock = mth.getExitBlocks().get(0);
        if (exitBlock.getPredecessors().size() > 1 && exitBlock.getInstructions().size() == 1 && !exitBlock.contains(AFlag.SYNTHETIC)) {
            InsnNode returnInsn = exitBlock.getInstructions().get(0);
            ArrayList<BlockNode> preds = new ArrayList<BlockNode>(exitBlock.getPredecessors());
            if (returnInsn.getArgsCount() != 0 && !BlockMakerVisitor.isReturnArgAssignInPred(preds, returnInsn)) {
                return false;
            }
            boolean first = true;
            for (BlockNode pred : preds) {
                InsnNode newRetInsn;
                BlockNode newRetBlock = BlockMakerVisitor.startNewBlock(mth, exitBlock.getStartOffset());
                newRetBlock.add(AFlag.SYNTHETIC);
                if (first) {
                    newRetInsn = returnInsn;
                    first = false;
                } else {
                    newRetInsn = BlockMakerVisitor.duplicateReturnInsn(returnInsn);
                }
                newRetBlock.getInstructions().add(newRetInsn);
                BlockMakerVisitor.removeConnection(pred, exitBlock);
                BlockMakerVisitor.connect(pred, newRetBlock);
            }
            BlockMakerVisitor.cleanExitNodes(mth);
            return true;
        }
        return false;
    }

    private static boolean isReturnArgAssignInPred(List<BlockNode> preds, InsnNode returnInsn) {
        RegisterArg arg = (RegisterArg)returnInsn.getArg(0);
        int regNum = arg.getRegNum();
        for (BlockNode pred : preds) {
            for (InsnNode insnNode : pred.getInstructions()) {
                RegisterArg result = insnNode.getResult();
                if (result == null || result.getRegNum() != regNum) continue;
                return true;
            }
        }
        return false;
    }

    private static void cleanExitNodes(MethodNode mth) {
        Iterator<BlockNode> iterator = mth.getExitBlocks().iterator();
        while (iterator.hasNext()) {
            BlockNode exitBlock = iterator.next();
            if (!exitBlock.getPredecessors().isEmpty()) continue;
            mth.getBasicBlocks().remove(exitBlock);
            iterator.remove();
        }
    }

    private static InsnNode duplicateReturnInsn(InsnNode returnInsn) {
        InsnNode insn = new InsnNode(returnInsn.getType(), returnInsn.getArgsCount());
        if (returnInsn.getArgsCount() == 1) {
            RegisterArg arg = (RegisterArg)returnInsn.getArg(0);
            insn.addArg(InsnArg.reg(arg.getRegNum(), arg.getType()));
        }
        insn.copyAttributesFrom(returnInsn);
        insn.setOffset(returnInsn.getOffset());
        insn.setSourceLine(returnInsn.getSourceLine());
        return insn;
    }

    private static void clearBlocksState(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            block.remove(AType.LOOP);
            block.remove(AFlag.LOOP_START);
            block.remove(AFlag.LOOP_END);
            block.setDoms(null);
            block.setIDom(null);
            block.setDomFrontier(null);
            block.getDominatesOn().clear();
        }
    }
}

