/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.MethodInlineAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.exceptions.JadxException;

public class MethodInlineVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        BlockNode block;
        AccessInfo accessFlags = mth.getAccessFlags();
        if (accessFlags.isSynthetic() && accessFlags.isStatic() && mth.getBasicBlocks().size() == 2 && ((block = mth.getBasicBlocks().get(1)).getInstructions().isEmpty() || block.contains(AFlag.RETURN))) {
            MethodInlineVisitor.inlineMth(mth);
        }
    }

    private static void inlineMth(MethodNode mth) {
        BlockNode firstBlock = mth.getBasicBlocks().get(0);
        if (firstBlock.getInstructions().isEmpty()) {
            BlockNode block = mth.getBasicBlocks().get(1);
            InsnNode insn = block.getInstructions().get(0);
            MethodInlineVisitor.addInlineAttr(mth, InsnNode.wrapArg(insn.getArg(0)));
        } else if (firstBlock.getInstructions().size() == 1) {
            MethodInlineVisitor.addInlineAttr(mth, firstBlock.getInstructions().get(0));
        }
    }

    private static void addInlineAttr(MethodNode mth, InsnNode insn) {
        mth.addAttr(new MethodInlineAttr(insn));
        mth.add(AFlag.DONT_GENERATE);
    }
}

