/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.dex.visitors.regions.IRegionVisitor;
import jadx.core.dex.visitors.regions.TernaryMod;
import jadx.core.utils.RegionUtils;
import java.util.List;

public class IfRegionVisitor
extends AbstractVisitor
implements IRegionVisitor,
IRegionIterativeVisitor {
    @Override
    public void visit(MethodNode mth) {
        DepthRegionTraversal.traverseAllIterative(mth, new IRegionIterativeVisitor(){

            @Override
            public boolean visitRegion(MethodNode mth, IRegion region) {
                if (region instanceof IfRegion) {
                    return TernaryMod.makeTernaryInsn(mth, (IfRegion)region);
                }
                return false;
            }
        });
        DepthRegionTraversal.traverseAll(mth, this);
        DepthRegionTraversal.traverseAllIterative(mth, this);
    }

    @Override
    public void enterRegion(MethodNode mth, IRegion region) {
        if (region instanceof IfRegion) {
            IfRegionVisitor.processIfRegion(mth, (IfRegion)region);
        }
    }

    @Override
    public boolean visitRegion(MethodNode mth, IRegion region) {
        if (region instanceof IfRegion) {
            return IfRegionVisitor.removeRedundantElseBlock(mth, (IfRegion)region);
        }
        return false;
    }

    @Override
    public void processBlock(MethodNode mth, IBlock container) {
    }

    @Override
    public void leaveRegion(MethodNode mth, IRegion region) {
    }

    private static void processIfRegion(MethodNode mth, IfRegion ifRegion) {
        IfRegionVisitor.simplifyIfCondition(ifRegion);
        IfRegionVisitor.moveReturnToThenBlock(mth, ifRegion);
        IfRegionVisitor.moveBreakToThenBlock(ifRegion);
        IfRegionVisitor.markElseIfChains(ifRegion);
    }

    private static void simplifyIfCondition(IfRegion ifRegion) {
        IContainer elseRegion;
        IfCondition condition;
        if (ifRegion.simplifyCondition() && (condition = ifRegion.getCondition()).getMode() == IfCondition.Mode.NOT) {
            IfRegionVisitor.invertIfRegion(ifRegion);
        }
        if ((elseRegion = ifRegion.getElseRegion()) == null || RegionUtils.isEmpty(elseRegion)) {
            return;
        }
        boolean thenIsEmpty = RegionUtils.isEmpty(ifRegion.getThenRegion());
        if (thenIsEmpty || IfRegionVisitor.hasSimpleReturnBlock(ifRegion.getThenRegion())) {
            IfRegionVisitor.invertIfRegion(ifRegion);
        }
        if (!thenIsEmpty && IfRegionVisitor.isIfRegion(ifRegion.getThenRegion()) && !IfRegionVisitor.isIfRegion(elseRegion)) {
            IfRegionVisitor.invertIfRegion(ifRegion);
        }
    }

    private static boolean isIfRegion(IContainer container) {
        List<IContainer> subBlocks;
        if (container instanceof IfRegion) {
            return true;
        }
        return container instanceof IRegion && (subBlocks = ((IRegion)container).getSubBlocks()).size() == 1 && subBlocks.get(0) instanceof IfRegion;
    }

    private static void moveReturnToThenBlock(MethodNode mth, IfRegion ifRegion) {
        if (!mth.getReturnType().equals(ArgType.VOID) && IfRegionVisitor.hasSimpleReturnBlock(ifRegion.getElseRegion())) {
            IfRegionVisitor.invertIfRegion(ifRegion);
        }
    }

    private static void moveBreakToThenBlock(IfRegion ifRegion) {
        if (ifRegion.getElseRegion() != null && RegionUtils.hasBreakInsn(ifRegion.getElseRegion())) {
            IfRegionVisitor.invertIfRegion(ifRegion);
        }
    }

    private static void markElseIfChains(IfRegion ifRegion) {
        List<IContainer> subBlocks;
        if (IfRegionVisitor.hasSimpleReturnBlock(ifRegion.getThenRegion())) {
            return;
        }
        IContainer elsRegion = ifRegion.getElseRegion();
        if (elsRegion instanceof Region && (subBlocks = ((Region)elsRegion).getSubBlocks()).size() == 1 && subBlocks.get(0) instanceof IfRegion) {
            subBlocks.get(0).add(AFlag.ELSE_IF_CHAIN);
            elsRegion.add(AFlag.ELSE_IF_CHAIN);
        }
    }

    private static boolean removeRedundantElseBlock(MethodNode mth, IfRegion ifRegion) {
        Region newRegion;
        if (ifRegion.getElseRegion() == null || ifRegion.contains(AFlag.ELSE_IF_CHAIN) || ifRegion.getElseRegion().contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        if (!IfRegionVisitor.hasBranchTerminator(ifRegion.getThenRegion())) {
            return false;
        }
        if (mth.getReturnType() == ArgType.VOID && RegionUtils.insnsCount(ifRegion.getThenRegion()) == 2 && RegionUtils.insnsCount(ifRegion.getElseRegion()) == 2) {
            return false;
        }
        IRegion parent = ifRegion.getParent();
        if (parent.replaceSubBlock(ifRegion, newRegion = new Region(parent))) {
            newRegion.add(ifRegion);
            newRegion.add(ifRegion.getElseRegion());
            ifRegion.setElseRegion(null);
            return true;
        }
        return false;
    }

    private static boolean hasBranchTerminator(IContainer region) {
        return RegionUtils.hasExitBlock(region) || RegionUtils.hasBreakInsn(region);
    }

    private static void invertIfRegion(IfRegion ifRegion) {
        IContainer elseRegion = ifRegion.getElseRegion();
        if (elseRegion != null) {
            ifRegion.invert();
        }
    }

    private static boolean hasSimpleReturnBlock(IContainer region) {
        if (region == null) {
            return false;
        }
        if (region.contains(AFlag.RETURN)) {
            return true;
        }
        if (region instanceof IRegion) {
            List<IContainer> subBlocks = ((IRegion)region).getSubBlocks();
            return subBlocks.size() == 1 && subBlocks.get(0).contains(AFlag.RETURN);
        }
        return false;
    }
}

