/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.api.IJadxArgs;
import jadx.cli.JadxCLIArgs;
import jadx.gui.JadxWrapper;
import jadx.gui.ui.MainWindow;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxGUI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxGUI.class);

    public static void main(String[] args) {
        try {
            final JadxCLIArgs jadxArgs = new JadxCLIArgs();
            if (!jadxArgs.processArgs(args)) {
                return;
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JadxWrapper wrapper = new JadxWrapper((IJadxArgs)jadxArgs);
                    MainWindow window = new MainWindow(wrapper);
                    window.pack();
                    window.setLocationAndPosition();
                    window.setVisible(true);
                    window.setLocationRelativeTo(null);
                    window.setDefaultCloseOperation(2);
                    if (jadxArgs.getInput().isEmpty()) {
                        window.openFile();
                    } else {
                        window.openFile((File)jadxArgs.getInput().get(0));
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.error("Error: " + e.getMessage());
            System.exit(1);
        }
    }
}

