/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.util.HashSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.mibble.MibFileRef;

class MibAnalyzerUtil {
    MibAnalyzerUtil() {
    }

    static boolean isBitValue(Node node) {
        if (node.getId() == 1004) {
            return true;
        }
        if (node.getId() == 2079 && node.getChildCount() < 4) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!MibAnalyzerUtil.isBitValue(node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    static MibFileRef getFileRef(File file, Node node) {
        MibFileRef ref = new MibFileRef(file, node.getStartLine(), node.getStartColumn());
        Token comment = MibAnalyzerUtil.findCommentTokenBefore(node, null);
        if (comment != null) {
            ref.lineCommentStart = comment.getStartLine();
        }
        ref.lineEnd = node.getEndLine();
        return ref;
    }

    static String getText(Node node) {
        StringBuilder buffer = new StringBuilder();
        Token token = MibAnalyzerUtil.findCommentTokenBefore(node, null);
        if (token == null) {
            token = MibAnalyzerUtil.findFirstToken(node);
        }
        Token lastToken = MibAnalyzerUtil.findLastToken(node);
        while (token != null && token != lastToken) {
            buffer.append(token.getImage());
            token = token.getNextToken();
        }
        if (lastToken != null) {
            buffer.append(lastToken.getImage());
        }
        return buffer.toString();
    }

    static String getComments(Node node, HashSet<Token> marked) {
        String comment = "";
        Token token = MibAnalyzerUtil.findCommentTokenBefore(node, marked);
        String str = MibAnalyzerUtil.processComments(token, marked);
        if (str != null) {
            comment = str;
        }
        if ((str = MibAnalyzerUtil.processCommentsInside(node, marked)) != null) {
            if (comment.length() > 0) {
                comment = comment + "\n\n";
            }
            comment = comment + str;
        }
        if ((str = MibAnalyzerUtil.processComments(token = MibAnalyzerUtil.findCommentTokenAfter(node, true), marked)) != null) {
            if (comment.length() > 0) {
                comment = comment + "\n\n";
            }
            comment = comment + str;
        }
        return comment.length() <= 0 ? null : comment;
    }

    static String getCommentsFooter(Node node, HashSet<Token> marked) {
        return MibAnalyzerUtil.processComments(MibAnalyzerUtil.findCommentTokenAfter(node, false), marked);
    }

    private static String processComments(Token token, HashSet<Token> marked) {
        String res;
        StringBuilder buffer = new StringBuilder();
        while (token != null && !marked.contains(token)) {
            if (token.getId() == 1107) {
                marked.add(token);
                buffer.append(token.getImage().substring(2).trim());
            } else {
                if (token.getId() != 1106) break;
                buffer.append(MibAnalyzerUtil.getLineBreaks(token.getImage()));
            }
            token = token.getNextToken();
        }
        return (res = buffer.toString().trim()).length() <= 0 ? null : res;
    }

    private static String processCommentsInside(Node node, HashSet<Token> marked) {
        StringBuilder buffer = new StringBuilder();
        Token last = MibAnalyzerUtil.findLastToken(node);
        for (Token token = MibAnalyzerUtil.findFirstToken(node); token != null && token != last; token = token.getNextToken()) {
            if (token.getId() != 1107 || marked.contains(token)) continue;
            marked.add(token);
            buffer.append(token.getImage().substring(2).trim());
            buffer.append("\n");
        }
        String res = buffer.toString().trim();
        return res.length() <= 0 ? null : res;
    }

    private static Token findFirstToken(Node node) {
        while (node instanceof Production) {
            node = node.getChildAt(0);
        }
        return (Token)node;
    }

    private static Token findLastToken(Node node) {
        while (node instanceof Production) {
            node = node.getChildAt(node.getChildCount() - 1);
        }
        return (Token)node;
    }

    private static Token findCommentTokenBefore(Node node, HashSet<Token> skip) {
        Token comment = null;
        Token token = MibAnalyzerUtil.findFirstToken(node);
        if (token == null) {
            return null;
        }
        for (token = token.getPreviousToken(); !(token == null || skip != null && skip.contains(token)); token = token.getPreviousToken()) {
            if (token.getId() == 1107) {
                comment = token;
                continue;
            }
            if (token.getId() != 1106) break;
        }
        return comment;
    }

    private static Token findCommentTokenAfter(Node node, boolean sameline) {
        Token token = MibAnalyzerUtil.findLastToken(node);
        if (token == null) {
            return null;
        }
        int lineNo = token.getEndLine();
        for (token = token.getNextToken(); token != null; token = token.getNextToken()) {
            if (sameline && lineNo != token.getStartLine()) {
                return null;
            }
            if (token.getId() == 1107) {
                return token;
            }
            if (token.getId() == 1106 || token.getId() == 1004) continue;
            return null;
        }
        return null;
    }

    private static String getLineBreaks(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\n') continue;
            res.append('\n');
        }
        return res.toString();
    }
}

