/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public abstract class MibType {
    private String name;
    private boolean primitive;
    private MibTypeTag tag = null;
    private MibTypeSymbol reference = null;
    private String comment = null;

    protected MibType(String name, boolean primitive) {
        this.name = name;
        this.primitive = primitive;
    }

    public abstract MibType initialize(MibSymbol var1, MibLoaderLog var2) throws MibException;

    public MibType createReference() throws UnsupportedOperationException {
        String msg = this.name + " type cannot be referenced";
        throw new UnsupportedOperationException(msg);
    }

    public MibType createReference(Constraint constraint) throws UnsupportedOperationException {
        String msg = this.name + " type cannot be referenced with constraints";
        throw new UnsupportedOperationException(msg);
    }

    public MibType createReference(ArrayList<?> values) throws UnsupportedOperationException {
        String msg = this.name + " type cannot be referenced with " + "defined values";
        throw new UnsupportedOperationException(msg);
    }

    public abstract boolean isCompatible(MibValue var1);

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean hasTag(MibTypeTag tag) {
        return this.hasTag(tag.getCategory(), tag.getValue());
    }

    public boolean hasTag(int category, int value) {
        for (MibTypeTag iter = this.getTag(); iter != null; iter = iter.getNext()) {
            if (!iter.equals(category, value)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReferenceTo(String name) {
        if (this.reference == null) {
            return false;
        }
        if (this.reference.getName().equals(name)) {
            return true;
        }
        return this.reference.getType().hasReferenceTo(name);
    }

    public boolean hasReferenceTo(String module, String name) {
        if (this.reference == null) {
            return false;
        }
        Mib mib = this.reference.getMib();
        if (mib.getName().equals(module) && this.reference.getName().equals(name)) {
            return true;
        }
        return this.reference.getType().hasReferenceTo(module, name);
    }

    public String getName() {
        return this.name;
    }

    public MibTypeTag getTag() {
        return this.tag;
    }

    public void setTag(boolean implicit, MibTypeTag tag) {
        MibTypeTag next = this.tag;
        if (implicit && next != null) {
            next = next.getNext();
        }
        if (tag != null) {
            tag.setNext(next);
        }
        this.tag = tag;
    }

    public MibTypeSymbol getReferenceSymbol() {
        return this.reference;
    }

    public void setReferenceSymbol(MibTypeSymbol symbol) {
        this.reference = symbol;
    }

    public String getComment() {
        return this.comment;
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        if (this.tag != null) {
            return this.tag.toString() + " " + this.name;
        }
        return this.name;
    }
}

