/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.ElementType;

public class SequenceType
extends MibType {
    private ArrayList<ElementType> elements;

    public SequenceType(ArrayList<ElementType> elements) {
        this(true, elements);
    }

    private SequenceType(boolean primitive, ArrayList<ElementType> elements) {
        super("SEQUENCE", primitive);
        this.elements = elements;
        this.setTag(true, MibTypeTag.SEQUENCE);
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        for (ElementType elem : this.elements) {
            elem.initialize(symbol, log);
        }
        return this;
    }

    @Override
    public MibType createReference() {
        SequenceType type = new SequenceType(false, this.elements);
        type.setTag(true, this.getTag());
        return type;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return false;
    }

    public ElementType[] getAllElements() {
        ElementType[] res = new ElementType[this.elements.size()];
        return this.elements.toArray(res);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.elements.toString();
    }
}

