/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;

public class CSharpComment
extends CodeElement {
    public static final int DOCUMENTATION = 0;
    public static final int DOCUMENTATION_SINGLE = 1;
    public static final int BLOCK = 2;
    public static final int SINGLELINE = 3;
    private int type;
    private String comment;

    public CSharpComment(String comment) {
        this(0, comment);
    }

    public CSharpComment(int type, String comment) {
        this.type = 0 <= type && type <= 3 ? type : 0;
        this.comment = comment;
    }

    public int category() {
        return 0;
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        int pos;
        String indentStr = style.getIndent(indent);
        if (this.type == 0) {
            out.println(indentStr + "/**");
        } else if (this.type == 2) {
            out.println(indentStr + "/*");
        }
        String restLines = this.comment;
        while ((pos = restLines.indexOf(10)) >= 0) {
            String firstLine = restLines.substring(0, pos);
            restLines = restLines.substring(pos + 1);
            this.printLine(out, indentStr, firstLine);
        }
        this.printLine(out, indentStr, restLines);
        if (this.type == 0 || this.type == 2) {
            out.println(indentStr + " */");
        }
    }

    private void printLine(PrintWriter out, String indent, String line) {
        if (this.type == 0 || this.type == 2) {
            out.print(indent + " *");
        } else if (this.type == 1) {
            out.print(indent + "///");
        } else {
            out.print(indent + "//");
        }
        if (line.equals("")) {
            out.println();
        } else {
            out.println(" " + line);
        }
    }
}

