/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.HashMap;
import java.util.Map;
import sun.org.mozilla.javascript.internal.JavaMembers;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;

public class ClassCache {
    private static final Object AKEY = "ClassCache";
    private volatile boolean cachingIsEnabled = true;
    private transient HashMap<Class<?>, JavaMembers> classTable;
    private int generatedClassSerial;
    private Scriptable associatedScope;

    public static ClassCache get(Scriptable scriptable) {
        ClassCache classCache = (ClassCache)ScriptableObject.getTopScopeValue(scriptable, AKEY);
        if (classCache == null) {
            throw new RuntimeException("Can't find top level scope for ClassCache.get");
        }
        return classCache;
    }

    public boolean associate(ScriptableObject scriptableObject) {
        if (scriptableObject.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        if (this == scriptableObject.associateValue(AKEY, this)) {
            this.associatedScope = scriptableObject;
            return true;
        }
        return false;
    }

    public synchronized void clearCaches() {
        this.classTable = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean bl) {
        if (bl == this.cachingIsEnabled) {
            return;
        }
        if (!bl) {
            this.clearCaches();
        }
        this.cachingIsEnabled = bl;
    }

    Map<Class<?>, JavaMembers> getClassCacheMap() {
        if (this.classTable == null) {
            this.classTable = new HashMap();
        }
        return this.classTable;
    }

    public boolean isInvokerOptimizationEnabled() {
        return false;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean bl) {
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Scriptable getAssociatedScope() {
        return this.associatedScope;
    }
}

