/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    public static Hashtable parseQueryString(String query) {
        Hashtable<String, String[]> table = new Hashtable<String, String[]>();
        int length = query.length();
        char[] buf = new char[length];
        for (int i = 0; i < length; ++i) {
            char ch = query.charAt(i);
            while (i < length && (Character.isWhitespace(ch = query.charAt(i)) || ch == '&')) {
                ++i;
            }
            int offset = 0;
            while (i < length && (ch = query.charAt(i)) != '=') {
                if (ch == '+') {
                    buf[offset++] = 32;
                } else if (ch == '%' && i + 2 < length) {
                    char ch1 = query.charAt(++i);
                    char ch2 = query.charAt(++i);
                    buf[offset++] = (char)((HttpUtils.toHex(ch1) << 4) + HttpUtils.toHex(ch2));
                } else {
                    buf[offset++] = ch;
                }
                ++i;
            }
            if (offset == 0) break;
            String key = new String(buf, 0, offset);
            offset = 0;
            ++i;
            while (i < length && (ch = query.charAt(i)) != '&') {
                if (ch == '+') {
                    buf[offset++] = 32;
                } else if (ch != ' ') {
                    if (ch == '%' && i + 2 < length) {
                        char ch1 = query.charAt(++i);
                        char ch2 = query.charAt(++i);
                        buf[offset++] = (char)((HttpUtils.toHex(ch1) << 4) + HttpUtils.toHex(ch2));
                    } else {
                        buf[offset++] = ch;
                    }
                }
                ++i;
            }
            String value = new String(buf, 0, offset);
            String[] oldValue = (String[])table.get(key);
            if (oldValue == null) {
                table.put(key, new String[]{value});
                continue;
            }
            String[] newValue = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[oldValue.length] = value;
            table.put(key, newValue);
        }
        return table;
    }

    public static Hashtable parsePostData(int length, ServletInputStream is) {
        try {
            if (length >= 0) {
                byte[] buf = new byte[length];
                int offset = 0;
                while (length > 0) {
                    int sublen = is.read(buf, offset, length);
                    if (sublen > 0) {
                        offset += sublen;
                        length -= sublen;
                        continue;
                    }
                    throw new IOException("unexpected end of file");
                }
                return HttpUtils.parseQueryString(new String(buf, 0, buf.length));
            }
            return new Hashtable();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("illegal post data");
        }
    }

    public static StringBuffer getRequestURL(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer();
        sb.append(req.getScheme());
        sb.append("://");
        sb.append(req.getServerName());
        if (req.getServerPort() > 0 && req.getServerPort() != 80 && req.getServerPort() != 443) {
            sb.append(":");
            sb.append(req.getServerPort());
        }
        sb.append(req.getRequestURI());
        return sb;
    }

    private static int toHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }
}

