/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;
import net.lukemurphey.nsia.RightDescriptor;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class AccessControl {
    private final Application appRes;
    private final Object mutexAclExistence = new Object();

    public AccessControl(Application applicationResources) {
        if (applicationResources == null) {
            throw new IllegalArgumentException("The application resource object cannot be null");
        }
        this.appRes = applicationResources;
    }

    public ObjectPermissionDescriptor getUserPermissions(int userId, long objectId, boolean resolveUserGroupPermissions) throws SQLException, NoDatabaseConnectionException {
        ObjectPermissionDescriptor userPermissions = this.getPermissionsByUser(userId, objectId);
        ObjectPermissionDescriptor groupPermissions = null;
        if (resolveUserGroupPermissions) {
            groupPermissions = this.getPermissionsByGroups(userId, objectId);
        }
        if (groupPermissions == null && userPermissions == null) {
            return null;
        }
        if (groupPermissions == null) {
            return userPermissions;
        }
        if (userPermissions == null) {
            return groupPermissions;
        }
        return userPermissions.resolvePermissions(groupPermissions);
    }

    private ObjectPermissionDescriptor getPermissionsByGroups(int userId, long objectId) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        AccessControlDescriptor.Action read = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action modify = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action create = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action delete = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action execute = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action control = AccessControlDescriptor.Action.UNSPECIFIED;
        Statement groupsStatement = null;
        ResultSet groupsResult = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            groupsStatement = connection.prepareStatement("Select * from GroupUsersMap where userId = ?");
            groupsStatement.setInt(1, userId);
            groupsResult = groupsStatement.executeQuery();
            int c = 0;
            while (groupsResult.next()) {
                GroupManagement groupManagement;
                int groupId = groupsResult.getInt("groupId");
                ++c;
                statement = connection.prepareStatement("Select * from Permissions where objectId = ? and groupId = ?");
                statement.setLong(1, objectId);
                statement.setInt(2, groupId);
                result = statement.executeQuery();
                if (!result.next() || !(groupManagement = new GroupManagement(this.appRes)).isGroupActive(groupId)) continue;
                AccessControlDescriptor.Action groupRead = AccessControl.convertActionFromInt(result.getInt("Read"));
                AccessControlDescriptor.Action groupModify = AccessControl.convertActionFromInt(result.getInt("Modify"));
                AccessControlDescriptor.Action groupCreate = AccessControl.convertActionFromInt(result.getInt("Create"));
                AccessControlDescriptor.Action groupDelete = AccessControl.convertActionFromInt(result.getInt("Delete"));
                AccessControlDescriptor.Action groupExecute = AccessControl.convertActionFromInt(result.getInt("Execute"));
                AccessControlDescriptor.Action groupControl = AccessControl.convertActionFromInt(result.getInt("Control"));
                read = this.resolvePermission(read, groupRead);
                modify = this.resolvePermission(modify, groupModify);
                create = this.resolvePermission(create, groupCreate);
                delete = this.resolvePermission(delete, groupDelete);
                execute = this.resolvePermission(execute, groupExecute);
                control = this.resolvePermission(control, groupControl);
            }
            if (c > 0) {
                ObjectPermissionDescriptor objectPermissionDescriptor = new ObjectPermissionDescriptor(read, modify, create, execute, delete, control, AccessControlDescriptor.Subject.USER, userId, objectId);
                return objectPermissionDescriptor;
            }
            return null;
        }
        finally {
            if (groupsStatement != null) {
                groupsStatement.close();
            }
            if (groupsResult != null) {
                groupsResult.close();
            }
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static AccessControlDescriptor.Action convertActionFromInt(int value) {
        AccessControlDescriptor.Action[] values = AccessControlDescriptor.Action.values();
        int c = 0;
        while (c < values.length) {
            if (values[c].ordinal() == value) {
                return values[c];
            }
            ++c;
        }
        return AccessControlDescriptor.Action.UNSPECIFIED;
    }

    public ObjectPermissionDescriptor getGroupPermissions(int groupId, long objectId) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        AccessControlDescriptor.Action read = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action modify = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action create = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action delete = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action execute = AccessControlDescriptor.Action.UNSPECIFIED;
        AccessControlDescriptor.Action control = AccessControlDescriptor.Action.UNSPECIFIED;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from Permissions where objectId = ? and groupId = ?");
            statement.setLong(1, objectId);
            statement.setLong(2, groupId);
            result = statement.executeQuery();
            if (result.next()) {
                read = AccessControl.convertActionFromInt(result.getInt("Read"));
                modify = AccessControl.convertActionFromInt(result.getInt("Modify"));
                create = AccessControl.convertActionFromInt(result.getInt("Create"));
                delete = AccessControl.convertActionFromInt(result.getInt("Delete"));
                execute = AccessControl.convertActionFromInt(result.getInt("Execute"));
                control = AccessControl.convertActionFromInt(result.getInt("Control"));
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return new ObjectPermissionDescriptor(read, modify, create, execute, delete, control, AccessControlDescriptor.Subject.GROUP, groupId, objectId);
    }

    private AccessControlDescriptor.Action resolvePermission(AccessControlDescriptor.Action existingPermission, AccessControlDescriptor.Action setterPermission) {
        if (existingPermission == AccessControlDescriptor.Action.DENY || setterPermission == AccessControlDescriptor.Action.DENY) {
            return AccessControlDescriptor.Action.DENY;
        }
        if (setterPermission == AccessControlDescriptor.Action.UNSPECIFIED) {
            return existingPermission;
        }
        if (setterPermission == AccessControlDescriptor.Action.PERMIT) {
            return AccessControlDescriptor.Action.PERMIT;
        }
        return AccessControlDescriptor.Action.UNSPECIFIED;
    }

    private ObjectPermissionDescriptor getPermissionsByUser(int userId, long objectId) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from Permissions where objectId = ? and userId = ?");
            statement.setLong(1, objectId);
            statement.setInt(2, userId);
            result = statement.executeQuery();
            if (result.next()) {
                AccessControlDescriptor.Action read = AccessControl.convertActionFromInt(result.getInt("Read"));
                AccessControlDescriptor.Action modify = AccessControl.convertActionFromInt(result.getInt("Modify"));
                AccessControlDescriptor.Action create = AccessControl.convertActionFromInt(result.getInt("Create"));
                AccessControlDescriptor.Action delete = AccessControl.convertActionFromInt(result.getInt("Delete"));
                AccessControlDescriptor.Action execute = AccessControl.convertActionFromInt(result.getInt("Execute"));
                AccessControlDescriptor.Action control = AccessControl.convertActionFromInt(result.getInt("Control"));
                ObjectPermissionDescriptor objectPermissionDescriptor = new ObjectPermissionDescriptor(read, modify, create, execute, delete, control, AccessControlDescriptor.Subject.USER, userId, objectId);
                return objectPermissionDescriptor;
            }
            return null;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long setPermissions(ObjectPermissionDescriptor accessControlDescriptor) throws NoDatabaseConnectionException, SQLException {
        Object object = this.mutexAclExistence;
        synchronized (object) {
            Connection connection = null;
            Statement objMapStatement = null;
            ResultSet objMapresult = null;
            Statement aclExistsStatement = null;
            ResultSet aclExistsResult = null;
            Statement statement = null;
            ResultSet result = null;
            try {
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                long objectId = accessControlDescriptor.getObjectId();
                if (objectId >= 0L) {
                    objMapStatement = connection.prepareStatement("Select * from ObjectMap where ObjectID = ?");
                    objMapStatement.setLong(1, objectId);
                    objMapresult = objMapStatement.executeQuery();
                    if (!objMapresult.next()) {
                        return -1L;
                    }
                }
                boolean aclExistsAlready = false;
                aclExistsStatement = accessControlDescriptor.isGroup() ? connection.prepareStatement("Select * from Permissions where ObjectID = ? and GroupID = ?") : connection.prepareStatement("Select * from Permissions where ObjectID = ? and UserID = ?");
                aclExistsStatement.setLong(1, objectId);
                aclExistsStatement.setLong(2, accessControlDescriptor.getSubjectId());
                aclExistsResult = aclExistsStatement.executeQuery();
                if (aclExistsResult.next()) {
                    aclExistsAlready = true;
                }
                if (aclExistsAlready) {
                    statement = accessControlDescriptor.isGroup() ? connection.prepareStatement("Update Permissions set Modify=?, \"Create\"=?, \"Delete\"=?, \"Read\"=?, \"Execute\"=?, Control=? where ObjectID = ? and GroupID = ?") : connection.prepareStatement("Update Permissions set Modify=?, \"Create\"=?, \"Delete\"=?, \"Read\"=?, \"Execute\"=?, Control=? where ObjectID = ? and UserID = ?");
                    statement.setInt(1, accessControlDescriptor.getModifyPermission().ordinal());
                    statement.setInt(2, accessControlDescriptor.getCreatePermission().ordinal());
                    statement.setInt(3, accessControlDescriptor.getDeletePermission().ordinal());
                    statement.setInt(4, accessControlDescriptor.getReadPermission().ordinal());
                    statement.setInt(5, accessControlDescriptor.getExecutePermission().ordinal());
                    statement.setInt(6, accessControlDescriptor.getControlPermission().ordinal());
                    statement.setLong(7, objectId);
                    statement.setInt(8, accessControlDescriptor.getSubjectId());
                    statement.execute();
                    long l = objectId;
                    return l;
                }
                if (objectId < 0L) {
                    statement = connection.prepareStatement("Insert into ObjectMap", 1);
                    statement.execute();
                    result = statement.getGeneratedKeys();
                    statement.close();
                    statement = null;
                    if (!result.next()) {
                        return -1L;
                    }
                    objectId = result.getLong(1);
                }
                statement = accessControlDescriptor.isGroup() ? connection.prepareStatement("Insert into Permissions (ObjectID, ParentObjectID, UserID, GroupID, Modify, \"Create\", \"Delete\", \"Read\", \"Execute\", Control) values (?, ?, -1, ?, ?, ?, ?, ?, ?, ?)") : connection.prepareStatement("Insert into Permissions (ObjectID, ParentObjectID, UserID, GroupID, Modify, \"Create\", \"Delete\", \"Read\", \"Execute\", Control) values (?, ?, ?, -1, ?, ?, ?, ?, ?, ?)");
                statement.setLong(1, objectId);
                statement.setLong(2, -1L);
                statement.setInt(3, accessControlDescriptor.getSubjectId());
                statement.setInt(4, accessControlDescriptor.getModifyPermission().ordinal());
                statement.setInt(5, accessControlDescriptor.getCreatePermission().ordinal());
                statement.setInt(6, accessControlDescriptor.getDeletePermission().ordinal());
                statement.setInt(7, accessControlDescriptor.getReadPermission().ordinal());
                statement.setInt(8, accessControlDescriptor.getExecutePermission().ordinal());
                statement.setInt(9, accessControlDescriptor.getControlPermission().ordinal());
                statement.execute();
                long l = objectId;
                return l;
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (objMapStatement != null) {
                    objMapStatement.close();
                }
                if (objMapresult != null) {
                    objMapresult.close();
                }
                if (objMapresult != null) {
                    objMapresult.close();
                }
                if (aclExistsStatement != null) {
                    aclExistsStatement.close();
                }
                if (aclExistsResult != null) {
                    aclExistsResult.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUserPermissions(long userId, long objectId) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Object object = this.mutexAclExistence;
        synchronized (object) {
            Statement statement = null;
            try {
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                statement = connection.prepareStatement("Delete from Permissions where UserID = ? and ObjectID = ?");
                statement.setLong(1, userId);
                statement.setLong(2, objectId);
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteGroupPermissions(long groupId, long objectId) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        Object object = this.mutexAclExistence;
        synchronized (object) {
            try {
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                statement = connection.prepareStatement("Delete from Permissions where GroupID = ? and ObjectID = ?");
                statement.setLong(1, groupId);
                statement.setLong(2, objectId);
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteGroupRight(long groupId, String rightName) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet result = null;
        Object object = this.mutexAclExistence;
        synchronized (object) {
            try {
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                statement = connection.prepareStatement("Select * from Rights where RightName = ?");
                statement.setString(1, rightName);
                result = statement.executeQuery();
                if (!result.next()) {
                    return false;
                }
                long objectId = result.getLong("ObjectID");
                statement2 = connection.prepareStatement("Delete from Permissions where GroupID = ? and ObjectID = ?");
                statement2.setLong(1, groupId);
                statement2.setLong(2, objectId);
                statement2.executeUpdate();
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (result != null) {
                    result.close();
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteUserRight(long userId, String rightName) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet result = null;
        Object object = this.mutexAclExistence;
        synchronized (object) {
            try {
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                statement = connection.prepareStatement("Select * from Rights where RightName = ?");
                statement.setString(1, rightName);
                result = statement.executeQuery();
                if (!result.next()) {
                    return false;
                }
                long objectId = result.getLong("ObjectID");
                statement2 = connection.prepareStatement("Delete from Permissions where UserID = ? and ObjectID = ?");
                statement2.setLong(1, userId);
                statement2.setLong(2, objectId);
                statement2.executeUpdate();
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (result != null) {
                    result.close();
                }
            }
            return true;
        }
    }

    protected String[] getPossibleRights() throws SQLException, NoDatabaseConnectionException {
        Vector<String> possibleRights = new Vector<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            statement = connection.prepareStatement("Select RightName from Rights");
            result = statement.executeQuery();
            while (result.next()) {
                String value = result.getString("RightName");
                if (value == null) continue;
                possibleRights.add(value);
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        String[] possibleRightsArray = new String[possibleRights.size()];
        possibleRights.toArray(possibleRightsArray);
        return possibleRightsArray;
    }

    public RightDescriptor[] getUserRights(int userId, boolean resolveUserGroupPermissions) throws SQLException, NoDatabaseConnectionException {
        String[] supportedRights = this.getPossibleRights();
        Vector<RightDescriptor> rights = new Vector<RightDescriptor>();
        String[] stringArray = supportedRights;
        int n = supportedRights.length;
        int n2 = 0;
        while (n2 < n) {
            String right = stringArray[n2];
            try {
                rights.add(this.getRight(userId, right, false, resolveUserGroupPermissions));
            }
            catch (NotFoundException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            }
            ++n2;
        }
        RightDescriptor[] rightsArray = new RightDescriptor[rights.size()];
        rights.toArray(rightsArray);
        return rightsArray;
    }

    public RightDescriptor getUserRight(int userId, String right, boolean resolveUserGroupPermissions) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        return this.getRight(userId, right, false, resolveUserGroupPermissions);
    }

    public RightDescriptor getGroupRight(int groupId, String right) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        return this.getRight(groupId, right, true, true);
    }

    public boolean createNewRight(String rightName, String rightDescription) throws SQLException, NoDatabaseConnectionException {
        int results;
        if (rightName == null || rightName.trim().length() == 0) {
            throw new IllegalArgumentException("The right name must not be empty or null");
        }
        long objectId = AccessControl.allocateObjectId("UserRights", this.appRes);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            statement = connection.prepareStatement("insert into Rights(RightName, RightDescription, ObjectID) values (?,?,?)");
            statement.setString(1, rightName);
            statement.setString(2, rightDescription);
            statement.setLong(3, objectId);
            results = statement.executeUpdate();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return results > 0;
    }

    private RightDescriptor getRight(int id, String right, boolean isGroupPermission, boolean recurseGroupAcls) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            ObjectPermissionDescriptor userObjectPermissionDescriptor;
            ObjectPermissionDescriptor objectPermissionDescriptor;
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            statement = connection.prepareStatement("Select * from Rights where RightName = ?");
            statement.setString(1, right);
            result = statement.executeQuery();
            if (!result.next()) {
                throw new NotFoundException("No such right exists (\"" + right + "\")");
            }
            long objectId = result.getLong("ObjectID");
            objectPermissionDescriptor = isGroupPermission ? this.getGroupPermissions(id, objectId) : (recurseGroupAcls ? ((objectPermissionDescriptor = this.getPermissionsByGroups(id, objectId)) != null && objectPermissionDescriptor.getExecutePermission() != AccessControlDescriptor.Action.DENY ? ((userObjectPermissionDescriptor = this.getPermissionsByUser(id, objectId)) != null && objectPermissionDescriptor != null ? userObjectPermissionDescriptor.resolvePermissions(objectPermissionDescriptor) : userObjectPermissionDescriptor) : this.getPermissionsByUser(id, objectId)) : this.getPermissionsByUser(id, objectId));
            if (objectPermissionDescriptor == null) {
                objectPermissionDescriptor = isGroupPermission ? new ObjectPermissionDescriptor(AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Subject.GROUP, id, objectId) : new ObjectPermissionDescriptor(AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Subject.USER, id, objectId);
            }
            RightDescriptor rightDescriptor = new RightDescriptor(objectPermissionDescriptor.getExecutePermission(), objectPermissionDescriptor.getSubjectType(), id, right);
            return rightDescriptor;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean setPermissions(RightDescriptor rightDescriptor) throws SQLException, NoDatabaseConnectionException {
        return this.setRight(rightDescriptor);
    }

    public synchronized boolean setRight(RightDescriptor rightDescriptor) throws SQLException, NoDatabaseConnectionException {
        Connection connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            ObjectPermissionDescriptor objectPermissionDescriptor;
            statement = connection.prepareStatement("Select * from Rights where RightName = ?");
            statement.setString(1, rightDescriptor.getRightName());
            result = statement.executeQuery();
            if (!result.next()) {
                return false;
            }
            long objectId = result.getLong("ObjectID");
            if (objectId < 1L) {
                objectId = AccessControl.allocateObjectId("Rights", Application.getApplication());
                PreparedStatement statementAddObjectId = null;
                statementAddObjectId = connection.prepareStatement("Update Rights set ObjectID = ? where RightName = ?");
                statementAddObjectId.setLong(1, objectId);
                statementAddObjectId.setString(2, rightDescriptor.getRightName());
                statementAddObjectId.executeUpdate();
                statementAddObjectId.close();
            }
            boolean bl = this.setPermissions(objectPermissionDescriptor = new ObjectPermissionDescriptor(AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, rightDescriptor.getRight(), AccessControlDescriptor.Action.UNSPECIFIED, AccessControlDescriptor.Action.UNSPECIFIED, rightDescriptor.getSubjectType(), rightDescriptor.getSubjectId(), objectId)) >= 0L;
            return bl;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public ObjectPermissionDescriptor[] getAllAclEntries(long objectId) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        Vector<ObjectPermissionDescriptor> aces = new Vector<ObjectPermissionDescriptor>();
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from Permissions where objectId = ?");
            statement.setLong(1, objectId);
            result = statement.executeQuery();
            while (result.next()) {
                int id;
                AccessControlDescriptor.Subject subjectType;
                AccessControlDescriptor.Action read = AccessControl.convertActionFromInt(result.getInt("Read"));
                AccessControlDescriptor.Action modify = AccessControl.convertActionFromInt(result.getInt("Modify"));
                AccessControlDescriptor.Action create = AccessControl.convertActionFromInt(result.getInt("Create"));
                AccessControlDescriptor.Action delete = AccessControl.convertActionFromInt(result.getInt("Delete"));
                AccessControlDescriptor.Action execute = AccessControl.convertActionFromInt(result.getInt("Execute"));
                AccessControlDescriptor.Action control = AccessControl.convertActionFromInt(result.getInt("Control"));
                int userId = result.getInt("UserID");
                int groupId = result.getInt("GroupID");
                if (userId >= 0) {
                    subjectType = AccessControlDescriptor.Subject.USER;
                    id = userId;
                } else {
                    subjectType = AccessControlDescriptor.Subject.GROUP;
                    id = groupId;
                }
                ObjectPermissionDescriptor objectPermissionDescriptor = new ObjectPermissionDescriptor(read, modify, create, execute, delete, control, subjectType, id, objectId);
                aces.add(objectPermissionDescriptor);
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        ObjectPermissionDescriptor[] acl = new ObjectPermissionDescriptor[aces.size()];
        int c = 0;
        while (c < aces.size()) {
            ObjectPermissionDescriptor entry;
            acl[c] = entry = (ObjectPermissionDescriptor)aces.get(c);
            ++c;
        }
        return acl;
    }

    public static synchronized long allocateObjectId(String databaseTableDescription, Application app) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = app.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            statement = connection.prepareStatement("Insert into ObjectMap(\"Table\") values(?)", 1);
            statement.setString(1, databaseTableDescription);
            statement.executeUpdate();
            result = statement.getGeneratedKeys();
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            return -1L;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }
}

