/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

public abstract class AccessControlDescriptor {
    protected Subject subjectType;
    protected int subjectId;

    public void init(Subject subjectType, int subjectId) {
        if (subjectType == null) {
            throw new IllegalArgumentException("The access control descriptor given is not valid (null)");
        }
        this.subjectType = subjectType;
        this.subjectId = subjectId;
    }

    public Subject getSubjectType() {
        return this.subjectType;
    }

    public int getSubjectId() {
        return this.subjectId;
    }

    public boolean isGroup() {
        return this.subjectType == Subject.GROUP;
    }

    public boolean isUser() {
        return this.subjectType == Subject.USER;
    }

    protected Action resolvePermission(Action existingPermission, Action setterPermission) {
        if (existingPermission == Action.DENY || setterPermission == Action.DENY) {
            return Action.DENY;
        }
        if (setterPermission == Action.UNSPECIFIED) {
            return existingPermission;
        }
        if (setterPermission == Action.PERMIT) {
            return Action.PERMIT;
        }
        return Action.UNSPECIFIED;
    }

    public static enum Action {
        UNSPECIFIED,
        DENY,
        PERMIT;

    }

    public static enum Subject {
        USER,
        GROUP;

    }
}

