/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.lukemurphey.nsia.ApplicationConfiguration;
import net.lukemurphey.nsia.ApplicationParameters;
import net.lukemurphey.nsia.ApplicationStateMonitor;
import net.lukemurphey.nsia.DatabaseInitializer;
import net.lukemurphey.nsia.DefinitionUpdateWorker;
import net.lukemurphey.nsia.DerbyDatabaseInitializer;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NetworkManager;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.ReindexerWorker;
import net.lukemurphey.nsia.ScannerController;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.console.ConsoleListener;
import net.lukemurphey.nsia.eventlog.EventLog;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.eventlog.MessageFormatter;
import net.lukemurphey.nsia.eventlog.MessageFormatterFactory;
import net.lukemurphey.nsia.eventlog.SyslogNGAppender;
import net.lukemurphey.nsia.upgrade.UpgradeFailureException;
import net.lukemurphey.nsia.upgrade.Upgrader;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.SQLNestedException;

public final class Application {
    private static Application appRes;
    private EventLog eventlog = null;
    private ApplicationConfiguration appConfig = null;
    public static final String APPLICATION_NAME = "NSIA";
    public static final String APPLICATION_VENDOR = "ThreatFactor";
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;
    public static final int VERSION_REVISION = 6;
    public static final String VERSION_STATUS;
    public static final String DEFAULT_DATABASE_PATH = "../var/database";
    private final Object metricsMonitorMutex = new Object();
    public static final int THREAD_WARNING_THRESHOLD = 50;
    public static final int THREAD_CRITICAL_THRESHOLD = 80;
    public static final long MEMORY_WARNING_THRESHOLD = 70L;
    public static final long MEMORY_CRITICAL_THRESHOLD = 90L;
    public static final long DBCONNECTION_WARNING_THRESHOLD = 30L;
    public static final long DBCONNECTION_CRITICAL_THRESHOLD = 40L;
    private ApplicationStateMonitor metricsMonitor;
    private static String buildNumber;
    private String embeddedDatabasePath = null;
    private Boolean shutdownInProgress = Boolean.FALSE;
    private Object shutdownMutex = new Object();
    private String databaseLocation;
    private String databaseDriver;
    private final ScannerController scannerController;
    private final NetworkManager manager;
    private SessionManagement sessionManagement;
    private long startTime = 0L;
    private BasicDataSource connectionBroker;
    private boolean usingInternalDatabase;
    private Vector<WorkerThreadDescriptor> workerThreadQueue = new Vector();
    private RunMode runMode;
    private Timer timer;
    private ReindexerWorker reindexer = null;

    static {
        VERSION_STATUS = null;
        buildNumber = null;
    }

    public Application() {
        this.scannerController = null;
        this.manager = null;
    }

    public Application(String embeddedDatabasePath, boolean startServices) throws JSAPException, NoDatabaseConnectionException {
        this(null, embeddedDatabasePath, startServices);
    }

    public Application(String embeddedDatabasePath) throws JSAPException, NoDatabaseConnectionException {
        this(null, embeddedDatabasePath, true);
    }

    public Application(String[] args) throws JSAPException, NoDatabaseConnectionException {
        this(args, null);
    }

    public Application(String[] args, String embeddedDatabasePath) throws JSAPException, NoDatabaseConnectionException {
        this(args, embeddedDatabasePath, true);
    }

    public Application(boolean startAsServer) throws JSAPException, NoDatabaseConnectionException {
        this(null, null, true);
    }

    private void setUserAgent() {
        System.getProperties().setProperty("httpclient.useragent", "ThreatFactor NSIA " + Application.getVersion());
    }

    public Application(String[] args, String embeddedDatabasePath, boolean startAsServer) throws JSAPException, NoDatabaseConnectionException {
        this.setUserAgent();
        Properties properties = null;
        JSAPResult commandLineData = null;
        if (args != null) {
            JSAP jsap = Application.getCommandLineProcessor();
            commandLineData = jsap.parse(args);
            if (!commandLineData.success()) {
                System.err.println();
                System.err.println("Usage: NSIA");
                System.err.println(jsap.getHelp());
                System.exit(1);
            }
            try {
                properties = this.loadConfigFile(commandLineData.getString("configFile"));
            }
            catch (IOException e) {
                System.err.println("Configuration file could not be loaded: " + e.getMessage());
                System.exit(-1);
            }
        }
        this.eventlog = new EventLog();
        this.connectToDatabase(properties, embeddedDatabasePath);
        appRes = this;
        this.appConfig = new ApplicationConfiguration(this);
        this.eventlog.setApplication(this);
        try {
            Upgrader upgrader = new Upgrader(this);
            upgrader.peformUpgrades();
        }
        catch (UpgradeFailureException e) {
            this.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            System.err.println("An error occurred while performing the upgrade");
        }
        if (commandLineData != null && commandLineData.getBoolean("upgrade", false)) {
            this.shutdown(true);
            System.exit(0);
        }
        try {
            this.eventlog.loadHooks();
        }
        catch (SQLException e) {
            this.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
        }
        this.scannerController = startAsServer ? new ScannerController(this) : null;
        try {
            String agentString = null;
            agentString = this.appConfig.getHttpClientId();
            System.getProperties().setProperty("httpclient.useragent", agentString);
        }
        catch (NoDatabaseConnectionException e1) {
            System.out.println(e1.getMessage());
        }
        catch (InputValidationException e1) {
            System.out.println(e1.getMessage());
        }
        catch (SQLException e1) {
            System.out.println(e1.getMessage());
        }
        this.manager = startAsServer ? new NetworkManager() : null;
        this.startTime = System.currentTimeMillis();
        if (startAsServer) {
            this.startMetricsMonitor();
        }
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        if (startAsServer) {
            this.startTasks();
        }
    }

    private void connectToDatabase(Properties properties, String embeddedDatabasePath) {
        block17: {
            try {
                if (properties != null && properties.getProperty("Database.Location") != null) {
                    if (!this.connectToDatabase(properties.getProperty("Database.Location"), properties.getProperty("Database.Password"), properties.getProperty("Database.Driver"))) {
                        System.err.println("Database connection failed, application terminating");
                        System.exit(-1);
                    }
                    break block17;
                }
                try {
                    if (embeddedDatabasePath != null) {
                        this.connectToInternalDatabase(false, embeddedDatabasePath);
                        break block17;
                    }
                    this.connectToInternalDatabase(false);
                }
                catch (SQLNestedException e) {
                    File databaseFile;
                    SQLException nextException = (SQLException)e.getCause();
                    if (nextException != null && nextException.getNextException() != null && nextException.getNextException().getMessage().startsWith("Another instance of Derby may have already booted the database")) {
                        System.err.println("Database connection failed: another instance of the application may already be using the database. Shutdown the other instance and try restarting the application");
                        System.exit(-1);
                    }
                    if (!(databaseFile = new File(embeddedDatabasePath)).exists() || e.getMessage().equalsIgnoreCase("Cannot create PoolableConnectionFactory (Database '" + embeddedDatabasePath + "' not found.)")) {
                        System.out.print("Creating and initializing the internal database...");
                        try {
                            this.connectToInternalDatabase(true);
                        }
                        catch (SQLException e1) {
                            System.err.println("Database initialization failed: " + e1.getMessage());
                            System.exit(-1);
                        }
                        catch (NoDatabaseConnectionException e1) {
                            System.err.println("Database initialization failed: " + e1.getMessage());
                            System.exit(-1);
                        }
                        System.out.println("Done");
                        break block17;
                    }
                    if (nextException != null) {
                        System.err.println("Database connection failed: " + nextException.getMessage());
                        System.exit(-1);
                    }
                }
                catch (SQLException e) {
                    System.err.println("Database connection failed: " + e.getMessage());
                    System.err.println("Application terminating");
                    System.exit(-1);
                }
                catch (NoDatabaseConnectionException e) {
                    System.err.println("Database connection failed: " + e.getMessage());
                    System.err.println("Application terminating");
                    System.exit(-1);
                }
            }
            catch (InstantiationException e) {
                System.err.println("Database driver could not be loaded");
                System.exit(-1);
            }
            catch (IllegalAccessException e) {
                System.err.println("Database driver could not be loaded");
                System.exit(-1);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Database driver could not be loaded");
                System.exit(-1);
            }
        }
    }

    public WorkerThreadDescriptor addWorkerToQueue(WorkerThread thread, String uniqueName) throws DuplicateEntryException {
        return this.addWorkerToQueue(thread, uniqueName, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerThreadDescriptor addWorkerToQueue(WorkerThread thread, String uniqueName, int userId) throws DuplicateEntryException {
        if (thread == null) {
            throw new IllegalArgumentException("A null thread cannot be added to the queue");
        }
        Vector<WorkerThreadDescriptor> vector = this.workerThreadQueue;
        synchronized (vector) {
            int c = 0;
            while (c < this.workerThreadQueue.size()) {
                if (this.workerThreadQueue.get((int)c).hash.equalsIgnoreCase(uniqueName)) {
                    if (this.workerThreadQueue.get((int)c).thread.getStatus() == WorkerThread.State.STOPPED) {
                        this.workerThreadQueue.remove(c);
                    } else {
                        throw new DuplicateEntryException("A running task already exists with the given name (" + uniqueName + ")");
                    }
                }
                ++c;
            }
            WorkerThreadDescriptor desc = new WorkerThreadDescriptor(thread, uniqueName, userId);
            this.workerThreadQueue.add(desc);
            return desc;
        }
    }

    public ApplicationStateMonitor getApplicationStateMonitor() {
        return this.metricsMonitor;
    }

    public WorkerThreadDescriptor[] getWorkerThreadQueue() {
        return this.getWorkerThreadQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerThreadDescriptor getWorkerThread(String uniqueName) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("The unique name of the thread cannot be null");
        }
        Vector<WorkerThreadDescriptor> vector = this.workerThreadQueue;
        synchronized (vector) {
            int c = 0;
            while (c < this.workerThreadQueue.size()) {
                if (this.workerThreadQueue.get((int)c).hash.equalsIgnoreCase(uniqueName)) {
                    return this.workerThreadQueue.get(c);
                }
                ++c;
            }
        }
        return null;
    }

    public boolean stopWorkerThread(String uniqueName) {
        WorkerThreadDescriptor worker = this.getWorkerThread(uniqueName);
        try {
            if (worker != null) {
                worker.thread.terminate();
                return true;
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public ApplicationStateMonitor.ApplicationStateDataPoint[] getMetricsData() {
        return this.metricsMonitor.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerThreadDescriptor[] getWorkerThreadQueue(boolean returnAliveThreadsOnly) {
        Vector<WorkerThreadDescriptor> workers = new Vector<WorkerThreadDescriptor>();
        Vector<WorkerThreadDescriptor> vector = this.workerThreadQueue;
        synchronized (vector) {
            int c = 0;
            while (c < this.workerThreadQueue.size()) {
                if (!returnAliveThreadsOnly || this.workerThreadQueue.get((int)c).thread.getStatus() == WorkerThread.State.STARTED) {
                    workers.add(this.workerThreadQueue.get(c));
                }
                ++c;
            }
        }
        WorkerThreadDescriptor[] workersArray = new WorkerThreadDescriptor[workers.size()];
        workers.toArray(workersArray);
        return workersArray;
    }

    private Properties loadConfigFile(String configFileName) throws IOException {
        Properties p = new Properties();
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(configFileName);
                p.load(inputStream);
            }
            catch (FileNotFoundException e) {
                if (inputStream != null) {
                    inputStream.close();
                }
                return null;
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return p;
    }

    public BasicDataSource getDataSource() {
        return this.connectionBroker;
    }

    public String getParameter(String name, String defaultValue) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appConfig.getApplicationParameters().getParameter(name, defaultValue);
    }

    public long getApplicationStartTime() {
        return this.startTime;
    }

    public long getParameter(String name, long defaultValue) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appConfig.getApplicationParameters().getParameter(name, defaultValue);
    }

    public ScannerController getScannerController() {
        return this.scannerController;
    }

    public NetworkManager getNetworkManager() {
        return this.manager;
    }

    public static Application getApplication() {
        return appRes;
    }

    private static JSAP getCommandLineProcessor() throws JSAPException {
        JSAP jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption("configFile").setStringParser(JSAP.STRING_PARSER).setDefault("../etc/config.ini").setRequired(false).setShortFlag('c').setLongFlag("config");
        opt1.setHelp("The location of the configuration file");
        jsap.registerParameter(opt1);
        Switch sw1 = new Switch("verbose").setShortFlag('v').setLongFlag("verbose");
        sw1.setHelp("Output log event messages to standard err");
        jsap.registerParameter(sw1);
        Switch sw2 = new Switch("gui").setShortFlag('g').setLongFlag("gui");
        sw2.setHelp("Starts the application with the GUI interface");
        jsap.registerParameter(sw2);
        Switch sw3 = new Switch("service").setShortFlag('s').setLongFlag("service");
        sw3.setHelp("Starts the application in service mode");
        jsap.registerParameter(sw3);
        Switch sw4 = new Switch("upgrade").setShortFlag('u').setLongFlag("upgrade");
        sw4.setHelp("Perform database schema upgrades and exit");
        jsap.registerParameter(sw4);
        return jsap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMetricsMonitor() {
        Object object = this.metricsMonitorMutex;
        synchronized (object) {
            this.metricsMonitor = new ApplicationStateMonitor(10, 720, this);
            this.metricsMonitor.start();
        }
    }

    private void startTasks() {
        this.timer = new Timer("Scheduled Task Timer", true);
        DefinitionUpdateWorker worker = new DefinitionUpdateWorker();
        this.timer.scheduleAtFixedRate((TimerTask)new TimerTaskWorker(worker, "Definition Updater"), 1800000L, 3600000L);
        boolean autoDefrag = false;
        try {
            autoDefrag = this.appConfig.isAutomaticDefragmentationEnabled();
        }
        catch (InputValidationException e) {
            this.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), (Throwable)e);
        }
        catch (NoDatabaseConnectionException e) {
            this.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.DATABASE_FAILURE), (Throwable)e);
        }
        catch (SQLException e) {
            this.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION), (Throwable)e);
        }
        if (this.usingInternalDatabase && autoDefrag) {
            this.reindexer = new ReindexerWorker();
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            int minute = cal.get(12);
            int secsTilNextRun = (23 - hour) * 3600 + (60 - minute) * 60;
            this.timer.scheduleAtFixedRate((TimerTask)new TimerTaskWorker(this.reindexer, "Index Defragmenter"), 1000 * secsTilNextRun, 86400000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMetricsMonitor() {
        Object object = this.metricsMonitorMutex;
        synchronized (object) {
            if (this.metricsMonitor != null) {
                this.metricsMonitor.shutdown();
            }
            while (this.metricsMonitor != null && this.metricsMonitor.isAlive()) {
                try {
                    this.metricsMonitorMutex.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static Application startApplication(String[] args, RunMode runMode) throws JSAPException, NoDatabaseConnectionException, SQLException, InputValidationException, BindException, Exception {
        return Application.startApplication(args, runMode, DEFAULT_DATABASE_PATH);
    }

    public static Application startApplication(String[] args, RunMode runMode, boolean startServices) throws JSAPException, NoDatabaseConnectionException, SQLException, InputValidationException, BindException, Exception {
        return Application.startApplication(args, runMode, DEFAULT_DATABASE_PATH, startServices);
    }

    public static Application startApplication(String[] args, RunMode runMode, String embeddedDatabasePath) throws BindException, JSAPException, NoDatabaseConnectionException, SQLException, InputValidationException, Exception {
        return Application.startApplication(args, runMode, embeddedDatabasePath, true);
    }

    public static Application startApplication(String[] args, RunMode runMode, String embeddedDatabasePath, boolean startServices) throws JSAPException, NoDatabaseConnectionException, SQLException, InputValidationException, BindException, Exception {
        appRes = new Application(args, embeddedDatabasePath, startServices);
        if (startServices) {
            appRes.startListener();
            Application.appRes.scannerController.start();
        }
        try {
            String address = appRes.getApplicationConfiguration().getLogServerAddress();
            int port = appRes.getApplicationConfiguration().getLogServerPort();
            boolean enabled = appRes.getApplicationConfiguration().getLogServerEnabled();
            SyslogNGAppender.Protocol protocol = appRes.getApplicationConfiguration().getLogServerProtocol().equalsIgnoreCase("TCP") ? SyslogNGAppender.Protocol.TCP : SyslogNGAppender.Protocol.UDP;
            MessageFormatter formatter = MessageFormatterFactory.getFormatter(appRes.getApplicationConfiguration().getLogFormat());
            Application.appRes.eventlog.setMessageFormatter(formatter);
            if (address != null && port >= 0 && port <= 65535) {
                Application.appRes.eventlog.setLogServer(address, port, protocol, enabled);
            }
        }
        catch (SQLException e) {
            if (Application.appRes.eventlog != null) {
                Application.appRes.eventlog.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.STARTUP_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Error noted when configuring external logging")), e);
            } else {
                e.printStackTrace();
            }
        }
        catch (InputValidationException e) {
            if (Application.appRes.eventlog != null) {
                Application.appRes.eventlog.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.STARTUP_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Error noted when configuring external logging")), e);
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (Application.appRes.eventlog != null) {
                Application.appRes.eventlog.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.STARTUP_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Error noted when configuring external logging")), e);
            }
            e.printStackTrace();
        }
        Application.appRes.eventlog.setLoggingLevel(EventLogSeverity.DEBUG);
        appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.APPLICATION_STARTED, new EventLogField(EventLogField.FieldName.VERSION, Application.getVersion())));
        if (startServices && runMode == RunMode.CLI) {
            ConsoleListener.startConsoleListener();
            Application.appRes.runMode = runMode;
        }
        return appRes;
    }

    public void startListener() throws BindException, Exception {
        boolean sslEnabled = false;
        try {
            sslEnabled = appRes.getApplicationConfiguration().isSslEnabled();
        }
        catch (NoDatabaseConnectionException e) {
            System.err.println("Database connection unavailable");
            System.exit(-1);
        }
        catch (SQLException e) {
            this.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION), (Throwable)e);
            System.err.println("SQL exception prevented retrieval of application parameter (Administration.EnableSSL)");
            System.exit(-1);
        }
        catch (InputValidationException e) {
            this.logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "message = input validation failure getting parameter 'Administration.EnableSSL', defaulting to disabled")));
        }
        int serverPort = 8443;
        try {
            serverPort = this.appConfig.getServerPort();
        }
        catch (InputValidationException e) {
            this.logEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "message = server port input validation failure, defaulting to port 8080")));
        }
        catch (NoDatabaseConnectionException e) {
            System.err.println("Database connection unavailable");
            System.exit(-1);
        }
        catch (SQLException e) {
            System.err.println("SQL exception prevented retrieval of application parameter (Administration.ServerPort)");
            e.printStackTrace();
            System.exit(-1);
        }
        this.manager.setServerPort(serverPort, sslEnabled);
        this.manager.startListener();
    }

    public void shutdown() {
        this.shutdown(ShutdownRequestSource.UNSPECIFIED, false);
    }

    public String getPlatformArch() {
        return System.getProperty("os.arch");
    }

    public String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public String getOperatingSystemVersion() {
        return System.getProperty("os.version");
    }

    public String getJvmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getJvmVersion() {
        return System.getProperty("java.vm.version");
    }

    public int getDatabaseConnectionCount() {
        return appRes.getDataSource().getNumActive();
    }

    public void shutdown(ShutdownRequestSource shutdownCommandSource) {
        this.shutdown(shutdownCommandSource, false);
    }

    public void shutdown(boolean hideOutput) {
        this.shutdown(ShutdownRequestSource.UNSPECIFIED, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ShutdownRequestSource shutdownCommandSource, boolean hideOutput) {
        Object object = this.shutdownMutex;
        synchronized (object) {
            if (this.shutdownInProgress.booleanValue()) {
                return;
            }
            this.shutdownInProgress = Boolean.TRUE;
            if (this.reindexer != null) {
                this.reindexer.terminate();
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (!hideOutput && shutdownCommandSource == ShutdownRequestSource.API) {
                System.out.print("System is shutting down (received shutdown command from API interface)...");
            } else if (!(hideOutput || shutdownCommandSource != ShutdownRequestSource.UNSPECIFIED && shutdownCommandSource != ShutdownRequestSource.CLI)) {
                System.out.print("System is shutting down...");
            }
            if (this.manager != null) {
                this.manager.stopListener();
            }
            if (this.scannerController != null) {
                this.scannerController.disableScanning();
                this.scannerController.shutdown();
                this.waitUntilThreadTerminates(this.scannerController, 10);
            }
            for (WorkerThreadDescriptor desc : this.workerThreadQueue) {
                WorkerThread thread = desc.getWorkerThread();
                if (thread == null || thread.getStatus() == WorkerThread.State.STOPPED || thread.getStatus() == WorkerThread.State.INITIALIZED) continue;
                thread.terminate();
                this.waitUntilThreadTerminates(thread, 10);
            }
            if (this.manager != null) {
                appRes.stopMetricsMonitor();
            }
            try {
                if (this.isUsingInternalDatabase()) {
                    Connection connection = DriverManager.getConnection("jdbc:derby:" + this.embeddedDatabasePath + ";shutdown=true");
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!hideOutput) {
                System.out.println("Done");
            }
            appRes = null;
        }
        if (ConsoleListener.getConsoleListener() != null) {
            System.exit(0);
        }
    }

    private boolean waitUntilThreadTerminates(Thread thread, int timeLimitSeconds) {
        int secondsAlive = 0;
        while (thread != null && thread.isAlive() && (timeLimitSeconds <= 0 || secondsAlive < timeLimitSeconds)) {
            try {
                Thread.sleep(1000L);
                ++secondsAlive;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return thread != null && thread.isAlive();
    }

    private boolean waitUntilThreadTerminates(WorkerThread thread, int timeLimitSeconds) {
        int secondsAlive = 0;
        while (thread != null && thread.getStatus() != WorkerThread.State.STOPPED && secondsAlive < timeLimitSeconds) {
            try {
                Thread.sleep(1000L);
                ++secondsAlive;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return thread != null && thread.getStatus() != WorkerThread.State.STOPPED;
    }

    public DatabaseInitializer.DatabaseInitializationState connectToInternalDatabase(boolean createIfNonExistant) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoDatabaseConnectionException {
        return this.connectToInternalDatabase(createIfNonExistant, DEFAULT_DATABASE_PATH);
    }

    public DatabaseInitializer.DatabaseInitializationState connectToInternalDatabase(boolean createIfNonExistant, String embeddedDatabasePath) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoDatabaseConnectionException {
        this.databaseDriver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.embeddedDatabasePath = embeddedDatabasePath;
        this.databaseLocation = createIfNonExistant ? "jdbc:derby:" + this.embeddedDatabasePath + ";create=true" : "jdbc:derby:" + this.embeddedDatabasePath;
        this.connectionBroker = new BasicDataSource();
        this.connectionBroker.setMaxActive(50);
        this.connectionBroker.setDriverClassName(this.databaseDriver);
        this.connectionBroker.setUrl(this.databaseLocation);
        DerbyDatabaseInitializer initializer = new DerbyDatabaseInitializer(this.connectionBroker.getConnection());
        DatabaseInitializer.DatabaseInitializationState initializationState = initializer.performSetup();
        this.usingInternalDatabase = true;
        return initializationState;
    }

    public boolean connectToDatabase(String databaseLocation, String databasePassword, String databaseDriver) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (databaseLocation == null || databaseLocation.length() == 0) {
            throw new IllegalArgumentException("The database location cannot be null or empty");
        }
        if (databasePassword == null) {
            databasePassword = "";
        }
        if (databaseDriver != null && databaseDriver.length() > 0) {
            this.connectionBroker = new BasicDataSource();
            this.connectionBroker.setMaxActive(50);
            this.connectionBroker.setDriverClassName(databaseDriver);
            this.connectionBroker.setPassword(databasePassword);
            this.connectionBroker.setUrl(databaseLocation);
        }
        this.databaseDriver = databaseDriver;
        this.databaseLocation = databaseLocation;
        this.usingInternalDatabase = false;
        return true;
    }

    public void logEvent(EventLogMessage message) {
        this.eventlog.logEvent(message);
    }

    public String getDatabaseInfo() {
        return this.databaseLocation;
    }

    public boolean isUsingInternalDatabase() {
        return this.usingInternalDatabase;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setEventLog(EventLog eventlog) {
        this.eventlog = eventlog;
    }

    public EventLog getEventLog() {
        return this.eventlog;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public int getThreadCount() {
        Thread[] tList = new Thread[Thread.activeCount()];
        int numThreads = Thread.enumerate(tList);
        int realCount = 0;
        int i = 0;
        while (i < numThreads) {
            if (tList[i] != null && tList[i].isAlive()) {
                ++realCount;
            }
            ++i;
        }
        return realCount;
    }

    public int getProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public long getMaxMemory() {
        long mem = Runtime.getRuntime().maxMemory();
        return mem;
    }

    public long getUsedMemory() {
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return mem;
    }

    public long getUptime() {
        long startTime = appRes.getApplicationStartTime();
        long currentTime = System.currentTimeMillis();
        return currentTime - startTime;
    }

    public long getStartTime() {
        return appRes.getApplicationStartTime();
    }

    public String[] getSqlWarnings() throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        try {
            connection = appRes.getDatabaseConnection(DatabaseAccessType.SESSION);
            SQLWarning warn = connection.getWarnings();
            Vector<String> warnings = new Vector<String>();
            while (warn != null) {
                warnings.add(warn.getMessage());
                warn = warn.getNextWarning();
            }
            String[] warningsArray = new String[warnings.size()];
            int c = 0;
            while (c < warnings.size()) {
                warningsArray[c] = (String)warnings.get(c);
                ++c;
            }
            String[] stringArray = warningsArray;
            return stringArray;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public String getDatabaseName() throws SQLException, NoDatabaseConnectionException {
        if (this.connectionBroker != null) {
            Connection connection = null;
            try {
                connection = this.connectionBroker.getConnection();
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                DatabaseMetaData metaData = connection.getMetaData();
                String string = metaData.getDatabaseProductName();
                return string;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        throw new NoDatabaseConnectionException();
    }

    public String getDatabaseVersion() throws SQLException, NoDatabaseConnectionException {
        if (this.connectionBroker != null) {
            Connection connection = null;
            try {
                connection = this.connectionBroker.getConnection();
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                DatabaseMetaData metaData = connection.getMetaData();
                String string = metaData.getDriverVersion();
                return string;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        throw new NoDatabaseConnectionException();
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException, NoDatabaseConnectionException {
        if (this.connectionBroker != null) {
            Connection connection = null;
            try {
                DatabaseMetaData metaData;
                connection = this.connectionBroker.getConnection();
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                DatabaseMetaData databaseMetaData = metaData = connection.getMetaData();
                return databaseMetaData;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        throw new NoDatabaseConnectionException();
    }

    public String getDatabaseDriverName() throws SQLException, NoDatabaseConnectionException {
        if (this.connectionBroker != null) {
            Connection connection = null;
            try {
                connection = this.connectionBroker.getConnection();
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                DatabaseMetaData metaData = connection.getMetaData();
                String string = metaData.getDriverName();
                return string;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        throw new NoDatabaseConnectionException();
    }

    public String getDatabaseDriverVersion() throws SQLException, NoDatabaseConnectionException {
        if (this.connectionBroker != null) {
            Connection connection = null;
            try {
                connection = this.connectionBroker.getConnection();
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                DatabaseMetaData metaData = connection.getMetaData();
                String string = metaData.getDatabaseProductVersion();
                return string;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        throw new NoDatabaseConnectionException();
    }

    public static String getVersion() {
        if (VERSION_STATUS != null) {
            return "1.0.6 (" + VERSION_STATUS + ")";
        }
        return "1.0.6";
    }

    public Connection getDatabaseConnection(DatabaseAccessType databaseContext) throws NoDatabaseConnectionException {
        Connection connection = null;
        try {
            connection = this.connectionBroker.getConnection();
        }
        catch (SQLException e) {
            this.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION, new Date()), (Throwable)e);
            throw new NoDatabaseConnectionException(e);
        }
        return connection;
    }

    public void logEvent(EventLogMessage.EventType eventType, EventLogField ... fields) {
        this.eventlog.logEvent(new EventLogMessage(eventType, fields));
    }

    public void logEvent(EventLogMessage.EventType eventType) {
        this.eventlog.logEvent(new EventLogMessage(eventType));
    }

    public void logExceptionEvent(EventLogMessage.EventType eventType, Throwable t) {
        this.eventlog.logExceptionEvent(new EventLogMessage(eventType), t);
    }

    public void logExceptionEvent(EventLogMessage message, Throwable t) {
        this.eventlog.logExceptionEvent(message, t);
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.appConfig;
    }

    public ApplicationParameters getApplicationParameters() {
        return this.appConfig.getApplicationParameters();
    }

    public SessionManagement getSessionManager() {
        if (this.sessionManagement == null) {
            this.sessionManagement = new SessionManagement(this);
        }
        return this.sessionManagement;
    }

    public ApplicationStatusDescriptor getManagerStatus() {
        Vector<StatusEntry> statusEntries = new Vector<StatusEntry>(5);
        long memoryUsage = 100L * this.getUsedMemory() / this.getMaxMemory();
        if (memoryUsage >= 90L) {
            statusEntries.add(new StatusEntry("Memory Utilization", 2, "Memory Critical", "Memory use at critical limits"));
        } else if (memoryUsage >= 70L) {
            statusEntries.add(new StatusEntry("Memory Utilization", 1, "Memory Low", "Memory use high"));
        } else {
            statusEntries.add(new StatusEntry("Memory Utilization", 0));
        }
        ScannerController scanner = appRes.getScannerController();
        if (scanner == null) {
            statusEntries.add(new StatusEntry("Scanner Status", 2, "Scanner Failed", "Scanner has become non-operational"));
        } else {
            ScannerController.ScannerState scannerState = scanner.getScanningState();
            if (scannerState == ScannerController.ScannerState.PAUSING) {
                statusEntries.add(new StatusEntry("Scanner Status", 1, "Scanner Pausing", "Scanner is pausing"));
            } else if (scannerState == ScannerController.ScannerState.STARTING) {
                statusEntries.add(new StatusEntry("Scanner Status", 1, "Scanner Starting", "Scanner is preparing to begin scans..."));
            } else if (scannerState == ScannerController.ScannerState.PAUSED) {
                statusEntries.add(new StatusEntry("Scanner Status", 1, "Scanner Paused", "Scanner is not currently operational (paused)"));
            } else {
                statusEntries.add(new StatusEntry("Scanner Status", 0));
            }
        }
        int threads = this.getThreadCount();
        if (threads >= 80) {
            statusEntries.add(new StatusEntry("Thread Count", 2, "Thread Count High", "Thread count high"));
        } else if (threads >= 50) {
            statusEntries.add(new StatusEntry("Thread Count", 1, "Thread Count Critical", "Thread count critical"));
        } else {
            statusEntries.add(new StatusEntry("Thread Count", 0));
        }
        int dbConnectionCount = this.getDatabaseConnectionCount();
        if ((long)dbConnectionCount >= 40L) {
            statusEntries.add(new StatusEntry("Database Connections", 2, "Database Connections Critical", "Database connections critical"));
        } else if ((long)dbConnectionCount >= 30L) {
            statusEntries.add(new StatusEntry("Database Connections", 1, "Database Connections High", "Database connections high"));
        } else {
            statusEntries.add(new StatusEntry("Database Connections", 0));
        }
        StatusEntry[] statusEntriesArray = new StatusEntry[statusEntries.size()];
        int c = 0;
        while (c < statusEntries.size()) {
            statusEntriesArray[c] = (StatusEntry)statusEntries.get(c);
            ++c;
        }
        return new ApplicationStatusDescriptor(statusEntriesArray);
    }

    public static String getBuildNumber() {
        if (buildNumber != null) {
            return buildNumber;
        }
        Properties buildProperties = Application.getBuildProperties();
        if (buildProperties != null) {
            buildNumber = buildProperties.getProperty("build.number", "");
        }
        return buildNumber;
    }

    public static Properties getBuildProperties() {
        Properties buildProperties = new Properties();
        InputStream in = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            in = Application.class.getResourceAsStream("build.properties");
            if (in == null) {
                return null;
            }
            try {
                buildProperties.load(in);
            }
            catch (IOException e1) {
                return null;
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (in != null) {
                    in.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e2) {
                return null;
            }
        }
        return buildProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShuttingDown() {
        Object object = this.shutdownMutex;
        synchronized (object) {
            return this.shutdownInProgress;
        }
    }

    public static class ApplicationStatusDescriptor {
        public static final int STATUS_GREEN = 0;
        public static final int STATUS_YELLOW = 1;
        public static final int STATUS_RED = 2;
        private String statusDescriptionShort;
        private String statusDescriptionLong;
        private int statusLevel;
        private StatusEntry[] statusEntries;

        public ApplicationStatusDescriptor(StatusEntry[] statusEntries) {
            this.statusEntries = new StatusEntry[statusEntries.length];
            System.arraycopy(statusEntries, 0, this.statusEntries, 0, statusEntries.length);
            this.init();
        }

        private void init() {
            int c = 0;
            while (c < this.statusEntries.length) {
                if (this.statusEntries[c].getStatus() > this.statusLevel) {
                    this.statusLevel = this.statusEntries[c].getStatus();
                }
                ++c;
            }
            StringBuffer statusDescriptionShortBuffer = new StringBuffer(64);
            StringBuffer statusDescriptionLongBuffer = new StringBuffer(128);
            int c2 = 0;
            while (c2 < this.statusEntries.length) {
                if (this.statusEntries[c2].getStatus() == this.statusLevel) {
                    if (this.statusEntries[c2].getShortMessage() != null) {
                        if (statusDescriptionShortBuffer.length() == 0) {
                            statusDescriptionShortBuffer.append(this.statusEntries[c2].getShortMessage());
                        } else {
                            statusDescriptionShortBuffer.append("; " + this.statusEntries[c2].getShortMessage());
                        }
                    }
                    if (this.statusEntries[c2].getLongMessage() != null) {
                        if (statusDescriptionLongBuffer.length() == 0) {
                            statusDescriptionLongBuffer.append(this.statusEntries[c2].getLongMessage());
                        } else {
                            statusDescriptionLongBuffer.append("; " + this.statusEntries[c2].getLongMessage());
                        }
                    }
                }
                ++c2;
            }
            this.statusDescriptionLong = statusDescriptionLongBuffer.length() > 0 ? statusDescriptionLongBuffer.toString() : "System fully operational";
            this.statusDescriptionShort = statusDescriptionShortBuffer.length() > 0 ? statusDescriptionShortBuffer.toString() : "Operational";
        }

        public StatusEntry[] getEntries() {
            StatusEntry[] statusEntriesCopy = new StatusEntry[this.statusEntries.length];
            System.arraycopy(this.statusEntries, 0, statusEntriesCopy, 0, this.statusEntries.length);
            return statusEntriesCopy;
        }

        public int getOverallStatus() {
            return this.statusLevel;
        }

        public String getLongDescription() {
            return this.statusDescriptionLong;
        }

        public String getShortDescription() {
            return this.statusDescriptionShort;
        }

        public StatusEntry getStatusEntry(String key) {
            int c = 0;
            while (c < this.statusEntries.length) {
                if (this.statusEntries[c].getKey().equals(key)) {
                    return this.statusEntries[c];
                }
                ++c;
            }
            return null;
        }
    }

    public static enum DatabaseAccessType {
        USER_QUERY,
        ADMIN,
        PERMISSIONS,
        FIREWALL,
        EVENT_LOG,
        SESSION,
        SCANNER,
        ACTION,
        USER_UPDATE;

    }

    public static enum RunMode {
        CLI,
        GUI,
        SERVICE;

    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            Application application = Application.getApplication();
            if (application != null && application.isShuttingDown()) {
                application.shutdown();
            }
        }
    }

    public static enum ShutdownRequestSource {
        UNSPECIFIED,
        API,
        CLI;

    }

    public static class StatusEntry {
        private int status = 0;
        private String key;
        private String longMessage = null;
        private String shortMessage = null;

        public StatusEntry(String key, int status, String shortMessage, String longMessage) {
            this.key = key;
            this.status = status;
            this.shortMessage = shortMessage;
            this.longMessage = longMessage;
        }

        public StatusEntry(String key, int status) {
            this.key = key;
            this.status = status;
        }

        public StatusEntry(String key, int status, String message) {
            this.key = key;
            this.status = status;
            this.shortMessage = message;
            this.longMessage = message;
        }

        public int getStatus() {
            return this.status;
        }

        public String getShortMessage() {
            return this.shortMessage;
        }

        public String getLongMessage() {
            return this.longMessage;
        }

        public String getKey() {
            return this.key;
        }
    }

    private class TimerTaskWorker
    extends TimerTask {
        private WorkerThread worker;
        private String uniqueName;

        public TimerTaskWorker(WorkerThread worker, String uniqueName) {
            this.worker = worker;
            this.uniqueName = uniqueName;
        }

        @Override
        public void run() {
            try {
                Application.this.addWorkerToQueue(this.worker, this.uniqueName);
                Thread thread = new Thread((Runnable)this.worker, this.uniqueName);
                thread.start();
            }
            catch (DuplicateEntryException duplicateEntryException) {
                // empty catch block
            }
        }
    }

    public static class WorkerThreadDescriptor {
        protected String hash;
        protected WorkerThread thread;
        protected int userId = -1;

        protected WorkerThreadDescriptor(WorkerThread thread, String hash) {
            this.thread = thread;
            this.hash = hash;
            this.userId = -1;
        }

        protected WorkerThreadDescriptor(WorkerThread thread, String hash, int userId) {
            this.thread = thread;
            this.hash = hash;
            this.userId = userId;
        }

        public String getUniqueName() {
            return this.hash;
        }

        public WorkerThread getWorkerThread() {
            return this.thread;
        }

        public int getUserID() {
            return this.userId;
        }
    }
}

