/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.UUID;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationParameters;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.LicenseManagement;
import net.lukemurphey.nsia.LicenseValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.MessageFormatter;
import net.lukemurphey.nsia.eventlog.MessageFormatterFactory;
import net.lukemurphey.nsia.eventlog.SyslogNGAppender;

public class ApplicationConfiguration {
    private ApplicationParameters appParams;
    private Application application;
    private LicenseDescriptor license = null;
    private long licenseLastChecked = -1L;
    private boolean licenseBeingChecked = false;
    protected static final long DEFAULT_PASSWORD_ITERATION_COUNT = 10000L;
    protected static final String DEFAULT_HASH_ALGORITHM = "sha-512";
    protected static final long DEFAULT_AUTHENTICATION_ATTEMPT_LIMIT = 4L;
    protected static final long DEFAULT_AUTHENTICATION_AGGREGATION_PERIOD_SECONDS = 3600L;
    protected static final long DEFAULT_SESSION_LIFETIME = 21600L;
    protected static final long DEFAULT_SESSION_INACTIVITY_THRESHOLD = 3600L;
    protected static final long DEFAULT_SESSION_ID_LIFETIME = 300L;
    protected static final long DEFAULT_SIMULTANEOUS_HTTP_CONNECTIONS = 10L;
    protected static final String DEFAULT_LOG_FORMAT = "Native";

    public ApplicationConfiguration(Application app) {
        this.application = app;
        this.appParams = new ApplicationParameters(app);
    }

    public ApplicationParameters getApplicationParameters() {
        return this.appParams;
    }

    public void setLoginBanner(String value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        this.appParams.setParameter("Security.LoginBanner", value);
    }

    public String getLoginBanner() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Security.LoginBanner", null);
    }

    public void setHashIterations(long value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (value <= 0L) {
            throw new InputValidationException("The hash iteration count is invalid (must be greater than or equal to one)", "Hash Iterations", String.valueOf(value));
        }
        this.appParams.setParameter("Security.PasswordHashIterations", String.valueOf(value));
    }

    public long getHashIterations() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        long hashIterationCount = this.appParams.getParameter("Security.PasswordHashIterations", 10000L);
        if (hashIterationCount < 1L) {
            this.application.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Hash iteration count parameter is invalid (" + hashIterationCount + ")"));
        }
        return this.appParams.getParameter("Security.PasswordHashIterations", 10000L);
    }

    public void setHashAlgorithm(String value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        try {
            MessageDigest.getInstance(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InputValidationException("The algorithm given is invalid", "Hash Algorithm", value);
        }
        this.appParams.setParameter("Security.PasswordHashAlgorithm", value);
    }

    public String getHashAlgorithm() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Security.PasswordHashAlgorithm", DEFAULT_HASH_ALGORITHM);
    }

    public String getHttpClientId() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.HTTPClientID", "ThreatFactor NSIA " + Application.getVersion());
    }

    public void setSslEnabled(boolean value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (value) {
            this.appParams.setParameter("Administration.EnableSSL", "1");
        } else {
            this.appParams.setParameter("Administration.EnableSSL", "0");
        }
    }

    public boolean isSslEnabled() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.EnableSSL", 0L) == 1L;
    }

    public void setServerPort(int value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (value < 0 || value > 65535) {
            throw new InputValidationException("The manager port is invalid (must be within 0-65535)", "Manager Port", String.valueOf(value));
        }
        this.appParams.setParameter("Administration.ServerPort", String.valueOf(value));
    }

    public int getServerPort() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        int serverPort = this.isSslEnabled() ? (int)this.appParams.getParameter("Administration.ServerPort", 8443L) : (int)this.appParams.getParameter("Administration.ServerPort", 8080L);
        return serverPort;
    }

    public void setMaxHTTPScanThreads(int value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (value < 0 || value > 25) {
            throw new InputValidationException("The maximum number of simultaneous HTTP scan threads is too high (cannot be greater than 25)", "HTTP Scan Threads", String.valueOf(value));
        }
        this.appParams.setParameter("Administration.HTTPScanThreads", String.valueOf(value));
    }

    public int getMaxHTTPScanThreads() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return (int)this.appParams.getParameter("Administration.HTTPScanThreads", 2L);
    }

    public String getKeystore() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.SSLKeystore", "../etc/keystore");
    }

    public String getSslPassword() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.SSLPassword", null);
    }

    public String getSslKeyPassword() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.SSLKeyPassword", null);
    }

    public void setSslPassword(String value) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        this.appParams.setParameter("Administration.SSLPassword", value);
    }

    public void setSslKeyPassword(String value) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        this.appParams.setParameter("Administration.SSLKeyPassword", value);
    }

    public String getLogFormat() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.LogFormat", DEFAULT_LOG_FORMAT);
    }

    public void setLogFormat(String value) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        MessageFormatter formatter = MessageFormatterFactory.getFormatter(value);
        this.application.getEventLog().setMessageFormatter(formatter);
        this.appParams.setParameter("Administration.LogFormat", value);
    }

    public void setAuthenticationAttemptAggregationCount(long value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (value < 2L) {
            throw new InputValidationException("Authentication attempt aggregation is invalid (must be 2 or more)", "Authentication Attempt Count", String.valueOf(value));
        }
        this.appParams.setParameter("Security.AuthenticationAttemptAggregationPeriod", String.valueOf(value));
    }

    public long getAuthenticationAttemptAggregationCount() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Security.AuthenticationAttemptAggregationPeriod", 3600L);
    }

    public void setAuthenticationAttemptLimit(long value) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (value < 0L) {
            throw new InputValidationException("Authentication attempt limit is invalid (must be 0 or more)", "Authentication Attempt Limit", String.valueOf(value));
        }
    }

    public long getAuthenticationAttemptLimit() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Security.MaximumAuthenticationAttemptLimit", 4L);
    }

    public void setSessionLifetime(long value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (value < -1L) {
            throw new InputValidationException("The maximum session lifetime is invalid (must not be less than -1)", "Session Lifetime", String.valueOf(value));
        }
        if (value > 1000000L) {
            throw new InputValidationException("The maximum session lifetime is too long (must not be greater than 1,000,000 seconds)", "Session Lifetime", String.valueOf(value));
        }
        if (value < 300L) {
            throw new InputValidationException("The maximum session lifetime is too short (must not be less than 300 seconds)", "Session Lifetime", String.valueOf(value));
        }
        this.appParams.setParameter("Security.SessionLifetime", String.valueOf(value));
    }

    public long getSessionLifetime() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        long maximumSessionSecs = this.appParams.getParameter("Security.SessionLifetime", 21600L);
        if (maximumSessionSecs < 1L) {
            return -1L;
        }
        if (maximumSessionSecs > 1000000L) {
            this.application.logEvent(EventLogMessage.EventType.ILLEGAL_CONFIG, new EventLogField(EventLogField.FieldName.MESSAGE, "Maximum session time too long (" + maximumSessionSecs + ")"));
            return 1000000L;
        }
        if (maximumSessionSecs < 300L) {
            this.application.logEvent(EventLogMessage.EventType.ILLEGAL_CONFIG, new EventLogField(EventLogField.FieldName.MESSAGE, "Maximum session time too short (" + maximumSessionSecs + ")"));
            return 21600L;
        }
        return maximumSessionSecs;
    }

    public long getSessionInactivityThreshold() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Security.SessionInactivityThreshold", 3600L);
    }

    public void setSessionInactivityThreshold(long value) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (value < -1L) {
            throw new InputValidationException("Session inactivity threshold is invalid (must not be less then 60 seconds)", "Session Inactivity Threshold", String.valueOf(value));
        }
        if (value != -1L && value < 60L) {
            throw new InputValidationException("Session inactivity threshold is invalid (must not be less then 60 seconds)", "Session Inactivity Threshold", String.valueOf(value));
        }
        this.appParams.setParameter("Security.SessionInactivityThreshold", String.valueOf(value));
    }

    public void setSessionIdentifierLifetime(long value) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (value < -1L) {
            throw new InputValidationException("The session identifier lifetime is invalid (must not be less than -1)", "Session Identifier Lifetime", String.valueOf(value));
        }
        this.appParams.setParameter("Security.SessionIdentifierLifetime", String.valueOf(value));
    }

    public long getSessionIdentifierLifetime() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Security.SessionIdentifierLifetime", 300L);
    }

    public String getLogServerProtocol() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.LogServerProtocol", "UDP");
    }

    public int getLogServerPort() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return (int)this.appParams.getParameter("Administration.LogServerPort", 514L);
    }

    public String getLogServerAddress() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.LogServerAddress", null);
    }

    public boolean getLogServerEnabled() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.LogServerEnabled", 0L) == 1L;
    }

    public void setLogServerPort(int port) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (port < 0 || port > 65535) {
            throw new InputValidationException("The port is invalid, must be between within the range of 0-65535", "Syslog Server Port", String.valueOf(port));
        }
        this.appParams.setParameter("Administration.LogServerPort", String.valueOf(port));
        this.setupSyslog();
    }

    protected void setupSyslog() {
        try {
            String protocol = this.getLogServerProtocol();
            if (protocol.equalsIgnoreCase("TCP")) {
                this.application.getEventLog().setLogServer(this.getLogServerAddress(), this.getLogServerPort(), SyslogNGAppender.Protocol.TCP, this.getLogServerEnabled());
            } else {
                this.application.getEventLog().setLogServer(this.getLogServerAddress(), this.getLogServerPort(), SyslogNGAppender.Protocol.UDP, this.getLogServerEnabled());
            }
            MessageFormatter formatter = MessageFormatterFactory.getFormatter(this.application.getApplicationConfiguration().getLogFormat());
            this.application.getEventLog().setMessageFormatter(formatter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLogServerAddress(String address) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (address == null) {
            throw new InputValidationException("The address is invalid, cannot be null", "Syslog Server Address", "");
        }
        if (address.isEmpty()) {
            throw new InputValidationException("The address is invalid, cannot be empty", "Syslog Server Address", address);
        }
        if (!Pattern.matches("[-a-zA-Z0-9.]+", address)) {
            throw new InputValidationException("The server address is not a valid DNS name or IP address", "Syslog Server Address", address);
        }
        this.appParams.setParameter("Administration.LogServerAddress", address);
        this.setupSyslog();
    }

    public void setLogServerProtocol(String protocol) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (protocol == null) {
            throw new InputValidationException("The protocol is invalid, cannot be null", "Syslog Server Protocol", "");
        }
        if (!protocol.equalsIgnoreCase("UDP") && !protocol.equalsIgnoreCase("TCP")) {
            throw new InputValidationException("The protocol is invalid, must be either TCP or UDP", "Syslog Server Protocol", protocol);
        }
        this.appParams.setParameter("Administration.LogServerProtocol", protocol);
        this.setupSyslog();
    }

    public void setLogServerEnabled(boolean enable) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (enable) {
            this.appParams.setParameter("Administration.LogServerEnabled", "1");
        } else {
            this.appParams.setParameter("Administration.LogServerEnabled", "0");
        }
        this.setupSyslog();
    }

    public String getLicenseKey() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.LicenseKey", null);
    }

    public synchronized boolean isLicenseValid() {
        return this.license.isValid();
    }

    public LicenseDescriptor getLicense() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.getLicense(false);
    }

    public boolean licenseKeyCheckCompleted() {
        return this.licenseLastChecked > 0L;
    }

    public synchronized LicenseDescriptor getLicense(boolean dontBlock) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        boolean lastCheckFresh;
        if (this.license != null && this.license.getStatus() == LicenseDescriptor.LicenseStatus.UNVALIDATED) {
            lastCheckFresh = this.licenseLastChecked + 900000L > System.currentTimeMillis();
        } else {
            boolean bl = lastCheckFresh = this.licenseLastChecked + 28800000L > System.currentTimeMillis();
        }
        if (this.licenseLastChecked > -1L && lastCheckFresh) {
            return this.license;
        }
        String key = this.appParams.getParameter("Administration.LicenseKey", null);
        if (key == null) {
            try {
                this.licenseLastChecked = System.currentTimeMillis();
                this.license = LicenseManagement.getKeyInfo(null);
            }
            catch (LicenseValidationException licenseValidationException) {
                // empty catch block
            }
            return this.license;
        }
        if (this.license != null && !lastCheckFresh && dontBlock) {
            LicenseChecker checker = new LicenseChecker();
            checker.start();
            return this.license;
        }
        if ((this.license == null || !lastCheckFresh) && dontBlock) {
            if (key != null && !this.licenseBeingChecked) {
                this.license = LicenseDescriptor.uncheckedLicense(key);
                LicenseChecker checker = new LicenseChecker();
                checker.start();
            }
            return this.license;
        }
        if (this.license == null || !lastCheckFresh) {
            return this.fetchLicense();
        }
        return this.license;
    }

    private LicenseDescriptor fetchLicense() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        String key = this.appParams.getParameter("Administration.LicenseKey", null);
        try {
            this.license = LicenseManagement.getKeyInfo(key);
        }
        catch (LicenseValidationException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.LICENSE_VALIDATION_FAILURE, (Throwable)e);
            this.license = LicenseDescriptor.uncheckedLicense(key);
        }
        this.licenseLastChecked = System.currentTimeMillis();
        return this.license;
    }

    public synchronized void setLicenseKey(String licenseKey) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        try {
            this.license = LicenseManagement.getKeyInfo(licenseKey);
            this.appParams.setParameter("Administration.LicenseKey", licenseKey);
        }
        catch (LicenseValidationException e) {
            this.appParams.setParameter("Administration.LicenseKey", licenseKey);
            this.license = null;
        }
    }

    public boolean getAutoDefinitionUpdating() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.AutoUpdateDefinitions", 0L) == 1L;
    }

    public void setAutoDefinitionUpdating(boolean autoUpdate) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (autoUpdate) {
            this.appParams.setParameter("Administration.AutoUpdateDefinitions", String.valueOf(1));
        } else {
            this.appParams.setParameter("Administration.AutoUpdateDefinitions", String.valueOf(0));
        }
    }

    public void setEmailFromAddress(EmailAddress fromAddress) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        this.appParams.setParameter("Administration.EmailFromAddress", fromAddress.toString());
    }

    public EmailAddress getEmailFromAddress() throws NoDatabaseConnectionException, SQLException, InputValidationException, UnknownHostException, InvalidLocalPartException {
        String email = this.appParams.getParameter("Administration.EmailFromAddress", null);
        if (email == null) {
            return null;
        }
        return EmailAddress.getByAddress(email);
    }

    public void setEmailSMTPServer(String smtpServer) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        this.appParams.setParameter("Administration.EmailSMTPServer", smtpServer);
    }

    public String getEmailSMTPServer() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.EmailSMTPServer", null);
    }

    public void setEmailUsername(String username) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        this.appParams.setParameter("Administration.EmailUsername", username);
    }

    public String getEmailUsername() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.EmailUsername", null);
    }

    public void setEmailPassword(String password) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        this.appParams.setParameter("Administration.EmailPassword", password);
    }

    public String getEmailPassword() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.EmailPassword", null);
    }

    public void setEmailSMTPPort(int port) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (port < 0 || port > 65535) {
            throw new InputValidationException("The port provided is invalid", "SMTP Port", String.valueOf(port));
        }
        this.appParams.setParameter("Administration.EmailSMTPPort", String.valueOf(port));
    }

    public int getEmailSMTPPort() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return (int)this.appParams.getParameter("Administration.EmailSMTPPort", 25L);
    }

    public void setEmailSMTPEncryption(GenericUtils.SMTPEncryption enc) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (enc == null) {
            enc = GenericUtils.SMTPEncryption.NONE;
        }
        this.appParams.setParameter("Administration.EmailSMTPEncryption", enc.toString().toUpperCase());
    }

    public GenericUtils.SMTPEncryption getEmailSMTPEncryption() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        String setting = this.appParams.getParameter("Administration.EmailSMTPEncryption", "NONE");
        GenericUtils.SMTPEncryption enc = GenericUtils.SMTPEncryption.valueOf(setting.toUpperCase());
        if (enc == null) {
            return GenericUtils.SMTPEncryption.NONE;
        }
        return enc;
    }

    public void setRescanOnEditEnabled(boolean enable) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (enable) {
            this.appParams.setParameter("Scanner.ReScanOnEdit", String.valueOf(1));
        } else {
            this.appParams.setParameter("Scanner.ReScanOnEdit", String.valueOf(0));
        }
    }

    public boolean isRescanOnEditEnabled() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Scanner.ReScanOnEdit", 0L) == 1L;
    }

    public void setDefaultScanningEnabled(boolean enable) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (enable) {
            this.appParams.setParameter("Scanner.DefaultEnabled", String.valueOf(1));
        } else {
            this.appParams.setParameter("Scanner.DefaultEnabled", String.valueOf(0));
        }
    }

    public boolean isDefaultScanningEnabled() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Scanner.DefaultEnabled", 0L) == 1L;
    }

    public void setDatabaseSchemaVersion(String schemaVersion) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        this.appParams.setParameter("Administration.DatabaseSchemaVersion", schemaVersion);
    }

    public String getDatabaseSchemaVersion() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.DatabaseSchemaVersion", null);
    }

    public synchronized String getUniqueInstallationID() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        String uniqueID = this.appParams.getParameter("Administration.UniqueInstallationID", "");
        if (uniqueID.length() == 0) {
            uniqueID = UUID.randomUUID().toString();
            this.appParams.setParameter("Administration.UniqueInstallationID", uniqueID);
        }
        return uniqueID;
    }

    public boolean isAutomaticDefragmentationEnabled() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.appParams.getParameter("Administration.AutoDefragEnabled", 0L) == 1L;
    }

    public void setAutomaticDefragmentation(boolean enable) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        if (enable) {
            this.appParams.setParameter("Administration.AutoDefragEnabled", String.valueOf(1));
        } else {
            this.appParams.setParameter("Administration.AutoDefragEnabled", String.valueOf(0));
        }
    }

    private class LicenseChecker
    extends Thread {
        public Thread.UncaughtExceptionHandler exHandler = null;

        private LicenseChecker() {
        }

        @Override
        public void run() {
            try {
                try {
                    ApplicationConfiguration.this.licenseBeingChecked = true;
                    ApplicationConfiguration.this.fetchLicense();
                }
                catch (Exception e) {
                    if (this.exHandler != null) {
                        this.exHandler.uncaughtException(this, e);
                    }
                    ApplicationConfiguration.this.licenseBeingChecked = false;
                }
            }
            finally {
                ApplicationConfiguration.this.licenseBeingChecked = false;
            }
        }
    }
}

