/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.util.Hashtable;
import net.lukemurphey.nsia.Application;

public class ApplicationStateMonitor
extends Thread {
    private int interval = 10;
    private int maxEntries = 500;
    static long lastDataCollection = 0L;
    private int currentPointer = 0;
    private int length = 0;
    private boolean stopRunning = false;
    private int scannedDeviations = 0;
    private int scannedIncomplete = 0;
    private int scannedPassed = 0;
    Application application = null;
    ApplicationStateDataPoint[] metricsEntries;

    public ApplicationStateMonitor(int interval, int entries, Application application) {
        super("Application State Monitor");
        this.interval = interval > 0 ? interval : 10;
        if (application == null) {
            throw new IllegalArgumentException("Application reference cannot be null");
        }
        this.application = application;
        if (entries < 1) {
            throw new IllegalArgumentException("Entries must be greater than zero");
        }
        this.maxEntries = entries;
        this.metricsEntries = new ApplicationStateDataPoint[this.maxEntries];
    }

    @Override
    public void run() {
        this.enterMainLoop();
    }

    public void shutdown() {
        this.stopRunning = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementIncompleteRulesCount() {
        ApplicationStateMonitor applicationStateMonitor = this;
        synchronized (applicationStateMonitor) {
            ++this.scannedIncomplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFailedRulesCount() {
        ApplicationStateMonitor applicationStateMonitor = this;
        synchronized (applicationStateMonitor) {
            ++this.scannedDeviations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementPassedRulesCount() {
        ApplicationStateMonitor applicationStateMonitor = this;
        synchronized (applicationStateMonitor) {
            ++this.scannedPassed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationStateDataPoint[] getData() {
        ApplicationStateMonitor applicationStateMonitor = this;
        synchronized (applicationStateMonitor) {
            ApplicationStateDataPoint[] metrics = new ApplicationStateDataPoint[this.length];
            int entry = this.currentPointer;
            int c = 0;
            while (c < this.length) {
                entry = entry + 1 >= this.length ? 0 : ++entry;
                ApplicationStateDataPoint dataPoint = new ApplicationStateDataPoint();
                dataPoint.threadCount = this.metricsEntries[entry].threadCount;
                dataPoint.usedMemory = this.metricsEntries[entry].usedMemory;
                dataPoint.databaseConnections = this.metricsEntries[entry].databaseConnections;
                dataPoint.rulesAcceptedCount = this.metricsEntries[entry].rulesAcceptedCount;
                dataPoint.rulesIncompleteCount = this.metricsEntries[entry].rulesIncompleteCount;
                dataPoint.rulesRejectedCount = this.metricsEntries[entry].rulesRejectedCount;
                metrics[c] = dataPoint;
                ++c;
            }
            return metrics;
        }
    }

    private void enterMainLoop() {
        while (!this.stopRunning) {
            try {
                ApplicationStateMonitor.sleep(this.interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.generateMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMetrics() {
        ApplicationStateMonitor applicationStateMonitor = this;
        synchronized (applicationStateMonitor) {
            long usedMem = this.application.getUsedMemory();
            int threadCount = this.application.getThreadCount();
            int databaseConnections = this.application.getDatabaseConnectionCount();
            ApplicationStateDataPoint newEntry = new ApplicationStateDataPoint();
            newEntry.threadCount = threadCount;
            newEntry.usedMemory = usedMem;
            newEntry.databaseConnections = databaseConnections;
            int rulesRejected = 0;
            int rulesAccepted = 0;
            int rulesIncomplete = 0;
            rulesRejected = this.scannedDeviations;
            rulesAccepted = this.scannedPassed;
            rulesIncomplete = this.scannedIncomplete;
            this.scannedDeviations = 0;
            this.scannedPassed = 0;
            this.scannedIncomplete = 0;
            newEntry.rulesAcceptedCount = rulesAccepted;
            newEntry.rulesRejectedCount = rulesRejected;
            newEntry.rulesIncompleteCount = rulesIncomplete;
            this.metricsEntries[this.currentPointer] = newEntry;
            this.currentPointer = this.currentPointer + 1 >= this.maxEntries ? 0 : ++this.currentPointer;
            if (this.length + 1 != this.maxEntries) {
                ++this.length;
            }
        }
    }

    public static class ApplicationStateDataPoint {
        public int threadCount;
        public long usedMemory;
        public int databaseConnections;
        public int rulesRejectedCount;
        public int rulesAcceptedCount;
        public int rulesIncompleteCount;

        public Hashtable<String, Object> toHashtable() {
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("ThreadCount", this.threadCount);
            hash.put("UsedMemory", Double.valueOf(this.usedMemory));
            hash.put("DatabaseConnections", this.databaseConnections);
            hash.put("RejectedRules", this.rulesRejectedCount);
            hash.put("AcceptedRules", this.rulesAcceptedCount);
            hash.put("IncompleteRules", this.rulesIncompleteCount);
            return hash;
        }
    }
}

