/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class DatabaseBackup
implements WorkerThread {
    private WorkerThread.State state = WorkerThread.State.INITIALIZED;
    private Exception exceptionThrown = null;
    private boolean stop = false;
    private Phase phase = null;
    private String BACKUP_LOCATION = "../var/backups/";

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        if (this.state == WorkerThread.State.STOPPED) {
            return 100;
        }
        if (this.state != WorkerThread.State.STARTED && this.state != WorkerThread.State.STOPPING) {
            return 0;
        }
        if (this.phase == null || this.phase == Phase.INITIALIZING) {
            return 0;
        }
        if (this.phase == Phase.EXPORTING_DATABASE) {
            return 25;
        }
        if (this.phase == Phase.COMPRESSING_ARCHIVE) {
            return 50;
        }
        if (this.phase == Phase.CLEANING_UP) {
            return 75;
        }
        if (this.phase == Phase.DONE) {
            return 100;
        }
        return 0;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.state;
    }

    @Override
    public String getStatusDescription() {
        if (this.state == WorkerThread.State.STOPPED) {
            return "Backup complete";
        }
        if (this.phase == null || this.phase == Phase.INITIALIZING) {
            return "Backup process initializing";
        }
        if (this.phase == Phase.EXPORTING_DATABASE) {
            return "Exporting database to temporary location";
        }
        if (this.phase == Phase.COMPRESSING_ARCHIVE) {
            return "Compressing database backup archive";
        }
        if (this.phase == Phase.CLEANING_UP) {
            return "Cleaning up temporary files";
        }
        if (this.phase == Phase.DONE) {
            return "Backup complete";
        }
        return "Backup in process";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block60: {
            block58: {
                block59: {
                    block56: {
                        outputStream = null;
                        zos = null;
                        backupFile = null;
                        this.state = WorkerThread.State.STARTED;
                        this.phase = Phase.INITIALIZING;
                        date = new Date();
                        dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH.mm.ss Z");
                        tempDir = System.getProperty("java.io.tmpdir");
                        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
                            tempDir = String.valueOf(tempDir) + System.getProperty("file.separator");
                        }
                        if (!(temporaryDirectory = new File(String.valueOf(tempDir) + "backup_" + dateFormat.format(date))).mkdir()) {
                            throw new IOException("Could not delete directory \"" + temporaryDirectory.getAbsolutePath() + "\"");
                        }
                        if (!this.stop) break block56;
                        this.state = WorkerThread.State.STOPPED;
lbl16:
                        // 2 sources

                        while (true) {
                            block57: {
                                try {
                                    if (zos != null) {
                                        zos.close();
                                    }
                                    if (outputStream != null) {
                                        outputStream.close();
                                    }
                                }
                                catch (IOException e) {
                                    if (this.exceptionThrown != null && this.exceptionThrown.getCause() == null) {
                                        e.initCause(this.exceptionThrown);
                                        this.exceptionThrown = e;
                                    }
                                    if (this.exceptionThrown != null) break block57;
                                    this.exceptionThrown = e;
                                }
                            }
                            return;
                        }
                    }
                    this.phase = Phase.EXPORTING_DATABASE;
                    this.backupToDirectory(temporaryDirectory);
                    if (this.stop) {
                        this.state = WorkerThread.State.STOPPED;
                        ** continue;
                    }
                    this.phase = Phase.COMPRESSING_ARCHIVE;
                    backupsDir = new File(this.BACKUP_LOCATION);
                    if (!backupsDir.exists() && !backupsDir.mkdir()) {
                        throw new IOException("Could not create directory to store databaes backups");
                    }
                    backupFile = String.valueOf(this.BACKUP_LOCATION) + "backup_" + dateFormat.format(date) + ".zip";
                    outputStream = new FileOutputStream(new File(backupFile));
                    zos = new ZipOutputStream(outputStream);
                    GenericUtils.zipDir(temporaryDirectory, zos);
                    if (!this.stop) break block58;
                    this.state = WorkerThread.State.STOPPED;
                    try {
                        if (zos != null) {
                            zos.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (this.exceptionThrown != null && this.exceptionThrown.getCause() == null) {
                            e.initCause(this.exceptionThrown);
                            this.exceptionThrown = e;
                        }
                        if (this.exceptionThrown != null) break block59;
                        this.exceptionThrown = e;
                    }
                }
                return;
            }
            try {
                this.phase = Phase.CLEANING_UP;
                GenericUtils.deleteDirectory(temporaryDirectory);
                this.state = WorkerThread.State.STOPPED;
            }
            catch (IOException e) {
                this.exceptionThrown = e;
                try {
                    if (zos != null) {
                        zos.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block60;
                }
                catch (IOException e) {
                    if (this.exceptionThrown != null && this.exceptionThrown.getCause() == null) {
                        e.initCause(this.exceptionThrown);
                        this.exceptionThrown = e;
                    } else if (this.exceptionThrown == null) {
                        this.exceptionThrown = e;
                    }
                    break block60;
                }
            }
            catch (NoDatabaseConnectionException e) {
                this.exceptionThrown = e;
                break block60;
            }
            catch (SQLException e) {
                this.exceptionThrown = e;
                {
                    catch (Throwable var9_19) {
                        throw var9_19;
                    }
                }
                try {
                    if (zos != null) {
                        zos.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block60;
                }
                catch (IOException e) {
                    if (this.exceptionThrown != null && this.exceptionThrown.getCause() == null) {
                        e.initCause(this.exceptionThrown);
                        this.exceptionThrown = e;
                    } else if (this.exceptionThrown == null) {
                        this.exceptionThrown = e;
                    }
                    break block60;
                }
            }
            {
                finally {
                    block61: {
                        try {
                            if (zos != null) {
                                zos.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                        catch (IOException e) {
                            if (this.exceptionThrown != null && this.exceptionThrown.getCause() == null) {
                                e.initCause(this.exceptionThrown);
                                this.exceptionThrown = e;
                                break block61;
                            }
                            if (this.exceptionThrown != null) break block61;
                            this.exceptionThrown = e;
                        }
                    }
                }
            }
            try {
                if (zos != null) {
                    zos.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                if (this.exceptionThrown != null && this.exceptionThrown.getCause() == null) {
                    e.initCause(this.exceptionThrown);
                    this.exceptionThrown = e;
                }
                if (this.exceptionThrown != null) break block60;
                this.exceptionThrown = e;
            }
        }
        if (this.exceptionThrown != null) {
            message = new EventLogMessage(EventLogMessage.EventType.TASK_FAILED, new EventLogField[]{new EventLogField(EventLogField.FieldName.TASK, "Database Backup")});
            message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Exception thrown while backing up database"));
            Application.getApplication().logExceptionEvent(message, (Throwable)this.exceptionThrown);
        } else if (this.stop) {
            message = new EventLogMessage(EventLogMessage.EventType.TASK_TERMINATED, new EventLogField[]{new EventLogField(EventLogField.FieldName.TASK, "Database Backup")});
            Application.getApplication().logEvent(message);
        } else {
            message = new EventLogMessage(EventLogMessage.EventType.TASK_COMPLETED, new EventLogField[]{new EventLogField(EventLogField.FieldName.TASK, "Database Backup")});
            message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Database backup successful"));
            message.addField(new EventLogField(EventLogField.FieldName.FILE, backupFile));
            Application.getApplication().logEvent(message);
        }
        this.state = WorkerThread.State.STOPPED;
    }

    private void backupToDirectory(File directory) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        CallableStatement statement = null;
        SQLException initCause = null;
        try {
            try {
                connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
                statement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
                statement.setString(1, directory.getAbsolutePath());
                statement.execute();
            }
            catch (SQLException e) {
                initCause = e;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e2) {
                    if (initCause == null) {
                        throw e2;
                    }
                    if (e2.getCause() == null) {
                        e2.initCause(initCause);
                        throw e2;
                    }
                    if (e2.getCause() != null) {
                        throw initCause;
                    }
                }
            }
        }
        finally {
            block21: {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    if (initCause == null) {
                        throw e;
                    }
                    if (e.getCause() == null) {
                        e.initCause(initCause);
                        throw e;
                    }
                    if (e.getCause() == null) break block21;
                    throw initCause;
                }
            }
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    @Override
    public void terminate() {
        if (this.state == WorkerThread.State.STARTED || this.state == WorkerThread.State.STARTING) {
            this.state = WorkerThread.State.STOPPING;
        }
        this.stop = true;
    }

    @Override
    public String getTaskDescription() {
        return "Database Backup";
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }

    private static enum Phase {
        INITIALIZING,
        EXPORTING_DATABASE,
        COMPRESSING_ARCHIVE,
        CLEANING_UP,
        DONE;

    }
}

