/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.util.TimerTask;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionSet;

public class DefinitionUpdateWorker
extends TimerTask
implements WorkerThread {
    private WorkerThread.State state = WorkerThread.State.INITIALIZED;
    private int startTime;
    private static int EXPECTED_MAX_TIME = 40000;
    private static int THIRD = EXPECTED_MAX_TIME / 3;
    private DefinitionSet.DefinitionVersionID versionID = null;
    private boolean checkingForNewDefinitions = false;
    private boolean definitionsCurrent = true;
    private Exception exceptionThrown = null;
    private boolean force = false;
    private String message = null;

    public DefinitionUpdateWorker() {
    }

    public DefinitionUpdateWorker(boolean force) {
        this.force = force;
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        int currentTime = (int)System.currentTimeMillis();
        int diff = currentTime - this.startTime;
        if (diff <= THIRD) {
            return 100 * diff / THIRD / 2;
        }
        if (diff > EXPECTED_MAX_TIME) {
            return 100;
        }
        return 50 + 100 * (diff - THIRD) / (EXPECTED_MAX_TIME - THIRD) / 2;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.state;
    }

    @Override
    public String getStatusDescription() {
        if (this.message != null) {
            return this.message;
        }
        if (this.checkingForNewDefinitions && this.state == WorkerThread.State.STARTED) {
            return "Checking for new definitions";
        }
        if (this.state == WorkerThread.State.INITIALIZED) {
            return "Ready to update";
        }
        if (this.state == WorkerThread.State.STARTING) {
            return "Preparing to update";
        }
        if (this.state == WorkerThread.State.STARTED) {
            return "Retrieving updates";
        }
        if (this.exceptionThrown != null && this.state == WorkerThread.State.STOPPED) {
            return "Unable to update definitions";
        }
        if (this.definitionsCurrent && this.versionID != null && this.state == WorkerThread.State.STOPPED) {
            return "Definitions current (" + this.versionID.toString() + ")";
        }
        if (this.definitionsCurrent && this.versionID == null && this.state == WorkerThread.State.STOPPED) {
            return "Definitions current";
        }
        if (this.versionID != null && this.state == WorkerThread.State.STOPPED) {
            return "Definitions current";
        }
        if (this.versionID == null && this.state == WorkerThread.State.STOPPED) {
            return "Definitions were not updated";
        }
        return "Retrieving updates";
    }

    @Override
    public boolean cancel() {
        this.terminate();
        return true;
    }

    @Override
    public String getTaskDescription() {
        return "Definitions Updater";
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return false;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void run() {
        try {
            if (!this.force && !Application.getApplication().getApplicationConfiguration().getAutoDefinitionUpdating()) {
                this.state = WorkerThread.State.STOPPED;
                return;
            }
            this.state = WorkerThread.State.STARTING;
            this.startTime = (int)System.currentTimeMillis();
            this.exceptionThrown = null;
            DefinitionArchive archive = DefinitionArchive.getArchive();
            this.state = WorkerThread.State.STARTED;
            this.checkingForNewDefinitions = true;
            boolean newDefinitionsAvailable = archive.isNewDefinitionSetAvailable();
            this.checkingForNewDefinitions = false;
            LicenseDescriptor license = Application.getApplication().getApplicationConfiguration().getLicense(false);
            if (!license.isValid()) {
                this.message = "New definitions cannot be downloaded: do not have a valid license";
            } else if (newDefinitionsAvailable) {
                this.versionID = archive.updateDefinitions();
                EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.DEFINITION_SET_UPDATED);
                message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_SET_REVISION, this.versionID.toString()));
                Application.getApplication().logEvent(message);
            } else {
                this.versionID = archive.getVersionID();
                this.definitionsCurrent = true;
                EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.DEFINITIONS_CURRENT);
                message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_SET_REVISION, this.versionID.toString()));
                Application.getApplication().logEvent(message);
            }
        }
        catch (Exception e) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.TASK_FAILED);
            message.addField(new EventLogField(EventLogField.FieldName.TASK, this.getTaskDescription()));
            Application.getApplication().logExceptionEvent(message, (Throwable)e);
            this.exceptionThrown = e;
        }
        this.state = WorkerThread.State.STOPPED;
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }
}

