/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.WorkerThread;

public class DelayedShutdown
implements WorkerThread {
    private int shutdownSeconds = 60;
    private long startSeconds = -1L;
    private boolean running = false;
    private boolean terminationRequested = false;
    private Application application;
    private Application.ShutdownRequestSource source;

    public DelayedShutdown(int secondsUntilShutdown, Application application, Application.ShutdownRequestSource source) {
        if (application == null) {
            throw new IllegalArgumentException("Application cannot be null");
        }
        this.shutdownSeconds = secondsUntilShutdown;
        this.application = application;
        this.source = source;
        application.getNetworkManager().stopListener();
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        int percentage = (int)(System.currentTimeMillis() - this.startSeconds) / (this.shutdownSeconds * 1000);
        if (percentage > 100) {
            return 100;
        }
        return percentage;
    }

    @Override
    public WorkerThread.State getStatus() {
        if (this.terminationRequested && this.running) {
            return WorkerThread.State.STOPPING;
        }
        if (!this.terminationRequested && this.running) {
            return WorkerThread.State.STARTED;
        }
        return WorkerThread.State.STOPPED;
    }

    @Override
    public String getStatusDescription() {
        return "System is shutting down in ";
    }

    @Override
    public String getTaskDescription() {
        return "System Shutdown";
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    @Override
    public void terminate() {
        this.terminationRequested = true;
    }

    @Override
    public void run() {
        this.running = true;
        this.terminationRequested = false;
        this.startSeconds = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() < this.startSeconds + (long)(this.shutdownSeconds * 1000) && !this.terminationRequested) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.terminationRequested) {
            this.application.shutdown(this.source);
        }
        this.running = false;
    }

    @Override
    public Throwable getException() {
        return null;
    }
}

