/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import net.lukemurphey.nsia.WorkerThread;

public class DummyWorker
implements WorkerThread {
    private int progress = 0;
    private WorkerThread.State status = WorkerThread.State.STOPPED;
    private int delays_secs = 20;
    private boolean terminate = false;
    private String taskDesc = "Dummy Worker";

    public DummyWorker(String taskDesc, int delays_secs) {
        this.delays_secs = delays_secs;
        this.taskDesc = taskDesc;
    }

    public DummyWorker() {
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public Throwable getException() {
        return null;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.status;
    }

    @Override
    public String getStatusDescription() {
        return "Waiting for a total of " + this.delays_secs + " seconds; currently " + this.getProgress() + "% done.";
    }

    @Override
    public String getTaskDescription() {
        return this.taskDesc;
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    @Override
    public void terminate() {
        this.terminate = true;
    }

    @Override
    public void run() {
        this.status = WorkerThread.State.STARTED;
        int waitedSecs = 0;
        this.terminate = false;
        while (!this.terminate && waitedSecs < this.delays_secs) {
            try {
                Thread.sleep(1000L);
                this.progress = 100 * ++waitedSecs / this.delays_secs;
            }
            catch (InterruptedException e) {
                this.terminate = true;
            }
        }
        this.status = WorkerThread.State.STOPPED;
    }
}

