/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.HostAddress;
import net.lukemurphey.nsia.InvalidLocalPartException;

public class EmailAddress
implements Serializable {
    private static final long serialVersionUID = 9125919743291939606L;
    private String mailUser;
    private HostAddress mailHost;
    private static String EMAIL_LOCAL_PART_REGEX = "^[_a-zA-Z0-9-*+]+(\\.[_a-zA-Z0-9-*+]+)*";

    private EmailAddress(String mailUser, InetAddress mailHost) throws UnknownHostException {
        if (mailHost == null) {
            throw new UnknownHostException("Host name is null");
        }
        this.mailUser = mailUser;
        this.mailHost = new HostAddress(mailHost.getHostName());
    }

    private EmailAddress(String mailUser, HostAddress mailHost) throws UnknownHostException {
        if (mailHost == null) {
            throw new UnknownHostException("Host name is null");
        }
        this.mailUser = mailUser;
        this.mailHost = mailHost;
    }

    public static EmailAddress getByAddress(String address) throws UnknownHostException, InvalidLocalPartException {
        if (address == null) {
            throw new UnknownHostException("Email address is null");
        }
        if (address.length() == 0) {
            throw new UnknownHostException("Email address is empty");
        }
        String[] parsedAddress = address.split("@");
        if (parsedAddress[0] == null || parsedAddress[0].length() == 0) {
            throw new InvalidLocalPartException("Email address contains invalid characters");
        }
        Pattern localPartRegex = Pattern.compile(EMAIL_LOCAL_PART_REGEX);
        Matcher matcher = localPartRegex.matcher(parsedAddress[0]);
        if (!matcher.matches()) {
            throw new InvalidLocalPartException("Email address contains invalid characters");
        }
        if (parsedAddress.length == 1 || parsedAddress[1] == null || parsedAddress[1].length() == 0) {
            throw new UnknownHostException("Host address is empty");
        }
        HostAddress mailHost = new HostAddress(parsedAddress[1]);
        return new EmailAddress(parsedAddress[0], mailHost);
    }

    public static EmailAddress getByAddress(String mailUser, InetAddress mailHost) throws UnknownHostException, InvalidLocalPartException {
        if (mailUser == null) {
            throw new InvalidLocalPartException("Local-part is null");
        }
        if (mailUser.length() == 0) {
            throw new InvalidLocalPartException("Local-part is empty");
        }
        if (mailHost == null) {
            throw new UnknownHostException("Host name is null");
        }
        Pattern localPartRegex = Pattern.compile(EMAIL_LOCAL_PART_REGEX);
        Matcher matcher = localPartRegex.matcher(mailUser);
        if (!matcher.matches()) {
            throw new InvalidLocalPartException("Email address contains invalid characters");
        }
        return new EmailAddress(mailUser, mailHost);
    }

    public String getLocalPart() {
        return this.mailUser;
    }

    public HostAddress getDomain() {
        return this.mailHost;
    }

    public String toString() {
        return String.valueOf(this.mailUser) + "@" + this.mailHost.toString();
    }
}

