/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.InetAddress;
import java.sql.Timestamp;
import net.lukemurphey.nsia.HostAddress;
import net.lukemurphey.nsia.InetAddressRange;

public class FirewallRule {
    private InetAddressRange addressRange;
    private boolean denyRule = true;
    private long ruleId = -1L;
    private Timestamp expiresOn;

    public FirewallRule(InetAddressRange ruleAddressRange, boolean ruleDeny, long ruleId, Timestamp ruleExpireTime) {
        if (ruleAddressRange == null) {
            throw new IllegalArgumentException("The IP address range cannot be null");
        }
        if (ruleId < 0L) {
            throw new IllegalArgumentException("The rule ID must not be less than zero");
        }
        this.addressRange = ruleAddressRange;
        this.denyRule = ruleDeny;
        this.ruleId = ruleId;
        this.expiresOn = ruleExpireTime;
    }

    public FirewallRule(InetAddressRange ruleAddressRange, boolean ruleDeny, long ruleId) {
        this(ruleAddressRange, ruleDeny, ruleId, null);
    }

    public FirewallRule(InetAddressRange ruleAddressRange, boolean ruleDeny) {
        if (ruleAddressRange == null) {
            throw new IllegalArgumentException("The IP address range cannot be null");
        }
        this.addressRange = ruleAddressRange;
        this.denyRule = ruleDeny;
    }

    public FirewallRule(InetAddressRange ruleAddressRange, boolean ruleDeny, Timestamp ruleExpireTime) {
        if (ruleAddressRange == null) {
            throw new IllegalArgumentException("The IP address range cannot be null");
        }
        this.addressRange = ruleAddressRange;
        this.denyRule = ruleDeny;
        this.expiresOn = ruleExpireTime;
    }

    public boolean isDenyRule() {
        return this.denyRule;
    }

    public InetAddressRange getAddressRange() {
        return this.addressRange;
    }

    public Timestamp getRuleExpireTime() {
        return this.expiresOn;
    }

    public boolean isExpired() {
        long expireTime;
        if (this.expiresOn == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime > (expireTime = this.expiresOn.getTime());
    }

    public long getRuleId() {
        return this.ruleId;
    }

    public Result isAccepted(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("The IP address cannot be null");
        }
        if (this.addressRange.isWithinRange(address)) {
            if (this.denyRule) {
                return Result.REJECT;
            }
            return Result.ACCEPT;
        }
        return Result.NOT_MATCH;
    }

    public Result isAccepted(HostAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("The IP address cannot be null");
        }
        if (this.addressRange.isWithinRange(address)) {
            if (this.denyRule) {
                return Result.REJECT;
            }
            return Result.ACCEPT;
        }
        return Result.NOT_MATCH;
    }

    public static enum Result {
        NOT_MATCH,
        ACCEPT,
        REJECT;

    }
}

