/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GroupMembershipDescriptor;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.UserManagement;

public class GroupManagement {
    public static final String GROUP_NAME_REGEX = ".{1,64}";
    public static final int GROUP_NAME_LENGTH = 64;
    public static final String GROUP_DESCRIPTION_REGEX = ".{0,512}";
    public static final int GROUP_DESCRIPTION_LENGTH = 512;
    private Application appRes;

    public GroupManagement(Application appResources) {
        this.appRes = appResources;
    }

    public int getGroupID(String groupName) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        Pattern groupNamePattern = Pattern.compile(GROUP_NAME_REGEX);
        Matcher groupNameMatcher = groupNamePattern.matcher(groupName);
        if (!groupNameMatcher.matches()) {
            throw new InputValidationException("The group name contains invalid characters", "GroupName", groupName);
        }
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = connection.prepareStatement("Select * from Groups where GroupName = ?");
            statement.setString(1, groupName);
            result = statement.executeQuery();
            if (result.next()) {
                int n = result.getInt("GroupID");
                return n;
            }
            return -1;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int addGroup(String groupName, String groupDescription) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        Pattern groupDescriptionPattern;
        Matcher groupDescriptionMatcher;
        if (groupName == null) throw new IllegalArgumentException("Group name is invalid (null)");
        if (groupName.length() == 0) {
            throw new IllegalArgumentException("Group name is invalid (null)");
        }
        if (groupName.length() == 0) {
            throw new IllegalArgumentException("Group name is invalid (empty string)");
        }
        Pattern groupNamePattern = Pattern.compile(GROUP_NAME_REGEX);
        Matcher matcher = groupNamePattern.matcher(groupName);
        if (!matcher.matches()) {
            throw new InputValidationException("Group name contains invalid characters", "GroupName", groupName);
        }
        if (groupDescription == null) {
            groupDescription = "";
        }
        if (!(groupDescriptionMatcher = (groupDescriptionPattern = Pattern.compile(GROUP_DESCRIPTION_REGEX)).matcher(groupDescription)).matches()) {
            throw new InputValidationException("Group description contains invalid characters", "GroupDescription", groupDescription);
        }
        if (this.getGroupID(groupName) != -1) {
            return -1;
        }
        Connection conn = null;
        Statement preparedStatement = null;
        ResultSet keys = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
            preparedStatement = conn.prepareStatement("Insert into Groups (GroupName, GroupDescription, Status) values (?, ?, ?)", 1);
            preparedStatement.setString(1, groupName);
            preparedStatement.setString(2, groupDescription);
            preparedStatement.setInt(3, State.ACTIVE.ordinal());
            if (preparedStatement.executeUpdate() < 1) {
                return -1;
            }
            keys = preparedStatement.getGeneratedKeys();
            if (!keys.next()) return -1;
            int n = keys.getInt(1);
            return n;
        }
        finally {
            if (keys != null) {
                keys.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public GroupDescriptor getGroupDescriptor(int groupId) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        if (groupId < 1) {
            throw new IllegalArgumentException("The group ID must be greater than 0");
        }
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = connection.prepareStatement("Select * from Groups where GroupID = ?");
            statement.setInt(1, groupId);
            result = statement.executeQuery();
            if (result.next()) {
                GroupDescriptor groupDesc;
                String groupName = result.getString("GroupName");
                String groupDescription = result.getString("GroupDescription");
                State groupStatus = this.convertGroupFromInt(result.getInt("Status"));
                GroupDescriptor groupDescriptor = groupDesc = new GroupDescriptor(groupId, groupName, groupDescription, groupStatus);
                return groupDescriptor;
            }
            throw new NotFoundException("No group exists with the given identifier");
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private State convertGroupFromInt(int value) {
        State[] states = State.values();
        int c = 0;
        while (c < states.length) {
            if (states[c].ordinal() == value) {
                return states[c];
            }
            ++c;
        }
        return State.INACTIVE;
    }

    public GroupDescriptor getGroupDescriptor(String groupName) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        int groupId = this.getGroupID(groupName);
        return this.getGroupDescriptor(groupId);
    }

    public boolean updateGroupInfo(int groupId, String groupName, String groupDescription) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (groupId < 1) {
            throw new IllegalArgumentException("Group ID is invalid (must be greater than 0)");
        }
        if (groupName == null || groupName.length() == 0) {
            throw new IllegalArgumentException("Group name is invalid (null)");
        }
        if (groupName.length() == 0) {
            throw new IllegalArgumentException("Group name is invalid (empty string)");
        }
        Pattern groupNamePattern = Pattern.compile(GROUP_NAME_REGEX);
        Matcher matcher = groupNamePattern.matcher(groupName);
        if (!matcher.matches()) {
            throw new InputValidationException("Group name contains invalid characters", "GroupName", groupName);
        }
        Pattern groupDescriptionPattern = Pattern.compile(GROUP_DESCRIPTION_REGEX);
        Matcher groupDescriptionMatcher = groupDescriptionPattern.matcher(groupDescription);
        if (!groupDescriptionMatcher.matches()) {
            throw new InputValidationException("The group description contains invalid characters", "GroupDescription", groupDescription);
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
            if (conn == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = conn.prepareStatement("Update Groups set GroupName = ?, GroupDescription = ? where GroupID = ?");
            statement.setString(1, groupName);
            statement.setString(2, groupDescription);
            statement.setInt(3, groupId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean deleteGroup(int groupId) throws SQLException, NoDatabaseConnectionException {
        if (groupId < 1) {
            throw new IllegalArgumentException("The group ID must be greater than 0");
        }
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
            preparedStatement = conn.prepareStatement("Delete from Groups where GroupID = ?");
            preparedStatement.setInt(1, groupId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean disableGroup(int groupId) throws SQLException, NoDatabaseConnectionException {
        if (groupId < 1) {
            throw new IllegalArgumentException("The group ID must be greater than 0");
        }
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
            preparedStatement = conn.prepareStatement("Update Groups set Status = ? where GroupID = ?");
            preparedStatement.setInt(1, State.INACTIVE.ordinal());
            preparedStatement.setInt(2, groupId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean enableGroup(int groupId) throws SQLException, NoDatabaseConnectionException {
        if (groupId < 1) {
            throw new IllegalArgumentException("The group ID must be greater than 0");
        }
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
            preparedStatement = conn.prepareStatement("Update Groups set Status = ? where GroupID = ?");
            preparedStatement.setInt(1, State.ACTIVE.ordinal());
            preparedStatement.setInt(2, groupId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public GroupDescriptor[] getGroupDescriptors() throws SQLException, InputValidationException, NoDatabaseConnectionException {
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = connection.prepareStatement("Select * from Groups");
            result = statement.executeQuery();
            Vector<GroupDescriptor> groups = new Vector<GroupDescriptor>();
            while (result.next()) {
                String groupName = result.getString("GroupName");
                int groupId = result.getInt("GroupID");
                String groupDescription = result.getString("GroupDescription");
                State groupStatus = this.convertGroupFromInt(result.getInt("Status"));
                GroupDescriptor groupDesc = new GroupDescriptor(groupId, groupName, groupDescription, groupStatus);
                groups.add(groupDesc);
            }
            if (groups.size() == 0) {
                GroupDescriptor[] groupDescriptorArray = new GroupDescriptor[]{};
                return groupDescriptorArray;
            }
            GroupDescriptor[] descriptors = new GroupDescriptor[groups.size()];
            int d = 0;
            while (d < groups.size()) {
                descriptors[d] = (GroupDescriptor)groups.get(d);
                ++d;
            }
            GroupDescriptor[] groupDescriptorArray = descriptors;
            return groupDescriptorArray;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public UserManagement.UserDescriptor[] getMembers(int groupID) throws NoDatabaseConnectionException, SQLException {
        Vector<Integer> users = new Vector<Integer>();
        Connection connection = null;
        Statement associationQuery = null;
        ResultSet results = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            associationQuery = connection.prepareStatement("Select UserID from GroupUsersMap where GroupID = ?");
            associationQuery.setInt(1, groupID);
            results = associationQuery.executeQuery();
            while (results.next()) {
                users.add(results.getInt("UserID"));
            }
        }
        finally {
            if (associationQuery != null) {
                associationQuery.close();
            }
            if (results != null) {
                results.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        UserManagement userMgmt = new UserManagement(this.appRes);
        Vector<UserManagement.UserDescriptor> userDescriptors = new Vector<UserManagement.UserDescriptor>();
        for (Integer userID : users) {
            try {
                userDescriptors.add(userMgmt.getUserDescriptor(userID));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        UserManagement.UserDescriptor[] usersArray = new UserManagement.UserDescriptor[userDescriptors.size()];
        userDescriptors.toArray(usersArray);
        return usersArray;
    }

    public boolean isUserMemberOfGroup(int userId, int groupId) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement associationQuery = null;
        ResultSet results = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            associationQuery = connection.prepareStatement("Select * from GroupUsersMap where GroupID = ? and UserID =?");
            associationQuery.setInt(1, groupId);
            associationQuery.setInt(2, userId);
            results = associationQuery.executeQuery();
            return results.next();
            {
            }
        }
        finally {
            if (associationQuery != null) {
                associationQuery.close();
            }
            if (results != null) {
                results.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public GroupMembershipDescriptor getGroupMembership(int userId) throws SQLException, InputValidationException, NoDatabaseConnectionException {
        GroupMembershipDescriptor groupMembershipDescriptor = new GroupMembershipDescriptor(userId, this);
        return groupMembershipDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean addUserToGroup(int userId, int groupId) throws SQLException, NotFoundException, NoDatabaseConnectionException {
        Connection connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
        PreparedStatement testUser = null;
        Statement testGroup = null;
        ResultSet userResult = null;
        ResultSet groupResult = null;
        Statement associationQuery = null;
        ResultSet results = null;
        Statement associationUpdate = null;
        try {
            testUser = connection.prepareStatement("Select * from Users where UserID = ?");
            testUser.setInt(1, userId);
            userResult = testUser.executeQuery();
            if (!userResult.next()) {
                throw new NotFoundException("No user exists with the ID \"" + userId + "\"");
            }
            testGroup = connection.prepareStatement("Select * from Groups where GroupID =?");
            testGroup.setInt(1, groupId);
            groupResult = testGroup.executeQuery();
            if (!groupResult.next()) {
                throw new NotFoundException("No group exists with the ID \"" + groupId + "\"");
            }
            associationQuery = connection.prepareStatement("Select * from GroupUsersMap where GroupID = ? and UserID =?");
            associationQuery.setInt(1, groupId);
            associationQuery.setInt(2, userId);
            results = associationQuery.executeQuery();
            if (results.next()) {
                return true;
            }
            associationUpdate = connection.prepareStatement("Insert into GroupUsersMap (GroupID, UserID) values (?, ?)");
            associationUpdate.setInt(1, groupId);
            associationUpdate.setInt(2, userId);
            if (associationUpdate.executeUpdate() >= 1) return true;
            return false;
        }
        finally {
            if (testUser != null) {
                testUser.close();
            }
            if (testGroup != null) {
                testGroup.close();
            }
            if (userResult != null) {
                userResult.close();
            }
            if (userResult != null) {
                userResult.close();
            }
            if (associationQuery != null) {
                associationQuery.close();
            }
            if (results != null) {
                results.close();
            }
            if (associationUpdate != null) {
                associationUpdate.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public synchronized boolean removeUserFromGroup(int userId, int groupId) throws SQLException, NotFoundException, NoDatabaseConnectionException {
        Connection connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
        PreparedStatement testUser = null;
        ResultSet userResult = null;
        Statement testGroup = null;
        ResultSet groupResult = null;
        Statement associationUpdate = null;
        try {
            testUser = connection.prepareStatement("Select * from Users where UserID =?");
            testUser.setInt(1, userId);
            userResult = testUser.executeQuery();
            if (!userResult.next()) {
                throw new NotFoundException("No user exists with the ID \"" + userId + "\"");
            }
            testGroup = connection.prepareStatement("Select * from Groups where GroupID =?");
            testGroup.setInt(1, groupId);
            groupResult = testGroup.executeQuery();
            if (!groupResult.next()) {
                throw new NotFoundException("No group exists with the ID \"" + groupId + "\"");
            }
            associationUpdate = connection.prepareStatement("Delete from GroupUsersMap where GroupID = ? and UserID = ?");
            associationUpdate.setInt(1, groupId);
            associationUpdate.setInt(2, userId);
            associationUpdate.executeUpdate();
        }
        finally {
            if (testUser != null) {
                testUser.close();
            }
            if (userResult != null) {
                userResult.close();
            }
            if (testGroup != null) {
                testGroup.close();
            }
            if (groupResult != null) {
                groupResult.close();
            }
            if (associationUpdate != null) {
                associationUpdate.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return true;
    }

    public boolean isGroupActive(int groupId) throws SQLException, NoDatabaseConnectionException {
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.PERMISSIONS);
            statement = connection.prepareStatement("Select * from Groups where GroupID =? and Status =?");
            statement.setInt(1, groupId);
            statement.setInt(2, State.ACTIVE.ordinal());
            result = statement.executeQuery();
            boolean bl = result.next();
            return bl;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static class GroupDescriptor {
        private int groupId = -1;
        private String groupDescription;
        private String groupName;
        private State groupState = State.INACTIVE;

        public GroupDescriptor(int groupId, String groupName, String groupDescription, State groupStatus) throws InputValidationException {
            if (groupName == null) {
                throw new InputValidationException("The group name cannot be null", "GroupName", "null");
            }
            if (groupName.length() == 0) {
                throw new InputValidationException("The group name cannot be empty", "GroupName", groupName);
            }
            if (groupName.length() > 64) {
                throw new InputValidationException("The group name length is excessive", "GroupName", groupName);
            }
            Pattern groupNamePattern = Pattern.compile(GroupManagement.GROUP_NAME_REGEX);
            Matcher groupNameMatcher = groupNamePattern.matcher(groupName);
            if (!groupNameMatcher.matches()) {
                throw new InputValidationException("The group name contains invalid characters", "GroupName", groupName);
            }
            if (groupDescription == null) {
                groupDescription = "";
            }
            if (groupDescription.length() > 512) {
                throw new InputValidationException("The group description length is excessive", "GroupDescription", groupDescription);
            }
            Pattern groupDescriptionPattern = Pattern.compile(GroupManagement.GROUP_DESCRIPTION_REGEX);
            Matcher groupDescriptionMatcher = groupDescriptionPattern.matcher(groupDescription);
            if (!groupDescriptionMatcher.matches()) {
                throw new InputValidationException("The group description contains invalid characters", "GroupDescription", groupDescription);
            }
            if (groupStatus != State.ACTIVE) {
                groupStatus = State.INACTIVE;
            }
            this.groupId = groupId;
            this.groupName = groupName;
            this.groupDescription = groupDescription;
            this.groupState = groupStatus;
        }

        public String getDescription() {
            return this.groupDescription;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public State getGroupState() {
            return this.groupState;
        }

        public boolean isEnabled() {
            return this.groupState == State.ACTIVE;
        }
    }

    public static enum State {
        ACTIVE,
        INACTIVE;

    }
}

