/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.BindException;
import net.lukemurphey.nsia.Application;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SslListener;
import org.mortbay.jetty.Server;

public class HttpServer {
    protected Server server;

    public void startServer(int serverPort, boolean enableSSL) throws Exception, BindException {
        SocketListener listener;
        this.server = new Server();
        if (enableSSL) {
            String sslKeyPassword;
            String sslPassword;
            SslListener sslListener = new SslListener();
            String sslKeystore = Application.getApplication().getApplicationConfiguration().getKeystore();
            if (sslKeystore != null) {
                sslListener.setKeystore(sslKeystore);
            }
            if ((sslPassword = Application.getApplication().getApplicationConfiguration().getSslPassword()) != null) {
                sslListener.setPassword(sslPassword);
            }
            if ((sslKeyPassword = Application.getApplication().getApplicationConfiguration().getSslKeyPassword()) != null) {
                sslListener.setKeyPassword(sslKeyPassword);
            } else if (sslPassword != null) {
                sslListener.setKeyPassword(sslPassword);
            }
            listener = sslListener;
        } else {
            listener = new SocketListener();
        }
        listener.setPort(serverPort);
        this.server.setRootWebApp("webConsole");
        this.server.addWebApplication("/", "../lib/webConsole.war");
        this.server.addListener((HttpListener)listener);
        this.server.start();
    }

    public void shutdownServer() throws Exception {
        HttpContext[] httpContextArray = this.server.getContexts();
        int n = httpContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpContext context = httpContextArray[n2];
            context.setStopGracefully(true);
            context.stop(true);
            ++n2;
        }
        while (this.server.getConnections() > 0) {
            Thread.sleep(1000L);
            System.out.println("Waiting, connection count = " + this.server.getConnections());
        }
        this.server.stop(true);
    }
}

