/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.HostAddress;
import net.lukemurphey.nsia.InputValidationException;
import org.apache.commons.lang.NullArgumentException;

public class InetAddressRange {
    private int startOfRange;
    private int endOfRange;

    private InetAddressRange(InetAddress start, InetAddress end) {
        int startInt = InetAddressRange.getIntFromAddress(start);
        int endInt = InetAddressRange.getIntFromAddress(end);
        if (startInt >= 0 && endInt >= 0 && startInt > endInt) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        if (startInt < 0 && endInt < 0 && endInt < startInt) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        if (startInt < 0 && endInt >= 0) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        this.startOfRange = startInt;
        this.endOfRange = endInt;
    }

    private InetAddressRange(HostAddress start, HostAddress end) {
        if (start == null) {
            throw new NullArgumentException("The start address cannot be null");
        }
        if (start.addressType() != 0) {
            throw new IllegalArgumentException("The start address must be an IP address");
        }
        if (end.addressType() != 0) {
            throw new IllegalArgumentException("The end address must be an IP address");
        }
        int startInt = InetAddressRange.getIntFromAddress(start);
        int endInt = InetAddressRange.getIntFromAddress(end);
        if (startInt >= 0 && endInt >= 0 && startInt > endInt) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        if (startInt < 0 && endInt < 0 && endInt < startInt) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        if (startInt < 0 && endInt >= 0) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        this.startOfRange = startInt;
        this.endOfRange = endInt;
    }

    private InetAddressRange(int startInt, int endInt) {
        if (startInt >= 0 && endInt >= 0 && startInt > endInt) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        if (startInt < 0 && endInt < 0 && endInt < startInt) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        if (startInt < 0 && endInt >= 0) {
            throw new IllegalArgumentException("The start IP address must not be greater than the end address");
        }
        this.startOfRange = startInt;
        this.endOfRange = endInt;
    }

    public static InetAddressRange getByRange(InetAddress start, InetAddress end) {
        InetAddressRange inetAddressRange = new InetAddressRange(start, end);
        return inetAddressRange;
    }

    public static InetAddressRange getByRange(HostAddress start, HostAddress end) {
        InetAddressRange inetAddressRange = new InetAddressRange(start, end);
        return inetAddressRange;
    }

    public static InetAddressRange getByRange(int start, int end) {
        InetAddressRange inetAddressRange = new InetAddressRange(start, end);
        return inetAddressRange;
    }

    public static InetAddressRange getBySubnetRange(InetAddress start, InetAddress subnetMask) {
        if (start == null || subnetMask == null) {
            throw new IllegalArgumentException("Subnet mask and start address must not be null");
        }
        int subnetMaskLong = InetAddressRange.getIntFromAddress(subnetMask);
        int startAddress = InetAddressRange.getIntFromAddress(start);
        int endAddress = (startAddress &= ~subnetMaskLong) + subnetMaskLong;
        InetAddressRange inetAddressRange = new InetAddressRange(startAddress, endAddress);
        return inetAddressRange;
    }

    public static boolean isAddressLoopback(InetAddress inetAddress) {
        int addressInt = InetAddressRange.getIntFromAddress(inetAddress);
        int internalStart = 2130706433;
        int internalEnd = 0x7FFFFFFE;
        return addressInt <= internalEnd && addressInt >= internalStart;
    }

    public static boolean isAddressLoopback(HostAddress inetAddress) {
        int addressInt = InetAddressRange.getIntFromAddress(inetAddress);
        int internalStart = 2130706433;
        int internalEnd = 0x7FFFFFFE;
        return addressInt <= internalEnd && addressInt >= internalStart;
    }

    public static InetAddressRange getByRange(String range) throws InputValidationException, UnknownHostException {
        String[] ips = range.split("-");
        if (ips.length != 2) {
            return null;
        }
        String startIp = ips[0].trim();
        String endIp = ips[1].trim();
        Pattern singleIp = Pattern.compile("(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
        Matcher matcher = singleIp.matcher(startIp);
        if (!matcher.matches()) {
            throw new InputValidationException("Start address is invalid", "Start IP Address", startIp);
        }
        matcher = singleIp.matcher(endIp);
        if (!matcher.matches()) {
            throw new InputValidationException("End address is invalid", "End IP Address", endIp);
        }
        InetAddressRange inetAddressRange = new InetAddressRange(InetAddress.getByName(startIp), InetAddress.getByName(endIp));
        return inetAddressRange;
    }

    public boolean isWithinRange(InetAddress address) {
        int addressInt = InetAddressRange.getIntFromAddress(address);
        if (this.startOfRange >= 0 && this.endOfRange >= 0) {
            return addressInt >= this.startOfRange && addressInt <= this.endOfRange;
        }
        if (this.startOfRange < 0 && this.endOfRange < 0) {
            return addressInt <= this.startOfRange && addressInt >= this.endOfRange;
        }
        return addressInt >= this.startOfRange && addressInt >= this.endOfRange;
    }

    public boolean isWithinRange(HostAddress address) {
        int addressInt = InetAddressRange.getIntFromAddress(address);
        if (this.startOfRange >= 0 && this.endOfRange >= 0) {
            return addressInt >= this.startOfRange && addressInt <= this.endOfRange;
        }
        if (this.startOfRange < 0 && this.endOfRange < 0) {
            return addressInt <= this.startOfRange && addressInt >= this.endOfRange;
        }
        return addressInt >= this.startOfRange && addressInt >= this.endOfRange;
    }

    private static int getIntFromAddress(InetAddress address) {
        byte[] addressBytes = address.getAddress();
        int addressInt = 0;
        addressInt = (addressBytes[0] & 0xFF) * 0x1000000;
        addressInt += (addressBytes[1] & 0xFF) * 65536;
        addressInt += (addressBytes[2] & 0xFF) * 256;
        return addressInt += addressBytes[3] & 0xFF;
    }

    private static int getIntFromAddress(HostAddress address) {
        if (address == null) {
            throw new NullArgumentException("Address cannot be null");
        }
        String addressString = address.toString();
        String[] temp = addressString.split("\\.");
        if (temp.length != 4) {
            throw new IllegalArgumentException("Argument is not in a dotted-quad IP address format");
        }
        int[] addressBytes = new int[4];
        int c = 0;
        while (c < 4) {
            addressBytes[c] = Integer.parseInt(temp[c]);
            if (addressBytes[c] > 255 || addressBytes[c] < 0) {
                throw new IllegalArgumentException("Argument is not in a dotted-quad IP address format (value at position " + c + " is not valid [" + addressBytes[c] + "])");
            }
            ++c;
        }
        int addressInt = addressBytes[0] * 0x1000000;
        addressInt += addressBytes[1] * 65536;
        addressInt += addressBytes[2] * 256;
        return addressInt += addressBytes[3];
    }

    private String getAddressFromInt(int addressInt) {
        int quad1 = addressInt >> 24;
        if (quad1 < 0) {
            quad1 += 256;
        }
        int quad2 = (addressInt & 0xFF0000) >> 16;
        int quad3 = (addressInt & 0xFF00) >> 8;
        int quad4 = addressInt & 0xFF;
        return String.valueOf(quad1) + "." + quad2 + "." + quad3 + "." + quad4;
    }

    public String getStartAddressString() {
        return this.getAddressFromInt(this.startOfRange);
    }

    public String getEndAddressString() {
        return this.getAddressFromInt(this.endOfRange);
    }

    public String toString() {
        return String.valueOf(this.getStartAddressString()) + "-" + this.getEndAddressString();
    }
}

