/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class LicenseCheckWorker
implements WorkerThread {
    private Exception exceptionThrown = null;
    private WorkerThread.State state = WorkerThread.State.INITIALIZED;

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }

    @Override
    public int getProgress() {
        return -1;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.state;
    }

    @Override
    public String getStatusDescription() {
        if (this.state == WorkerThread.State.STARTED) {
            return "Retrieving license information";
        }
        if (this.state == WorkerThread.State.STOPPED) {
            return "License retrieval complete";
        }
        return "Not running";
    }

    @Override
    public String getTaskDescription() {
        return "License Validator";
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return false;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void run() {
        Application appRes = Application.getApplication();
        this.state = WorkerThread.State.STARTED;
        try {
            appRes.getApplicationConfiguration().getLicense();
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            this.exceptionThrown = e;
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            this.exceptionThrown = e;
        }
        catch (InputValidationException e) {
            this.exceptionThrown = e;
        }
        this.state = WorkerThread.State.STOPPED;
    }
}

