/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.Authentication;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import org.apache.commons.codec.binary.Hex;

public class LocalPasswordAuthentication
extends Authentication {
    private static long DEFAULT_AUTHENTICATION_ATTEMPT_LIMIT = 4L;
    private static long DEFAULT_AUTHENTICATION_AGGREGATION_PERIOD_SECONDS = 3600L;
    private static long SECONDS_AUTHENTICATION_DELAY = 1L;

    public LocalPasswordAuthentication(Application appResources) {
        super(appResources);
    }

    public Authentication.AuthenticationResult authenticate(String userName, PasswordAuthenticationValidator validator, ClientData clientData) throws NoSuchAlgorithmException, SQLException, InputValidationException, NoDatabaseConnectionException, NumericalOverflowException {
        UserManagement.UserDescriptor userDescriptor;
        UserManagement userControl = new UserManagement(this.appRes);
        try {
            userDescriptor = userControl.getUserDescriptor(userName);
        }
        catch (NotFoundException e) {
            return new Authentication.AuthenticationResult(3, null);
        }
        long startTime = System.currentTimeMillis();
        if (userDescriptor == null) {
            this.incrementAuthenticationFailedCount(userName, this.appRes.getApplicationConfiguration().getAuthenticationAttemptAggregationCount());
            this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
            return new Authentication.AuthenticationResult(3, null);
        }
        if (userDescriptor.getAccountStatus() == UserManagement.AccountStatus.ADMINISTRATIVELY_LOCKED) {
            this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
            return new Authentication.AuthenticationResult(5, null);
        }
        if (userDescriptor.getAccountStatus() == UserManagement.AccountStatus.BRUTE_FORCE_LOCKED) {
            this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
            return new Authentication.AuthenticationResult(6, null);
        }
        if (userDescriptor.getAccountStatus() == UserManagement.AccountStatus.DISABLED) {
            this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
            return new Authentication.AuthenticationResult(4, null);
        }
        boolean loginNameBlocked = this.isAccountBruteForceLocked(userDescriptor.getUserName());
        String attemptedPasswordHash = LocalPasswordAuthentication.PBKDF2(userDescriptor.getPasswordHashAlgorithm(), validator.getPassword(), userDescriptor.getPasswordHashSalt(), userDescriptor.getPasswordHashIterationCount());
        SessionManagement sessions = new SessionManagement(this.appRes);
        if (attemptedPasswordHash.matches(userDescriptor.getPasswordHash())) {
            if (loginNameBlocked) {
                this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
                return new Authentication.AuthenticationResult(6, null);
            }
            if ((long)userDescriptor.getPasswordHashIterationCount() != this.appRes.getApplicationConfiguration().getHashIterations()) {
                userControl.changePassword(userDescriptor.getUserID(), validator.getPassword());
            }
            this.clearAuthenticationFailedCount(userName);
            return new Authentication.AuthenticationResult(0, sessions.createSession(userDescriptor.getUserID(), clientData));
        }
        if (loginNameBlocked) {
            this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
            return new Authentication.AuthenticationResult(6, null);
        }
        this.incrementAuthenticationFailedCount(userDescriptor.getUserName(), this.appRes.getApplicationConfiguration().getAuthenticationAttemptAggregationCount());
        this.timedDelay(startTime, SECONDS_AUTHENTICATION_DELAY);
        return new Authentication.AuthenticationResult(2, null);
    }

    public boolean checkPassword(int userId, PasswordAuthenticationValidator validator) throws NoSuchAlgorithmException, SQLException, InputValidationException, NoDatabaseConnectionException, NumericalOverflowException, NotFoundException {
        UserManagement userControl = new UserManagement(this.appRes);
        UserManagement.UserDescriptor userDescriptor = userControl.getUserDescriptor(userId);
        if (userDescriptor == null) {
            return false;
        }
        String attemptedPasswordHash = LocalPasswordAuthentication.PBKDF2(userDescriptor.getPasswordHashAlgorithm(), validator.getPassword(), userDescriptor.getPasswordHashSalt(), userDescriptor.getPasswordHashIterationCount());
        return attemptedPasswordHash.matches(userDescriptor.getPasswordHash());
    }

    public boolean isAccountBruteForceLocked(String username) throws NoDatabaseConnectionException, SQLException {
        long maximumLoginAttempts = DEFAULT_AUTHENTICATION_ATTEMPT_LIMIT;
        try {
            maximumLoginAttempts = this.appRes.getApplicationConfiguration().getAuthenticationAttemptLimit();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SYSTEM_PARAMETER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.PARAMETER, "Security.MaximumAuthenticationAttemptLimit"));
        }
        long aggregationTime = DEFAULT_AUTHENTICATION_AGGREGATION_PERIOD_SECONDS;
        try {
            aggregationTime = this.appRes.getApplicationConfiguration().getAuthenticationAttemptAggregationCount();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SYSTEM_PARAMETER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.PARAMETER, "Security.AuthenticationAttemptAggregationPeriod"));
        }
        long actualAttempts = this.getAuthenticationFailedCount(username, aggregationTime);
        return actualAttempts >= maximumLoginAttempts;
    }

    public static String generateRandomPassword(int length) throws NoSuchAlgorithmException {
        if (length < 8) {
            throw new IllegalArgumentException("The length of the generated password must be greater than 7 characters");
        }
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        StringBuffer stringBuffer = new StringBuffer(length);
        int c = 0;
        while (c < length) {
            int value = random.nextInt(61);
            if (value < 10) {
                stringBuffer.append((char)(value + 48));
            } else if (value < 36) {
                stringBuffer.append((char)(value + 55));
            } else {
                stringBuffer.append((char)(value + 61));
            }
            ++c;
        }
        return stringBuffer.toString();
    }

    public static String PBKDF2(String hashAlgorithm, String password, String salt, long iterationCount) throws NoSuchAlgorithmException {
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("The hash algorithm cannot be null");
        }
        if (iterationCount < 1L) {
            throw new IllegalArgumentException("The iteration count for PBKDF2 must be greater than 0");
        }
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm);
        byte[] hashBytes = (String.valueOf(password) + salt).getBytes();
        int c = 0;
        while ((long)c < iterationCount) {
            hashBytes = messageDigest.digest(hashBytes);
            ++c;
        }
        String passwordHash = new String(Hex.encodeHex(hashBytes));
        return passwordHash;
    }

    public static String generateSalt(int length) throws NoSuchAlgorithmException, SQLException, InputValidationException, NoDatabaseConnectionException {
        if (length == 0) {
            throw new IllegalArgumentException("Salt creation failed since the given length is invalid");
        }
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[length / 2];
        random.nextBytes(salt);
        return new String(Hex.encodeHex(salt));
    }
}

