/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.BindException;
import net.lukemurphey.nsia.HttpServer;

public final class NetworkManager {
    private int serverPort = 8443;
    private boolean sslEnabled = false;
    private HttpServer webServer;
    private final Object httpServerMutex = new Object();

    public void setServerPort(int serverTcpPort, boolean enableSsl) {
        if (serverTcpPort < 1) {
            throw new IllegalArgumentException("Server port is invalid");
        }
        this.serverPort = serverTcpPort;
        this.sslEnabled = enableSsl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListener() throws BindException, Exception {
        Object object = this.httpServerMutex;
        synchronized (object) {
            if (this.webServer != null) {
                this.webServer.shutdownServer();
            }
            this.webServer = new HttpServer();
            this.webServer.startServer(this.serverPort, this.sslEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListener() {
        Object object = this.httpServerMutex;
        synchronized (object) {
            try {
                if (this.webServer != null) {
                    this.webServer.shutdownServer();
                    this.webServer = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListenerRunning() {
        Object object = this.httpServerMutex;
        synchronized (object) {
            block4: {
                if (this.webServer != null) break block4;
                return false;
            }
            return true;
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean sslEnabled() {
        return this.sslEnabled;
    }
}

