/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import net.lukemurphey.nsia.AccessControlDescriptor;

public class ObjectPermissionDescriptor
extends AccessControlDescriptor {
    private long objectId;
    protected AccessControlDescriptor.Action read;
    protected AccessControlDescriptor.Action modify;
    protected AccessControlDescriptor.Action create;
    protected AccessControlDescriptor.Action delete;
    protected AccessControlDescriptor.Action execute;
    protected AccessControlDescriptor.Action control;

    public ObjectPermissionDescriptor(AccessControlDescriptor.Action read, AccessControlDescriptor.Action modify, AccessControlDescriptor.Action create, AccessControlDescriptor.Action execute, AccessControlDescriptor.Action delete, AccessControlDescriptor.Action control, AccessControlDescriptor.Subject subjectType, int subjectId, long objectId) {
        if (objectId < 0L) {
            throw new IllegalArgumentException("object identifier is invalid (must not be less than zero)");
        }
        this.read = read;
        this.modify = modify;
        this.create = create;
        this.delete = delete;
        this.execute = execute;
        this.control = control;
        super.init(subjectType, subjectId);
        this.objectId = objectId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public AccessControlDescriptor.Action getReadPermission() {
        return this.read;
    }

    public AccessControlDescriptor.Action getModifyPermission() {
        return this.modify;
    }

    public AccessControlDescriptor.Action getCreatePermission() {
        return this.create;
    }

    public AccessControlDescriptor.Action getExecutePermission() {
        return this.execute;
    }

    public AccessControlDescriptor.Action getDeletePermission() {
        return this.delete;
    }

    public AccessControlDescriptor.Action getControlPermission() {
        return this.control;
    }

    public ObjectPermissionDescriptor resolvePermissions(ObjectPermissionDescriptor objectPermissionDescriptor) {
        AccessControlDescriptor.Action read2 = objectPermissionDescriptor.getReadPermission();
        AccessControlDescriptor.Action modify2 = objectPermissionDescriptor.getModifyPermission();
        AccessControlDescriptor.Action create2 = objectPermissionDescriptor.getCreatePermission();
        AccessControlDescriptor.Action delete2 = objectPermissionDescriptor.getDeletePermission();
        AccessControlDescriptor.Action execute2 = objectPermissionDescriptor.getExecutePermission();
        AccessControlDescriptor.Action control2 = objectPermissionDescriptor.getControlPermission();
        this.read = this.resolvePermission(this.read, read2);
        this.modify = this.resolvePermission(this.modify, modify2);
        this.create = this.resolvePermission(this.create, create2);
        this.delete = this.resolvePermission(this.delete, delete2);
        this.execute = this.resolvePermission(this.execute, execute2);
        this.control = this.resolvePermission(this.control, control2);
        return new ObjectPermissionDescriptor(this.read, this.modify, this.create, this.execute, this.delete, this.control, objectPermissionDescriptor.getSubjectType(), objectPermissionDescriptor.getSubjectId(), objectPermissionDescriptor.getObjectId());
    }
}

