/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DerbyDatabaseInitializer;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class ReindexerWorker
implements WorkerThread {
    private boolean shutdown = false;
    private int total = -1;
    private int currentProgress = -1;
    private WorkerThread.State state = WorkerThread.State.INITIALIZED;
    private Exception exceptionThrown = null;

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        if (this.state == WorkerThread.State.STARTED) {
            return this.currentProgress * 100 / this.total;
        }
        return 0;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.state;
    }

    @Override
    public String getStatusDescription() {
        if (this.state == WorkerThread.State.INITIALIZED) {
            return "Ready";
        }
        if (this.state == WorkerThread.State.STARTING) {
            return "Preparing to reindex";
        }
        if (this.state == WorkerThread.State.STARTED) {
            return "Defragmenting indexes (" + this.currentProgress + " of " + this.total + ")";
        }
        return this.currentProgress + " of " + this.total + " indexes defragmented";
    }

    @Override
    public String getTaskDescription() {
        return "Database Index Defragmenter";
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    @Override
    public void terminate() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        block18: {
            this.state = WorkerThread.State.STARTING;
            Connection connection = null;
            try {
                try {
                    connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
                    DerbyDatabaseInitializer initializer = new DerbyDatabaseInitializer(connection);
                    Vector<DerbyDatabaseInitializer.DatabaseIndex> indexers = initializer.getDatabaseIndexManagers();
                    this.total = indexers.size();
                    this.currentProgress = 0;
                    this.state = WorkerThread.State.STARTED;
                    Iterator<DerbyDatabaseInitializer.DatabaseIndex> iterator = indexers.iterator();
                    while (iterator.hasNext()) {
                        if (this.shutdown) {
                            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.TASK_TERMINATED);
                            message.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
                            Application.getApplication().logEvent(message);
                        }
                        DerbyDatabaseInitializer.DatabaseIndex indexer = iterator.next();
                        try {
                            indexer.create(true);
                            ++this.currentProgress;
                        }
                        catch (SQLException e) {
                            this.exceptionThrown = e;
                            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.TASK_FAILED);
                            message.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
                            message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Exception thrown while defragmenting index " + indexer.getIndexName()));
                            Application.getApplication().logExceptionEvent(message, (Throwable)e);
                        }
                    }
                }
                catch (NoDatabaseConnectionException e) {
                    this.exceptionThrown = e;
                    EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.TASK_FAILED);
                    message.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
                    message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Exception thrown while attempting to get database connection in order to defragement indexes; indexer will exit"));
                    Application.getApplication().logExceptionEvent(message, (Throwable)e);
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block18;
                    }
                    catch (SQLException e2) {
                        EventLogMessage message2 = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
                        message2.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
                        message2.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Exception thrown while attempting to close database connection"));
                        Application.getApplication().logExceptionEvent(message2, (Throwable)e2);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
                    message.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
                    message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Exception thrown while attempting to close database connection"));
                    Application.getApplication().logExceptionEvent(message, (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
                message.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
                message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Exception thrown while attempting to close database connection"));
                Application.getApplication().logExceptionEvent(message, (Throwable)e);
            }
        }
        EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.TASK_COMPLETED);
        message.addField(new EventLogField(EventLogField.FieldName.TASK, "Database Reindexer"));
        message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, this.currentProgress + " of " + this.total + " indexes defragmented"));
        Application.getApplication().logEvent(message);
        this.state = WorkerThread.State.STOPPED;
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }
}

