/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.UserManagement;

public class RightDescriptor
extends AccessControlDescriptor {
    protected AccessControlDescriptor.Action right;
    protected String rightName;

    public RightDescriptor(AccessControlDescriptor.Action right, UserManagement.UserDescriptor userDescriptor, String rightName) {
        if (rightName == null) {
            throw new IllegalArgumentException("right name is invalid (null)");
        }
        if (userDescriptor == null) {
            throw new IllegalArgumentException("User descriptor is invalid (null)");
        }
        super.init(AccessControlDescriptor.Subject.USER, userDescriptor.getUserID());
        this.right = right;
        this.rightName = rightName;
    }

    public RightDescriptor(AccessControlDescriptor.Action right, GroupManagement.GroupDescriptor groupDescriptor, String rightName) {
        if (rightName == null) {
            throw new IllegalArgumentException("right name is invalid (null)");
        }
        if (groupDescriptor == null) {
            throw new IllegalArgumentException("Group descriptor is invalid (null)");
        }
        super.init(AccessControlDescriptor.Subject.GROUP, groupDescriptor.getGroupId());
        this.right = right;
        this.rightName = rightName;
    }

    public RightDescriptor(AccessControlDescriptor.Action right, AccessControlDescriptor.Subject subjectType, int subjectId, String rightName) {
        if (rightName == null) {
            throw new IllegalArgumentException("right name is invalid (null)");
        }
        super.init(subjectType, subjectId);
        this.right = right;
        this.rightName = rightName;
    }

    public String getRightName() {
        return this.rightName;
    }

    public AccessControlDescriptor.Action getRight() {
        return this.right;
    }

    protected RightDescriptor resolvePermissions(RightDescriptor rightDescriptor) {
        AccessControlDescriptor.Action right2 = rightDescriptor.getRight();
        this.right = this.resolvePermission(this.right, right2);
        return new RightDescriptor(this.right, rightDescriptor.getSubjectType(), rightDescriptor.getSubjectId(), rightDescriptor.getRightName());
    }
}

