/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ScanCallback;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;

public class RuleScanWorker
implements WorkerThread {
    private Vector<Long> ruleIDsToScan = null;
    private Vector<ScanRule> instantiatedRulesToScan = null;
    private Vector<Long> scanResultIDs = new Vector();
    private int currentOffset = 0;
    private ScanRule ruleBeingScanned = null;
    private boolean terminate = false;
    private WorkerThread.State state = WorkerThread.State.INITIALIZED;
    private Throwable exceptionThrown = null;

    public RuleScanWorker(Vector<Long> rulesToScan) {
        if (rulesToScan == null) {
            throw new IllegalArgumentException("The rules to scan cannot be null");
        }
        if (rulesToScan.size() == 0) {
            throw new IllegalArgumentException("The rules to scan cannot be zero");
        }
        this.ruleIDsToScan = rulesToScan;
    }

    public RuleScanWorker(ScanRule ruleToScan) {
        if (ruleToScan == null) {
            throw new IllegalArgumentException("The rule to scan cannot be null");
        }
        this.instantiatedRulesToScan = new Vector();
        this.instantiatedRulesToScan.add(ruleToScan);
    }

    public RuleScanWorker(ScanRule[] rulesToScan) {
        if (rulesToScan == null) {
            throw new IllegalArgumentException("The rules to scan cannot be null");
        }
        if (rulesToScan.length == 0) {
            throw new IllegalArgumentException("The rules to scan cannot be zero");
        }
        this.instantiatedRulesToScan = new Vector();
        ScanRule[] scanRuleArray = rulesToScan;
        int n = rulesToScan.length;
        int n2 = 0;
        while (n2 < n) {
            ScanRule rule = scanRuleArray[n2];
            this.instantiatedRulesToScan.add(rule);
            ++n2;
        }
    }

    public int numberOfRulesToScan() {
        int total = 0;
        if (this.instantiatedRulesToScan != null) {
            total += this.instantiatedRulesToScan.size();
        }
        if (this.ruleIDsToScan != null) {
            total += this.ruleIDsToScan.size();
        }
        return total;
    }

    public RuleScanWorker(long[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException("The rules to scan cannot be null");
        }
        if (rules.length == 0) {
            throw new IllegalArgumentException("The rules to scan cannot be zero");
        }
        this.ruleIDsToScan = new Vector();
        int c = 0;
        while (c < rules.length) {
            this.ruleIDsToScan.add(rules[c]);
            ++c;
        }
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public int getProgress() {
        if (this.numberOfRulesToScan() == 1) {
            if (this.ruleBeingScanned != null && this.ruleBeingScanned instanceof WorkerThread) {
                WorkerThread thread = (WorkerThread)((Object)this.ruleBeingScanned);
                return thread.getProgress();
            }
            return -1;
        }
        int percentagePerRule = 0;
        percentagePerRule = 100 / this.numberOfRulesToScan();
        int percentageDone = this.currentOffset * percentagePerRule;
        if (this.ruleBeingScanned != null && this.ruleBeingScanned instanceof WorkerThread) {
            WorkerThread thread = (WorkerThread)((Object)this.ruleBeingScanned);
            percentageDone += percentagePerRule * thread.getProgress() / 100;
        }
        return percentageDone;
    }

    @Override
    public WorkerThread.State getStatus() {
        return this.state;
    }

    @Override
    public String getStatusDescription() {
        if (this.currentOffset > this.numberOfRulesToScan() - 1) {
            return "Scan complete";
        }
        if (this.ruleBeingScanned != null && this.ruleBeingScanned instanceof WorkerThread) {
            WorkerThread thread = (WorkerThread)((Object)this.ruleBeingScanned);
            return "Scanning rule " + (this.currentOffset + 1) + " of " + this.numberOfRulesToScan() + " (" + thread.getStatusDescription() + ")";
        }
        return "Scanning rule " + (this.currentOffset + 1) + " of " + this.numberOfRulesToScan();
    }

    @Override
    public String getTaskDescription() {
        return "Web-Application Scan";
    }

    @Override
    public void pause() {
        WorkerThread thread;
        if (this.ruleBeingScanned != null && this.ruleBeingScanned instanceof WorkerThread && (thread = (WorkerThread)((Object)this.ruleBeingScanned)).canPause()) {
            this.state = WorkerThread.State.PAUSING;
            thread.pause();
            this.state = WorkerThread.State.PAUSED;
        }
    }

    @Override
    public boolean reportsProgress() {
        return true;
    }

    @Override
    public void terminate() {
        this.state = WorkerThread.State.STOPPING;
        this.terminate = true;
        if (this.ruleBeingScanned != null && this.ruleBeingScanned instanceof WorkerThread) {
            WorkerThread thread = (WorkerThread)((Object)this.ruleBeingScanned);
            thread.terminate();
        }
        this.state = WorkerThread.State.STOPPED;
    }

    @Override
    public void run() {
        this.exceptionThrown = null;
        this.state = WorkerThread.State.STARTING;
        while (this.exceptionThrown == null && !this.terminate && this.currentOffset < this.numberOfRulesToScan()) {
            try {
                ScanRule rule = this.ruleIDsToScan != null ? ScanRuleLoader.getScanRule(this.ruleIDsToScan.get(this.currentOffset)) : this.instantiatedRulesToScan.get(this.currentOffset);
                this.state = WorkerThread.State.STARTED;
                this.ruleBeingScanned = rule;
                ScanCallback callback = new ScanCallback(Application.getApplication());
                rule.setCallback(callback);
                ScanResult result = rule.doScan();
                Connection connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                if (this.ruleIDsToScan != null) {
                    this.scanResultIDs.add(result.saveToDatabase(connection, this.ruleIDsToScan.get(this.currentOffset)));
                } else {
                    this.scanResultIDs.add(result.saveToDatabase(connection, -1L));
                }
                if (connection != null) {
                    connection.close();
                }
                ++this.currentOffset;
            }
            catch (ScanRule.ScanRuleLoadFailureException e) {
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.TASK_FAILED, new EventLogField(EventLogField.FieldName.TASK, this.getStatusDescription())), (Throwable)e);
                this.exceptionThrown = e;
            }
            catch (ScanException e) {
                this.exceptionThrown = e;
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.TASK_FAILED, new EventLogField(EventLogField.FieldName.TASK, this.getStatusDescription())), (Throwable)e);
            }
            catch (NotFoundException e) {
                this.exceptionThrown = e;
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.TASK_FAILED, new EventLogField(EventLogField.FieldName.TASK, this.getStatusDescription())), (Throwable)e);
            }
            catch (NoDatabaseConnectionException e) {
                this.exceptionThrown = e;
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.DATABASE_FAILURE, new EventLogField(EventLogField.FieldName.TASK, this.getStatusDescription())), (Throwable)e);
            }
            catch (SQLException e) {
                this.exceptionThrown = e;
                Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION, new EventLogField(EventLogField.FieldName.TASK, this.getStatusDescription())), (Throwable)e);
            }
        }
        this.state = WorkerThread.State.STOPPED;
    }

    public long[] getScanResultIDs() {
        long[] result = new long[this.scanResultIDs.size()];
        int c = 0;
        while (c < result.length) {
            result[c] = this.scanResultIDs.get(c);
            ++c;
        }
        return result;
    }

    @Override
    public Throwable getException() {
        return this.exceptionThrown;
    }
}

