/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.Scanner;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;

public class ScannerController
extends Thread {
    private int maxScanThreads = 30;
    private boolean scanningEnabled = false;
    private boolean activelyScanning = false;
    private boolean shutdownScanner = false;
    private static int SCAN_EDIT_DELAY_MINUTES = 3;
    private static int DEFAULT_SCANNER_START_DELAY = 30000;
    private Application appRes;
    private long loopFrequency = 10000L;
    protected Vector<Thread> scanThreads = new Vector();

    public ScannerController(Application applicationResources) {
        super("Scanner Controller");
        this.appRes = applicationResources;
    }

    public void enableScanning() {
        this.scanningEnabled = true;
    }

    public void disableScanning() {
        this.scanningEnabled = false;
    }

    @Override
    public void run() {
        try {
            this.scanningEnabled = this.appRes.getApplicationConfiguration().isDefaultScanningEnabled();
            if (this.scanningEnabled) {
                ScannerController.sleep(DEFAULT_SCANNER_START_DELAY);
            }
            this.enterScanningLoop();
        }
        catch (SQLException e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            return;
        }
        catch (Exception e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return;
        }
    }

    public ScannerState getScanningState() {
        if (this.shutdownScanner && this.activelyScanning) {
            return ScannerState.TERMINATING;
        }
        if (this.shutdownScanner && !this.activelyScanning) {
            return ScannerState.TERMINATED;
        }
        if (this.scanningEnabled && !this.activelyScanning) {
            return ScannerState.STARTING;
        }
        if (this.scanningEnabled && this.activelyScanning) {
            return ScannerState.RUNNING;
        }
        if (!this.scanningEnabled && this.activelyScanning) {
            return ScannerState.PAUSING;
        }
        return ScannerState.PAUSED;
    }

    public boolean scanningEnabled() {
        return this.scanningEnabled;
    }

    public void setMaxScanThreads(int threadCount) {
        if (threadCount < 2) {
            throw new IllegalArgumentException("The maximum thread count must be greater that 1");
        }
        this.maxScanThreads = threadCount;
    }

    public void shutdown() {
        this.shutdownScanner = true;
    }

    public void enterScanningLoop() throws Exception {
        Connection connection = null;
        try {
            try {
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                if (connection == null) {
                    throw new NoDatabaseConnectionException();
                }
                long lastLoopStart = 0L;
                this.setPriority(3);
                while (!this.shutdownScanner) {
                    if (!this.scanningEnabled) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.scanningEnabled) {
                        long tDelta;
                        this.activelyScanning = true;
                        if (lastLoopStart != 0L && (tDelta = System.currentTimeMillis() - lastLoopStart) < this.loopFrequency) {
                            try {
                                Thread.sleep(this.loopFrequency - tDelta);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        lastLoopStart = System.currentTimeMillis();
                        PreparedStatement ruleStatement = null;
                        ResultSet ruleResults = null;
                        SiteGroupManagement groupManagement = new SiteGroupManagement(Application.getApplication());
                        SiteGroupManagement.SiteGroupDescriptor[] siteGroupDescriptors = groupManagement.getGroupDescriptors();
                        try {
                            ruleStatement = this.getRuleScanStatement(connection, false);
                            ruleResults = ruleStatement.executeQuery();
                            while (ruleResults.next()) {
                                long ruleId = ruleResults.getLong("ScanRuleID");
                                long siteGroupId = ruleResults.getLong("SiteGroupID");
                                long scanFrequency = ruleResults.getLong("ScanFrequency");
                                boolean scanDataObsolete = ruleResults.getBoolean("ScanDataObsolete");
                                ScanResult lastScanResult = null;
                                try {
                                    lastScanResult = ScanResultLoader.getLastScanResult(ruleId);
                                }
                                catch (ScanRule.ScanResultLoadFailureException e) {
                                    this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                                }
                                Timestamp lastScanned = lastScanResult != null ? lastScanResult.getScanTime() : new Timestamp(0L);
                                SiteGroupManagement.SiteGroupDescriptor siteGroupDescriptor = null;
                                int c = 0;
                                while (c < siteGroupDescriptors.length) {
                                    if (siteGroupId == (long)siteGroupDescriptors[c].getGroupId()) {
                                        siteGroupDescriptor = siteGroupDescriptors[c];
                                    }
                                    ++c;
                                }
                                if (siteGroupDescriptor == null || siteGroupDescriptor.getGroupState() != SiteGroupManagement.State.ACTIVE) continue;
                                if (scanDataObsolete && this.appRes.getApplicationConfiguration().isRescanOnEditEnabled()) {
                                    this.dispatchScanner(ruleId);
                                    continue;
                                }
                                if ((System.currentTimeMillis() - lastScanned.getTime()) / 1000L <= scanFrequency) continue;
                                this.dispatchScanner(ruleId);
                            }
                            while (this.scanThreads.size() > 0) {
                                int c = 0;
                                while (c < this.scanThreads.size()) {
                                    Thread thread = this.scanThreads.get(c);
                                    if (thread == null || !thread.isAlive()) {
                                        this.scanThreads.remove(c);
                                    }
                                    ++c;
                                }
                                Thread.sleep(200L);
                            }
                        }
                        finally {
                            if (ruleStatement != null) {
                                ruleStatement.close();
                            }
                            if (ruleResults != null) {
                                ruleResults.close();
                            }
                        }
                    }
                    this.activelyScanning = false;
                    long waitStart = System.currentTimeMillis();
                    boolean waitTimeExceeded = false;
                    while (this.scanThreads.size() > 0) {
                        if (System.currentTimeMillis() - waitStart < 60000L) {
                            waitTimeExceeded = true;
                        }
                        int c = 0;
                        while (c < this.scanThreads.size()) {
                            Thread thread = this.scanThreads.get(c);
                            if (thread == null || !thread.isAlive()) {
                                this.scanThreads.remove(c);
                            }
                            ++c;
                        }
                        Thread.sleep(200L);
                    }
                    if (!waitTimeExceeded) continue;
                    this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.SCAN_THREADS_FAILED_TO_TERMINATE));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean isCurrentlyScanning() {
        return this.activelyScanning;
    }

    private synchronized void dispatchScanner(long ruleId) throws Exception {
        int c = 0;
        while (c < this.scanThreads.size()) {
            Scanner scanner = (Scanner)this.scanThreads.get(c);
            if (scanner != null && scanner.getRuleId() == ruleId) {
                return;
            }
            ++c;
        }
        while (this.scanThreads.size() >= this.getMaxScanThreads()) {
            c = 0;
            while (c < this.scanThreads.size()) {
                Thread curThread = this.scanThreads.get(c);
                if (curThread == null || !curThread.isAlive()) {
                    this.scanThreads.remove(c);
                }
                ++c;
            }
        }
        Scanner scanner = new Scanner(this.appRes);
        if (scanner.prepareScan(ruleId)) {
            scanner.start();
            this.scanThreads.add(scanner);
        }
    }

    private ResultSet getLastScanResult(long ruleId) throws SQLException, NoDatabaseConnectionException {
        Connection conn = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = conn.prepareStatement("Select * from ScanResult where ScanRuleID = ? order by ScanDate Desc");
            statement.setLong(1, ruleId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ResultSet resultSet2 = resultSet;
                return resultSet2;
            }
            return null;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public int getMaxScanThreads() {
        if (this.maxScanThreads < 1) {
            return 1;
        }
        return this.maxScanThreads;
    }

    public ScanResult[] scanExpiredRules(boolean autoSaveResults) throws Exception {
        Connection connection = null;
        Statement ruleStatement = null;
        ResultSet ruleResults = null;
        Vector<ScanResult> scanResults = new Vector<ScanResult>();
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            ruleStatement = this.getRuleScanStatement(connection, false);
            ruleResults = ruleStatement.executeQuery();
            while (ruleResults.next()) {
                Connection conn;
                ScanResult scanResult;
                Scanner scanner;
                long ruleId = ruleResults.getLong("ScanRuleID");
                long scanFrequency = ruleResults.getLong("ScanFrequency");
                boolean scanDataObsolete = ruleResults.getBoolean("ScanDataObsolete");
                ResultSet lastScanResults = this.getLastScanResult(ruleId);
                Timestamp lastScanned = lastScanResults.getTimestamp("ScanDate");
                if (scanDataObsolete) {
                    scanner = new Scanner(this.appRes);
                    if (!scanner.prepareScan(ruleId) || (scanResult = scanner.doScan()) == null) continue;
                    scanResults.add(scanResult);
                    if (!autoSaveResults) continue;
                    conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                    scanResult.saveToDatabase(conn, ruleId);
                    if (conn == null) continue;
                    conn.close();
                    continue;
                }
                if ((System.currentTimeMillis() - lastScanned.getTime()) / 1000L <= scanFrequency || !(scanner = new Scanner(this.appRes)).prepareScan(ruleId) || (scanResult = scanner.doScan()) == null) continue;
                scanResults.add(scanResult);
                if (!autoSaveResults) continue;
                conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                scanResult.saveToDatabase(conn, ruleId);
                if (conn == null) continue;
                conn.close();
            }
            ScanResult[] scanResultsArray = new ScanResult[scanResults.size()];
            int c = 0;
            while (c < scanResults.size()) {
                ScanResult scanResult;
                scanResultsArray[c] = scanResult = (ScanResult)scanResults.get(c);
                ++c;
            }
            ScanResult[] scanResultArray = scanResultsArray;
            return scanResultArray;
        }
        finally {
            if (ruleStatement != null) {
                ruleStatement.close();
            }
            if (ruleResults != null) {
                ruleResults.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public ScanResult[] scanUpdatedRules(boolean autoSaveResults) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = this.getRuleScanStatement(connection, true);
            result = statement.executeQuery();
            int rulesScannedCount = 0;
            while (result.next()) {
                ++rulesScannedCount;
            }
            if (rulesScannedCount == 0) {
                return null;
            }
            result.first();
            ScanResult[] scanResults = new ScanResult[rulesScannedCount];
            int c = 0;
            while (result.next()) {
                long scanRuleId = result.getLong("ScanRuleID");
                Scanner scanner = new Scanner(this.appRes);
                scanner.prepareScan(scanRuleId);
                ScanResult scanResult = scanner.doScan();
                if (autoSaveResults) {
                    scanResult.saveToDatabase(connection, scanRuleId);
                }
                scanResults[c] = scanResult;
            }
            ScanResult[] scanResultArray = scanResults;
            return scanResultArray;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public ScanResult scanRule(long scanRuleId, boolean autoSaveResults) throws SQLException, Exception {
        Scanner scanner = new Scanner(this.appRes);
        scanner.prepareScan(scanRuleId);
        ScanResult scanResult = scanner.doScan();
        if (autoSaveResults) {
            Connection connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            scanResult.saveToDatabase(connection, scanRuleId);
            if (connection != null) {
                connection.close();
            }
        }
        return scanResult;
    }

    private PreparedStatement getRuleScanStatement(Connection connection, boolean filterToObsoleted, long siteGroupID) throws SQLException {
        PreparedStatement ruleStatement = null;
        ruleStatement = filterToObsoleted ? connection.prepareStatement("Select * from ScanRule where State = 1 and ScanDataObsolete <> 0 and (created = null or created < ?) and (modified = null or modified < ?) and SiteGroupID = ?") : connection.prepareStatement("Select * from ScanRule where State = 1 and (created = null or created < ?) and (modified = null or modified < ?) and SiteGroupID = ?");
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -SCAN_EDIT_DELAY_MINUTES);
        Timestamp earliestCreate = new Timestamp(calendar.getTime().getTime());
        ruleStatement.setTimestamp(1, earliestCreate);
        ruleStatement.setTimestamp(2, earliestCreate);
        ruleStatement.setLong(3, siteGroupID);
        return ruleStatement;
    }

    private PreparedStatement getRuleScanStatement(Connection connection, boolean filterToObsoleted) throws SQLException {
        PreparedStatement ruleStatement = filterToObsoleted ? connection.prepareStatement("Select * from ScanRule where State = 1 and ScanDataObsolete <> 0 and (created is null or created < ?) and (modified is null or modified < ?)") : connection.prepareStatement("Select * from ScanRule where State = 1 and (created is null or created < ?) and (modified is null or modified < ?)");
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -SCAN_EDIT_DELAY_MINUTES);
        Timestamp earliestCreate = new Timestamp(calendar.getTime().getTime());
        ruleStatement.setTimestamp(1, earliestCreate);
        ruleStatement.setTimestamp(2, earliestCreate);
        return ruleStatement;
    }

    public ScanResult[] scanAllRules(boolean autoSaveResults) throws Exception {
        Connection connection = null;
        Statement ruleStatement = null;
        ResultSet ruleResults = null;
        Vector<ScanResult> scanResults = new Vector<ScanResult>();
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            ruleStatement = this.getRuleScanStatement(connection, false);
            ruleResults = ruleStatement.executeQuery();
            while (ruleResults.next()) {
                ScanResult scanResult;
                Scanner scanner = new Scanner(this.appRes);
                long ruleId = ruleResults.getLong("ScanRuleID");
                if (!scanner.prepareScan(ruleId) || (scanResult = scanner.doScan()) == null) continue;
                scanResults.add(scanResult);
                if (!autoSaveResults) continue;
                Connection dbConnection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                scanResult.saveToDatabase(dbConnection, ruleId);
                if (dbConnection == null) continue;
                dbConnection.close();
            }
        }
        finally {
            if (ruleResults != null) {
                ruleResults.close();
            }
            if (ruleStatement != null) {
                ruleStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        ScanResult[] scanResultsArray = new ScanResult[scanResults.size()];
        int c = 0;
        while (c < scanResults.size()) {
            ScanResult scanResult;
            scanResultsArray[c] = scanResult = (ScanResult)scanResults.get(c);
            ++c;
        }
        return scanResultsArray;
    }

    public ScanResult[] scanSiteGroup(long siteGroupId, boolean autoSaveResults) throws Exception {
        Connection connection = null;
        Statement ruleStatement = null;
        ResultSet ruleResults = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            ruleStatement = this.getRuleScanStatement(connection, false, siteGroupId);
            ruleResults = ruleStatement.executeQuery();
            Vector<ScanResult> scanResults = new Vector<ScanResult>();
            while (ruleResults.next()) {
                ScanResult scanResult;
                Scanner scanner = new Scanner(this.appRes);
                long ruleId = ruleResults.getLong("ScanRuleID");
                if (!scanner.prepareScan(ruleId) || (scanResult = scanner.doScan()) == null) continue;
                scanResults.add(scanResult);
                if (!autoSaveResults) continue;
                Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                scanResult.saveToDatabase(conn, ruleId);
                if (conn == null) continue;
                conn.close();
            }
            ScanResult[] scanResultsArray = new ScanResult[scanResults.size()];
            int c = 0;
            while (c < scanResults.size()) {
                ScanResult scanResult;
                scanResultsArray[c] = scanResult = (ScanResult)scanResults.get(c);
                ++c;
            }
            ScanResult[] scanResultArray = scanResultsArray;
            return scanResultArray;
        }
        finally {
            if (ruleStatement != null) {
                ruleStatement.close();
            }
            if (ruleResults != null) {
                ruleResults.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void setPollingLoopFrequency(long loopFreq) {
        if (loopFreq < 500L) {
            throw new IllegalArgumentException("Loop frequency time is excessively low");
        }
        if (loopFreq > 3600000L) {
            throw new IllegalArgumentException("Loop frequency time is excessively high");
        }
        this.loopFrequency = loopFreq;
    }

    public long getPollingLoopFrequency() {
        return this.loopFrequency;
    }

    public static enum ScannerState {
        PAUSED,
        STARTING,
        RUNNING,
        TERMINATING,
        TERMINATED,
        PAUSING;

    }
}

