/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.UserManagement;
import org.apache.commons.codec.binary.Hex;

public class SessionManagement {
    private Application appRes = null;
    public static final int SESSION_IDENTIFIER_LENGTH = 64;
    public static final String SESSION_IDENTIFIER_REGEX = "[A-Fa-f0-9]*";
    private Pattern sessionIdentifierRegex = Pattern.compile("[A-Fa-f0-9]*");

    public SessionManagement(Application appResources) {
        this.appRes = appResources;
    }

    public synchronized String createSession(long userId, ClientData clientData) throws SQLException, NoDatabaseConnectionException, NoSuchAlgorithmException, InputValidationException {
        if (userId < 1L) {
            throw new IllegalArgumentException("The user ID must be greater than 0");
        }
        this.removeOldSessions();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
            statement = conn.prepareStatement("Insert into Sessions (UserID, TrackingNumber, SessionID, SessionIDCreated, Status, SessionCreated, LastActivity, RemoteUserAddress, RemoteUserData, ConnectionAddress, ConnectionData ) values (?,?,?,?,?,?,?,?,?,?,?)");
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sessionId = this.generateSessionIdentifier(64);
            statement.setLong(1, userId);
            statement.setLong(2, this.getTrackingNumber());
            statement.setString(3, sessionId);
            statement.setTimestamp(4, now);
            statement.setInt(5, SessionStatus.SESSION_ACTIVE.getStatusId());
            statement.setTimestamp(6, now);
            statement.setTimestamp(7, now);
            if (clientData != null) {
                statement.setString(8, clientData.getRemoteSourceAddress().toString());
                statement.setString(9, clientData.getRemoteSourceClientData());
                statement.setString(10, clientData.getSourceAddress().toString());
                statement.setString(11, clientData.getSourceClientData());
            } else {
                statement.setString(8, "");
                statement.setString(9, "");
                statement.setString(10, "");
                statement.setString(11, "");
            }
            statement.executeUpdate();
            String string = sessionId;
            return string;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private String generateSessionIdentifier(int length) throws NoSuchAlgorithmException, SQLException, InputValidationException, NoDatabaseConnectionException {
        if (length == 0) {
            throw new IllegalArgumentException("Session identifier creation failed since the given length is invalid");
        }
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] sid = new byte[length / 2];
        random.nextBytes(sid);
        String sessionIdentifier = new String(Hex.encodeHex(sid));
        while (this.getSessionStatus(sessionIdentifier) != SessionStatus.SESSION_NULL) {
            random.nextBytes(sid);
            sessionIdentifier = new String(Hex.encodeHex(sid));
        }
        return sessionIdentifier;
    }

    /*
     * Unable to fully structure code
     */
    private long getTrackingNumber() throws NoDatabaseConnectionException, SQLException {
        random = new Random();
        conn = null;
        statement = null;
        result = null;
        conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        statement = conn.prepareStatement("Select * from Sessions where TrackingNumber = ?");
        c = 0;
        while (true) {
            trackingNumber = random.nextInt(32767);
            statement.setInt(1, trackingNumber);
            result = statement.executeQuery();
            if (!result.next()) {
                var8_7 = trackingNumber;
                return var8_7;
            }
            ++c;
            return c;
        }
lbl19:
        // 1 sources

        return -1L;
        finally {
            if (c < 2000) ** continue;
            ** continue;
        }
    }

    public synchronized void resetSessionActivity(String sessionIdentifier) throws InputValidationException, NoDatabaseConnectionException, SQLException {
        if (sessionIdentifier == null) {
            return;
        }
        Matcher matcher = this.sessionIdentifierRegex.matcher(sessionIdentifier);
        if (!matcher.matches()) {
            throw new InputValidationException("Malformed session identifier", "Session Identifier", sessionIdentifier);
        }
        Connection conn = null;
        Statement statement = null;
        Timestamp lastActivity = new Timestamp(System.currentTimeMillis());
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
            statement = conn.prepareStatement("Update Sessions set LastActivity = ? where SessionID = ? and Status = ?");
            statement.setTimestamp(1, lastActivity);
            statement.setString(2, sessionIdentifier);
            statement.setInt(3, SessionStatus.SESSION_ACTIVE.getStatusId());
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String refreshSessionIdentifier(String sessionIdentifier) throws InputValidationException, SQLException, NoSuchAlgorithmException, NoDatabaseConnectionException {
        return this.refreshSessionIdentifier(sessionIdentifier, false);
    }

    public synchronized String refreshSessionIdentifier(String sessionIdentifier, boolean resetActivity) throws InputValidationException, SQLException, NoSuchAlgorithmException, NoDatabaseConnectionException {
        if (sessionIdentifier == null) {
            return null;
        }
        Matcher matcher = this.sessionIdentifierRegex.matcher(sessionIdentifier);
        if (!matcher.matches()) {
            throw new InputValidationException("Malformed session identifier", "Session Identifier", sessionIdentifier);
        }
        Connection conn = null;
        Statement statement = null;
        ResultSet result = null;
        Statement newSidStatement = null;
        Statement oldSidStatement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
            statement = conn.prepareStatement("Select * from Sessions where SessionID = ?");
            statement.setString(1, sessionIdentifier);
            result = statement.executeQuery();
            if (!result.next()) {
                return null;
            }
            int status = result.getInt("Status");
            if (status != SessionStatus.SESSION_ACTIVE.getStatusId() && status != SessionStatus.SESSION_IDENTIFIER_EXPIRED.getStatusId()) {
                return null;
            }
            String newSid = this.generateSessionIdentifier(64);
            long trackingNumber = result.getLong("TrackingNumber");
            long userId = result.getLong("UserID");
            Timestamp lastActivity = !resetActivity ? result.getTimestamp("LastActivity") : new Timestamp(System.currentTimeMillis());
            Timestamp sessionCreated = result.getTimestamp("SessionCreated");
            String remoteSourceAddress = result.getString("RemoteUserAddress");
            String remoteSourceData = result.getString("RemoteUserData");
            String connectionSourceAddress = result.getString("ConnectionAddress");
            String connectionSourceData = result.getString("ConnectionData");
            newSidStatement = conn.prepareStatement("Insert into Sessions (UserID, TrackingNumber, SessionID, SessionIDCreated, Status, SessionCreated, LastActivity, RemoteUserAddress, RemoteUserData, ConnectionAddress, ConnectionData ) values (?,?,?,?,?,?,?,?,?,?,?)");
            Timestamp now = new Timestamp(System.currentTimeMillis());
            newSidStatement.setLong(1, userId);
            newSidStatement.setLong(2, trackingNumber);
            newSidStatement.setString(3, newSid);
            newSidStatement.setTimestamp(4, now);
            newSidStatement.setInt(5, SessionStatus.SESSION_ACTIVE.getStatusId());
            newSidStatement.setTimestamp(6, sessionCreated);
            newSidStatement.setTimestamp(7, lastActivity);
            newSidStatement.setString(8, remoteSourceAddress);
            newSidStatement.setString(9, remoteSourceData);
            newSidStatement.setString(10, connectionSourceAddress);
            newSidStatement.setString(11, connectionSourceData);
            conn.setAutoCommit(false);
            newSidStatement.executeUpdate();
            oldSidStatement = conn.prepareStatement("Update Sessions set Status = ? where SessionID = ?");
            oldSidStatement.setInt(1, SessionStatus.SESSION_IDENTIFIER_EXPIRED.getStatusId());
            oldSidStatement.setString(2, sessionIdentifier);
            oldSidStatement.executeUpdate();
            conn.commit();
            String string = newSid;
            return string;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (newSidStatement != null) {
                newSidStatement.close();
            }
            if (oldSidStatement != null) {
                oldSidStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public SessionStatus getSessionStatus(String sessionIdentifier) throws SQLException, InputValidationException, NoDatabaseConnectionException {
        if (sessionIdentifier == null) {
            return null;
        }
        Matcher matcher = this.sessionIdentifierRegex.matcher(sessionIdentifier);
        if (!matcher.matches()) {
            throw new InputValidationException("Malformed session identifer", "Session Identifier", sessionIdentifier);
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = conn.prepareStatement("Select * from Sessions where SessionID = ?");
            statement.setString(1, sessionIdentifier);
            result = statement.executeQuery();
            if (!result.next()) {
                SessionStatus sessionStatus = SessionStatus.SESSION_NULL;
                return sessionStatus;
            }
            int status = result.getInt("Status");
            SessionStatus sessionStatus = SessionStatus.getStatusById(status);
            return sessionStatus;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void removeOldSessions() throws SQLException, NoDatabaseConnectionException, InputValidationException {
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        long retentionPeriod = 0x6DDD00L;
        long curSeconds = System.currentTimeMillis();
        Timestamp oldestSessionLifetime = new Timestamp(curSeconds - this.appRes.getApplicationConfiguration().getSessionLifetime() * 1000L - retentionPeriod);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Delete from Sessions where SessionCreated < ?");
            preparedStatement.setTimestamp(1, oldestSessionLifetime);
            preparedStatement.execute();
            long maximumSessionInactivitySecs = this.appRes.getApplicationConfiguration().getSessionInactivityThreshold();
            if (maximumSessionInactivitySecs > 0L) {
                Timestamp oldestInactiveSessionLifetime = new Timestamp(curSeconds - maximumSessionInactivitySecs * 1000L - retentionPeriod);
                preparedStatement = conn.prepareStatement("Delete from Sessions where SessionCreated < ? and Status = " + SessionStatus.SESSION_ACTIVE.getStatusId());
                preparedStatement.setTimestamp(1, oldestInactiveSessionLifetime);
                preparedStatement.execute();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean terminateSession(String sessionIdentifier) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionIdentifier);
        if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            return false;
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Delete from Sessions where TrackingNumber = ?");
            preparedStatement.setLong(1, sessionInfo.getTrackingNumber());
            return preparedStatement.executeUpdate() > 0;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean terminateSession(long trackingNumber) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Delete from Sessions where TrackingNumber = ?");
            preparedStatement.setLong(1, trackingNumber);
            return preparedStatement.executeUpdate() > 0;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public SessionInfo getSessionInfo(String sessionIdentifier) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (sessionIdentifier == null) {
            return new SessionInfo();
        }
        Matcher matcher = this.sessionIdentifierRegex.matcher(sessionIdentifier);
        if (!matcher.matches()) {
            throw new InputValidationException("Malformed session identifer", "Session Identifier", sessionIdentifier);
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            SessionInfo sessionInfo;
            statement = conn.prepareStatement("Select * from Sessions where SessionID = ?");
            statement.setString(1, sessionIdentifier);
            result = statement.executeQuery();
            if (!result.next()) {
                SessionInfo sessionInfo2 = new SessionInfo();
                return sessionInfo2;
            }
            SessionInfo sessionInfo3 = sessionInfo = this.constructSessionInfo(result);
            return sessionInfo3;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public SessionInfo getSessionInfo(long trackingNumber) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            SessionInfo sessionInfo;
            statement = conn.prepareStatement("Select * from Sessions where TrackingNumber = ? and Status = 1");
            statement.setLong(1, trackingNumber);
            result = statement.executeQuery();
            if (!result.next()) {
                SessionInfo sessionInfo2 = new SessionInfo();
                return sessionInfo2;
            }
            SessionInfo sessionInfo3 = sessionInfo = this.constructSessionInfo(result);
            return sessionInfo3;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public int disableUserSessions(int userId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (userId < 1) {
            throw new IllegalArgumentException("The user ID must be greater than 0");
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Update Sessions set Status = ? where UserID = ? and Status = ?");
            preparedStatement.setInt(1, SessionStatus.SESSION_ADMIN_TERMINATED.getStatusId());
            preparedStatement.setInt(2, userId);
            preparedStatement.setInt(3, SessionStatus.SESSION_ACTIVE.getStatusId());
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public SessionInfo[] getCurrentSessions() throws NoDatabaseConnectionException, SQLException, InputValidationException {
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SESSION);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Select * from Sessions where Status <> ?");
            preparedStatement.setInt(1, SessionStatus.SESSION_EXPIRED.getStatusId());
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<SessionInfo> sessionsVector = new Vector<SessionInfo>();
            while (resultSet.next()) {
                sessionsVector.add(this.constructSessionInfo(resultSet));
            }
            SessionInfo[] sessionInfo = null;
            sessionInfo = new SessionInfo[sessionsVector.size()];
            int c = 0;
            while (c < sessionsVector.size()) {
                sessionInfo[c] = (SessionInfo)sessionsVector.get(c);
                ++c;
            }
            SessionInfo[] sessionInfoArray = sessionInfo;
            return sessionInfoArray;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private SessionInfo constructSessionInfo(ResultSet result) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (result == null) {
            throw new IllegalArgumentException("Result set is null");
        }
        int trackingNumber = result.getInt("TrackingNumber");
        int userId = result.getInt("UserID");
        Timestamp lastActivity = result.getTimestamp("LastActivity");
        Timestamp sessionCreated = result.getTimestamp("SessionCreated");
        String remoteSourceAddress = result.getString("RemoteUserAddress");
        String remoteSourceData = result.getString("RemoteUserData");
        String connectionSourceAddress = result.getString("ConnectionAddress");
        String connectionSourceData = result.getString("ConnectionData");
        String sessionIdentifier = result.getString("SessionID");
        int status = result.getInt("Status");
        long curSeconds = System.currentTimeMillis();
        long maximumSessionSecs = this.appRes.getApplicationConfiguration().getSessionLifetime();
        long oldestSessionLifetimeThreshold = curSeconds - maximumSessionSecs * 1000L;
        if (maximumSessionSecs >= 1L && sessionCreated.getTime() < oldestSessionLifetimeThreshold) {
            status = SessionStatus.SESSION_LIFETIME_EXCEEDED.getStatusId();
        }
        if (status == SessionStatus.SESSION_ACTIVE.getStatusId()) {
            long maximumSessionInactivitySecs = this.appRes.getApplicationConfiguration().getSessionInactivityThreshold();
            long oldestSessionInactivityThreshold = curSeconds - maximumSessionInactivitySecs * 1000L;
            if (maximumSessionInactivitySecs >= 1L) {
                if (lastActivity != null && lastActivity.getTime() >= sessionCreated.getTime()) {
                    if (lastActivity.getTime() < oldestSessionInactivityThreshold) {
                        status = SessionStatus.SESSION_INACTIVE.getStatusId();
                    }
                } else if (sessionCreated.getTime() < oldestSessionInactivityThreshold) {
                    status = SessionStatus.SESSION_INACTIVE.getStatusId();
                }
            }
        }
        UserManagement userManagement = new UserManagement(this.appRes);
        UserManagement.UserDescriptor userDesc = null;
        try {
            userDesc = userManagement.getUserDescriptor(userId);
        }
        catch (NotFoundException e) {
            userDesc = null;
        }
        String username = null;
        if (userDesc != null) {
            username = userDesc.getUserName();
        }
        SessionStatus sessionStatus = SessionStatus.getStatusById(status);
        SessionInfo sessionInfo = new SessionInfo(sessionStatus, sessionIdentifier, trackingNumber, userId, username, lastActivity, sessionCreated, remoteSourceAddress, remoteSourceData, connectionSourceAddress, connectionSourceData);
        return sessionInfo;
    }

    protected boolean isSessionIdentiferExpired(long sessionIdCreateTime) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        return this.isSessionIdentiferExpired(sessionIdCreateTime, System.currentTimeMillis());
    }

    protected boolean isSessionIdentiferExpired(long sessionIdCreateTime, long curSeconds) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        long maximumSessionIdSecs = this.appRes.getApplicationConfiguration().getSessionIdentifierLifetime();
        if (maximumSessionIdSecs < 1L) {
            return false;
        }
        long oldestSessionIdThreshold = curSeconds - maximumSessionIdSecs * 1000L;
        return sessionIdCreateTime < oldestSessionIdThreshold;
    }

    public static class SessionInfo {
        private int trackingNumber;
        private int userId;
        private Timestamp lastActivity;
        private Timestamp sessionCreated;
        private String remoteSourceAddress;
        private String remoteSourceData;
        private String connectionSourceAddress;
        private String connectionSourceData;
        private SessionStatus sessionStatus;
        private String sessionIdentifier;
        private String userName;

        public SessionInfo(SessionStatus sessionStatus, String sessionIdentifier, int trackingNumber, int userId, Timestamp lastActivity, Timestamp sessionCreated, String remoteSourceAddress, String remoteSourceData, String connectionSourceAddress, String connectionSourceData) {
            this.trackingNumber = trackingNumber;
            this.userId = userId;
            this.lastActivity = lastActivity;
            this.sessionCreated = sessionCreated;
            this.remoteSourceAddress = remoteSourceAddress;
            this.remoteSourceData = remoteSourceData;
            this.connectionSourceAddress = connectionSourceAddress;
            this.connectionSourceData = connectionSourceData;
            this.sessionIdentifier = sessionIdentifier;
            this.sessionStatus = sessionStatus;
        }

        public SessionInfo(SessionStatus sessionStatus, String sessionIdentifier, int trackingNumber, int userId, String username, Timestamp lastActivity, Timestamp sessionCreated, String remoteSourceAddress, String remoteSourceData, String connectionSourceAddress, String connectionSourceData) {
            this.trackingNumber = trackingNumber;
            this.userId = userId;
            this.lastActivity = lastActivity;
            this.sessionCreated = sessionCreated;
            this.remoteSourceAddress = remoteSourceAddress;
            this.remoteSourceData = remoteSourceData;
            this.connectionSourceAddress = connectionSourceAddress;
            this.connectionSourceData = connectionSourceData;
            this.sessionIdentifier = sessionIdentifier;
            this.sessionStatus = sessionStatus;
            this.userName = username;
        }

        public Hashtable<String, Object> toHashtable() {
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("TrackingNumber", new Double(this.trackingNumber));
            hash.put("UserID", new Double(this.userId));
            hash.put("LastActivity", this.lastActivity);
            hash.put("SessionCreated", this.sessionCreated);
            hash.put("RemoteSourceAddress", this.remoteSourceAddress);
            hash.put("RemoteSourceData", this.remoteSourceData);
            hash.put("ConnectionSourceAddress", this.connectionSourceAddress);
            hash.put("ConnectionSourceData", this.connectionSourceData);
            hash.put("SessionStatus", this.sessionStatus);
            hash.put("SessionID", this.sessionIdentifier);
            return hash;
        }

        public SessionInfo() {
            this.sessionStatus = SessionStatus.SESSION_NULL;
        }

        public SessionStatus getSessionStatus() {
            return this.sessionStatus;
        }

        public long getTrackingNumber() {
            return this.trackingNumber;
        }

        public int getUserId() {
            return this.userId;
        }

        public Timestamp getLastActivity() {
            return this.lastActivity;
        }

        public Timestamp getSessionCreated() {
            return this.sessionCreated;
        }

        public String getRemoteSourceAddress() {
            return this.remoteSourceAddress;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRemoteSourceData() {
            return this.remoteSourceData;
        }

        public String getSourceAddress() {
            return this.connectionSourceAddress;
        }

        public String getSourceData() {
            return this.connectionSourceData;
        }

        public String getSessionIdentifier() {
            return this.sessionIdentifier;
        }
    }
}

