/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;

public class SiteGroupManagement {
    public static final String SITE_GROUP_NAME_REGEX = "[-a-zA-Z0-9.@!$ 90()]{1,64}";
    public static final int SITE_GROUP_NAME_LENGTH = 64;
    public static final String SITE_GROUP_DESCRIPTION_REGEX = "[-a-zA-Z0-9@!$ ()\\n\\t]{0,512}";
    public static final int SITE_GROUP_DESCRIPTION_LENGTH = 512;
    private Application application;

    public SiteGroupManagement(Application app) {
        this.application = app;
    }

    public int addGroup(String siteGroupName, String siteGroupDescription) throws SQLException, InputValidationException, NoDatabaseConnectionException {
        return this.addGroup(siteGroupName, siteGroupDescription, State.ACTIVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int addGroup(String siteGroupName, String siteGroupDescription, State siteGroupStateIndicator) throws SQLException, InputValidationException, NoDatabaseConnectionException {
        if (siteGroupName == null) throw new IllegalArgumentException("Site group name is invalid (null)");
        if (siteGroupName.length() == 0) {
            throw new IllegalArgumentException("Site group name is invalid (null)");
        }
        if (siteGroupName.length() == 0) {
            throw new IllegalArgumentException("Site group name is invalid (empty string)");
        }
        Pattern groupNamePattern = Pattern.compile(SITE_GROUP_NAME_REGEX);
        Matcher matcher = groupNamePattern.matcher(siteGroupName);
        if (!matcher.matches()) {
            throw new InputValidationException("Site group name contains invalid characters", "GroupName", siteGroupName);
        }
        if (this.getGroupID(siteGroupName) != -1) {
            return -1;
        }
        long objectId = AccessControl.allocateObjectId("SiteGroups", this.application);
        Connection conn = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
        PreparedStatement preparedStatement = null;
        ResultSet keys = null;
        try {
            preparedStatement = conn.prepareStatement("Insert into SiteGroups (Name, Description, Status, ObjectID) values (?, ?, ?, ?)", 1);
            preparedStatement.setString(1, siteGroupName);
            if (siteGroupDescription == null) {
                preparedStatement.setString(2, "");
            } else {
                preparedStatement.setString(2, siteGroupDescription);
            }
            preparedStatement.setInt(3, siteGroupStateIndicator.ordinal());
            preparedStatement.setLong(4, objectId);
            if (preparedStatement.executeUpdate() < 1) {
                return -1;
            }
            keys = preparedStatement.getGeneratedKeys();
            if (!keys.next()) return -1;
            int n = keys.getInt(1);
            return n;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (keys != null) {
                keys.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public int getGroupID(String siteGroupName) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        Pattern groupNamePattern = Pattern.compile(SITE_GROUP_NAME_REGEX);
        Matcher groupNameMatcher = groupNamePattern.matcher(siteGroupName);
        if (!groupNameMatcher.matches()) {
            throw new InputValidationException("The site group name contains invalid characters", "SiteGroupName", siteGroupName);
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        Connection connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
        try {
            statement = connection.prepareStatement("Select * from SiteGroups where Name = ?");
            statement.setString(1, siteGroupName);
            result = statement.executeQuery();
            if (result.next()) {
                int n = result.getInt("SiteGroupID");
                return n;
            }
            return -1;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean deleteGroup(int siteGroupId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (siteGroupId < 1) {
            throw new IllegalArgumentException("The site group ID must be greater than 0");
        }
        Connection conn = this.application.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Delete from SiteGroups where SiteGroupID = ?");
            preparedStatement.setInt(1, siteGroupId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean disableGroup(int siteGroupId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (siteGroupId < 1) {
            throw new IllegalArgumentException("The site group ID must be greater than 0");
        }
        Connection conn = this.application.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Update SiteGroups set Status = ? where SiteGroupID = ?");
            preparedStatement.setLong(1, State.INACTIVE.ordinal());
            preparedStatement.setLong(2, siteGroupId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean enableGroup(int groupId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (groupId < 1) {
            throw new IllegalArgumentException("The site group ID must be greater than 0");
        }
        Connection conn = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Update SiteGroups set Status = ? where SiteGroupID = ?");
            preparedStatement.setLong(1, State.ACTIVE.ordinal());
            preparedStatement.setLong(2, groupId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public SiteGroupDescriptor getGroupDescriptor(int groupId) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        if (groupId < 1) {
            throw new IllegalArgumentException("The site group ID must be greater than 0");
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        Connection connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
        try {
            statement = connection.prepareStatement("Select * from SiteGroups where SiteGroupID = ?");
            statement.setLong(1, groupId);
            result = statement.executeQuery();
            if (result.next()) {
                String groupName = result.getString("Name");
                String groupDescription = result.getString("Description");
                State groupStatus = SiteGroupManagement.convertStateFromInt(result.getInt("Status"));
                long objectId = result.getLong("ObjectID");
                SiteGroupDescriptor siteGroupDescriptor = new SiteGroupDescriptor(groupId, groupName, groupDescription, groupStatus, objectId);
                return siteGroupDescriptor;
            }
            throw new NotFoundException("A site group with the given identifier could not be found");
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static State convertStateFromInt(int value) {
        State[] states = State.values();
        int c = 0;
        while (c < states.length) {
            if (states[c].ordinal() == value) {
                return states[c];
            }
            ++c;
        }
        return State.INACTIVE;
    }

    public SiteGroupDescriptor getGroupDescriptor(String groupName) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        int groupId = this.getGroupID(groupName);
        return this.getGroupDescriptor(groupId);
    }

    public SiteGroupDescriptor[] getGroupDescriptors() throws SQLException, InputValidationException, NoDatabaseConnectionException {
        PreparedStatement statement = null;
        ResultSet result = null;
        Connection connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
        try {
            statement = connection.prepareStatement("Select * from SiteGroups");
            result = statement.executeQuery();
            Vector<SiteGroupDescriptor> groups = new Vector<SiteGroupDescriptor>();
            while (result.next()) {
                String groupName = result.getString("Name");
                int groupId = result.getInt("SiteGroupID");
                String groupDescription = result.getString("Description");
                State groupStatus = SiteGroupManagement.convertStateFromInt(result.getInt("Status"));
                long objectId = result.getLong("ObjectID");
                SiteGroupDescriptor groupDesc = new SiteGroupDescriptor(groupId, groupName, groupDescription, groupStatus, objectId);
                groups.add(groupDesc);
            }
            if (groups.isEmpty()) {
                return null;
            }
            SiteGroupDescriptor[] descriptors = new SiteGroupDescriptor[groups.size()];
            int d = 0;
            while (d < groups.size()) {
                descriptors[d] = (SiteGroupDescriptor)groups.get(d);
                ++d;
            }
            SiteGroupDescriptor[] siteGroupDescriptorArray = descriptors;
            return siteGroupDescriptorArray;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean updateGroupInfo(int groupId, String groupName, String groupDescription) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (groupId < 1) {
            throw new IllegalArgumentException("Site group ID is invalid (must be greater than 0)");
        }
        if (groupName == null || groupName.length() == 0) {
            throw new IllegalArgumentException("Site group name is invalid (null)");
        }
        if (groupName.length() == 0) {
            throw new IllegalArgumentException("Site group name is invalid (empty string)");
        }
        Pattern groupNamePattern = Pattern.compile(SITE_GROUP_NAME_REGEX);
        Matcher matcher = groupNamePattern.matcher(groupName);
        if (!matcher.matches()) {
            throw new InputValidationException("Site group name contains invalid characters", "SiteGroupName", groupName);
        }
        Connection conn = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update SiteGroups set Name = ?, Description = ? where SiteGroupID = ?");
            statement.setString(1, groupName);
            statement.setString(2, groupDescription);
            statement.setLong(3, groupId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static class SiteGroupDescriptor {
        private int groupId = -1;
        private String groupDescription;
        private String groupName;
        private State groupState = State.INACTIVE;
        private long objectId;

        public SiteGroupDescriptor(int groupId, String groupName, String groupDescription, State groupStatus, long objectId) throws InputValidationException {
            if (groupName == null) {
                throw new InputValidationException("The site group name cannot be null", "SiteGroupName", "null");
            }
            if (groupName.length() == 0) {
                throw new InputValidationException("The site group name cannot be empty", "SiteGroupName", groupName);
            }
            if (groupName.length() > 64) {
                throw new InputValidationException("The site group name length is excessive", "SiteGroupName", groupName);
            }
            Pattern groupNamePattern = Pattern.compile(SiteGroupManagement.SITE_GROUP_NAME_REGEX);
            Matcher groupNameMatcher = groupNamePattern.matcher(groupName);
            if (!groupNameMatcher.matches()) {
                throw new InputValidationException("The site group name contains invalid characters", "SiteGroupName", groupName);
            }
            if (groupDescription == null) {
                groupDescription = "";
            }
            if (groupStatus != State.ACTIVE) {
                groupStatus = State.INACTIVE;
            }
            this.groupId = groupId;
            this.groupName = groupName;
            this.groupDescription = groupDescription;
            this.groupState = groupStatus;
            this.objectId = objectId;
        }

        public String getDescription() {
            return this.groupDescription;
        }

        public long getObjectId() {
            return this.objectId;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public State getGroupState() {
            return this.groupState;
        }

        public boolean isEnabled() {
            return this.getGroupState() != State.INACTIVE;
        }

        public Hashtable<String, Object> toHashtable() {
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("SiteGroupID", this.groupId);
            hash.put("SiteGroupDescription", this.groupDescription);
            hash.put("SiteGroupName", this.groupName);
            hash.put("SiteGroupStatus", this.groupState.ordinal());
            return hash;
        }
    }

    public static enum State {
        ACTIVE,
        INACTIVE;

    }
}

