/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;

abstract class ConsoleCommand {
    protected String description;
    protected Vector<String> names = new Vector();
    protected String sampleArguments;
    protected Application application;
    protected boolean stopListening = false;

    public ConsoleCommand(String sampleArguments, String description, Application application, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.names.add(name);
            ++n2;
        }
        this.sampleArguments = sampleArguments;
        this.description = description;
        this.application = application;
    }

    public abstract CommandResult run(String[] var1) throws SQLException, NoDatabaseConnectionException, InputValidationException;

    public boolean matchesName(String name) {
        for (String curname : this.names) {
            if (curname == null || !curname.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.names.get(0);
    }

    public String getSampleInvocation() {
        if (this.sampleArguments == null) {
            return this.getName();
        }
        return String.valueOf(this.getName()) + " " + this.sampleArguments;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompleteDescription() {
        return String.valueOf(this.getSampleInvocation()) + " " + this.description;
    }

    protected static String getChars(char toInsert, int length) {
        StringBuffer buffer = new StringBuffer();
        int c = 0;
        while (c < length) {
            buffer.append(toInsert);
            ++c;
        }
        return buffer.toString();
    }

    protected static String addSpaces(String data, int length) {
        StringBuffer buffer = new StringBuffer(data);
        int c = 0;
        while (c < length - data.length()) {
            buffer.append(" ");
            ++c;
        }
        return buffer.toString();
    }

    protected static String getTableFromString(Vector<String[]> tableData, boolean firstRowIsHeader) {
        String[][] arrayArgs = new String[tableData.size()][];
        tableData.toArray((T[])arrayArgs);
        return ConsoleCommand.getTableFromString(arrayArgs, firstRowIsHeader);
    }

    protected static String getTableFromString(String[][] tableData, boolean firstRowIsHeader) {
        Vector<Integer> lengths = new Vector<Integer>();
        int row = 0;
        while (row < tableData.length) {
            int column = 0;
            while (column < tableData[row].length) {
                if (column >= lengths.size()) {
                    lengths.add(tableData[row][column].length());
                } else {
                    lengths.set(column, Math.max((Integer)lengths.get(column), tableData[row][column].length()));
                }
                ++column;
            }
            ++row;
        }
        StringBuffer buffer = new StringBuffer();
        int row2 = 0;
        while (row2 < tableData.length) {
            if (row2 == 1 && firstRowIsHeader) {
                int totalChars = 0;
                for (Integer integer : lengths) {
                    totalChars += integer + 5;
                }
                buffer.append(ConsoleCommand.getChars('-', totalChars));
                buffer.append("\n");
            }
            int column = 0;
            while (column < tableData[row2].length) {
                buffer.append(ConsoleCommand.addSpaces(tableData[row2][column], (Integer)lengths.get(column) + 5));
                ++column;
            }
            buffer.append("\n");
            ++row2;
        }
        if (tableData.length == 1 && firstRowIsHeader) {
            int totalChars = 0;
            for (Integer integer : lengths) {
                totalChars += integer + 5;
            }
            buffer.append(ConsoleCommand.getChars('-', totalChars));
        }
        return buffer.toString();
    }

    public static enum CommandResult {
        EXECUTED_CORRECTLY,
        ERROR,
        TERMINATE_CONSOLE,
        SYNTAX_ERROR;

    }
}

