/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.channels.AsynchronousCloseException;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.console.AddUserCommand;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.console.DisableUserCommand;
import net.lukemurphey.nsia.console.EnableUserCommand;
import net.lukemurphey.nsia.console.EventLogLastCommand;
import net.lukemurphey.nsia.console.EventLogViewCommand;
import net.lukemurphey.nsia.console.HelpCommand;
import net.lukemurphey.nsia.console.ListUsersCommand;
import net.lukemurphey.nsia.console.QuoteSequenceException;
import net.lukemurphey.nsia.console.ScannerCommand;
import net.lukemurphey.nsia.console.SetPasswordCommand;
import net.lukemurphey.nsia.console.ShowConfigCommand;
import net.lukemurphey.nsia.console.ShowEventsCommand;
import net.lukemurphey.nsia.console.ShowStatsCommand;
import net.lukemurphey.nsia.console.ShutdownCommand;
import net.lukemurphey.nsia.console.TaskListCommand;
import net.lukemurphey.nsia.console.TaskStopCommand;
import net.lukemurphey.nsia.console.UnlockUserCommand;
import net.lukemurphey.nsia.console.WebServicesCommand;
import org.jfree.chart.ChartFactory;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ConsoleListener
extends Thread {
    private Application application = null;
    private ConsoleCommand[] consoleCommands = null;
    private ConsoleCommand defaultCommand = null;
    private static final int IN_WHITESPACE = 0;
    private static final int IN_ARGUMENT = 1;
    private static final int IN_DOUBLE_QUOTED_ARGUMENT = 2;
    private static final int CHAR_WHITESPACE = 0;
    private static final int CHAR_DOUBLE_QUOTE = 1;
    private static final int CHAR = 3;
    private boolean continueExecuting = true;
    private BufferedReader in = null;
    private InputStreamReader inputStreamReader = null;
    private static ConsoleListener globalConsoleListener = null;

    public ConsoleListener(Application application) {
        super("Console Listener");
        if (application == null) {
            throw new IllegalArgumentException("The application instance cannot be null");
        }
        this.application = application;
        this.consoleCommands = this.registerCommands();
    }

    public static synchronized void stopConsoleListener() {
        if (globalConsoleListener != null) {
            globalConsoleListener.stopListener();
        }
    }

    public static synchronized ConsoleListener startConsoleListener() {
        Application application = Application.getApplication();
        if (application == null) {
            throw new IllegalArgumentException("The application cannot be null");
        }
        if (globalConsoleListener == null) {
            globalConsoleListener = new ConsoleListener(application);
            ChartFactory.createPieChart((String)"Testing", (PieDataset)new DefaultPieDataset(), (boolean)false, (boolean)true, (boolean)false);
            globalConsoleListener.start();
        }
        return globalConsoleListener;
    }

    public static synchronized ConsoleListener getConsoleListener() {
        return globalConsoleListener;
    }

    @Override
    public void run() {
        this.inputStreamReader = new InputStreamReader(System.in);
        this.in = new BufferedReader(this.inputStreamReader);
        System.out.println("\nThreatFactor NSIA 1.0.6 (http://ThreatFactor.com)");
        if (this.application.getNetworkManager().sslEnabled()) {
            if (this.application.getNetworkManager().getServerPort() != 443) {
                System.out.println("Web server running on: https://127.0.0.1:" + this.application.getNetworkManager().getServerPort());
            } else {
                System.out.println("Web server running on: https://127.0.0.1");
            }
        } else if (this.application.getNetworkManager().getServerPort() != 80) {
            System.out.println("Web server running on: http://127.0.0.1:" + this.application.getNetworkManager().getServerPort());
        } else {
            System.out.println("Web server running on: http://127.0.0.1");
        }
        System.out.println();
        System.out.println("Interactive console, type help for list of commands");
        this.continueExecuting = true;
        while (this.continueExecuting) {
            System.out.print("> ");
            try {
                String text = this.in.readLine();
                if (!this.continueExecuting || text == null) continue;
                this.continueExecuting = this.runCommand(text.trim());
            }
            catch (AsynchronousCloseException e) {
                this.continueExecuting = false;
            }
            catch (Exception e) {
                System.err.println("Operation Failed: " + e.getMessage());
                e.printStackTrace();
                this.continueExecuting = false;
            }
        }
    }

    public void stopListener() {
        this.continueExecuting = false;
        globalConsoleListener.interrupt();
    }

    private ConsoleCommand[] registerCommands() {
        HelpCommand help = new HelpCommand(this.application, "Help", "?");
        ConsoleCommand[] commands = new ConsoleCommand[]{new WebServicesCommand(this.application, "WebService"), new ScannerCommand(this.application, "Scanner"), new ShowConfigCommand(this.application, "System.Config", "Config"), new ShowStatsCommand(this.application, "System.Stats", "Stats"), new ShutdownCommand(this.application, "System.Shutdown", "Exit", "Shutdown"), new DisableUserCommand(this.application, "User.Disable"), new EnableUserCommand(this.application, "User.Enable"), new ListUsersCommand(this.application, "User.List"), new SetPasswordCommand(this.application, "User.SetPassword"), new UnlockUserCommand(this.application, "User.Unlock"), new AddUserCommand(this.application, "User.Add"), new ShowEventsCommand(this.application, "ShowEvents"), new TaskListCommand(this.application, "Task.List"), new TaskStopCommand(this.application, "Task.Stop"), new EventLogLastCommand(this.application, "EventLog.Last"), new EventLogViewCommand(this.application, "EventLog.View"), help};
        this.defaultCommand = help;
        help.setCommands(commands);
        return commands;
    }

    private boolean runCommand(String command) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        String[] input;
        if (command.length() == 0) {
            return true;
        }
        boolean syntaxProblems = false;
        try {
            input = this.parseCommand(command);
        }
        catch (QuoteSequenceException e) {
            System.out.println(e.getDescription());
            return true;
        }
        int c = 0;
        while (c < this.consoleCommands.length) {
            if (this.consoleCommands[c].matchesName(input[0])) {
                System.out.println();
                ConsoleCommand.CommandResult result = this.consoleCommands[c].run(input);
                boolean bl = syntaxProblems = result == ConsoleCommand.CommandResult.ERROR;
                return result != ConsoleCommand.CommandResult.TERMINATE_CONSOLE;
            }
            ++c;
        }
        System.out.println("Command not recognized");
        syntaxProblems = true;
        if (syntaxProblems) {
            this.defaultCommand.run(input);
        }
        return true;
    }

    private String[] parseCommand(String input) throws QuoteSequenceException {
        StringBuffer[] arguments = new StringBuffer[10];
        arguments = this.parseCommand(input, 0, arguments, 0, 0);
        int numberOfArgs = 0;
        int c = 0;
        while (c < arguments.length) {
            if (arguments[c] != null) {
                ++numberOfArgs;
            }
            ++c;
        }
        String[] argumentsString = new String[numberOfArgs];
        int c2 = 0;
        while (c2 < arguments.length) {
            if (arguments[c2] != null) {
                argumentsString[c2] = new String(arguments[c2]);
            }
            ++c2;
        }
        return argumentsString;
    }

    private StringBuffer[] parseCommand(String input, int position, StringBuffer[] arguments, int state, int currentArgumentPosition) throws QuoteSequenceException {
        boolean atEnd;
        int currentCharType = input.charAt(position) == '\"' ? 1 : (input.charAt(position) == ' ' || input.charAt(position) == '\t' ? 0 : 3);
        boolean bl = atEnd = position >= input.length() - 1;
        if (!atEnd && input.charAt(position) == '\\' && input.charAt(position + 1) == '\"') {
            boolean escapedCharAtEnd;
            boolean bl2 = escapedCharAtEnd = position + 1 >= input.length() - 1;
            if (escapedCharAtEnd) {
                if (state == 2) {
                    throw new QuoteSequenceException(input, position + 1);
                }
                if (state == 1) {
                    arguments[currentArgumentPosition].append('\"');
                    return arguments;
                }
                if (state == 0) {
                    arguments[currentArgumentPosition] = new StringBuffer();
                    arguments[currentArgumentPosition].append('\"');
                    return arguments;
                }
            } else {
                if (state == 2) {
                    return this.parseCommand(input, position + 2, arguments, 2, currentArgumentPosition);
                }
                if (state == 1) {
                    return this.parseCommand(input, position + 2, arguments, 1, currentArgumentPosition);
                }
                if (state == 0) {
                    arguments[currentArgumentPosition] = new StringBuffer();
                    arguments[currentArgumentPosition].append('\"');
                    return this.parseCommand(input, position + 2, arguments, 1, currentArgumentPosition);
                }
            }
        }
        if (state == 1) {
            if (atEnd && currentCharType == 1) {
                throw new QuoteSequenceException(input, position);
            }
            if (atEnd && currentCharType == 3) {
                arguments[currentArgumentPosition].append(input.charAt(position));
                return arguments;
            }
            if (atEnd && currentCharType == 0) {
                return arguments;
            }
            if (currentCharType == 3) {
                arguments[currentArgumentPosition].append(input.charAt(position));
                return this.parseCommand(input, position + 1, arguments, 1, currentArgumentPosition);
            }
            if (currentCharType == 1) {
                return this.parseCommand(input, position + 1, arguments, 0, currentArgumentPosition);
            }
            if (currentCharType == 0) {
                return this.parseCommand(input, position + 1, arguments, 0, currentArgumentPosition + 1);
            }
        } else if (state == 0) {
            if (atEnd && currentCharType == 0) {
                return arguments;
            }
            if (currentCharType == 0) {
                return this.parseCommand(input, position + 1, arguments, 0, currentArgumentPosition);
            }
            if (currentCharType == 3) {
                arguments[currentArgumentPosition] = new StringBuffer();
                arguments[currentArgumentPosition].append(input.charAt(position));
                if (atEnd) {
                    return arguments;
                }
                return this.parseCommand(input, position + 1, arguments, 1, currentArgumentPosition);
            }
            if (atEnd && currentCharType == 1) {
                throw new QuoteSequenceException(input, position);
            }
            if (currentCharType == 1) {
                arguments[currentArgumentPosition] = new StringBuffer();
                return this.parseCommand(input, position + 1, arguments, 2, currentArgumentPosition);
            }
        } else if (state == 2) {
            if (atEnd && (currentCharType == 0 || currentCharType == 3)) {
                throw new QuoteSequenceException(input, position);
            }
            if (currentCharType == 0 || currentCharType == 3) {
                arguments[currentArgumentPosition].append(input.charAt(position));
                return this.parseCommand(input, position + 1, arguments, 2, currentArgumentPosition);
            }
            if (currentCharType == 1) {
                if (atEnd) {
                    return arguments;
                }
                return this.parseCommand(input, position + 1, arguments, 0, currentArgumentPosition + 1);
            }
        }
        return arguments;
    }
}

