/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class DisableUserCommand
extends ConsoleCommand {
    public DisableUserCommand(Application application, String ... names) {
        super("<username>", "Disables the user", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        int userId;
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        if (input.length < 2) {
            System.out.println("Error: too few arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        UserManagement userManagement = new UserManagement(this.application);
        try {
            userId = userManagement.getUserID(input[1]);
        }
        catch (SQLException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            System.out.println("Account could not be enabled, a SQL exception occurred");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            System.out.println("Account could not be enabled, no database connection exists");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Username is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        if (userId < 0) {
            System.out.println("No user exists with the name given");
            this.application.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        try {
            if (userManagement.disableAccount(userId)) {
                System.out.println("Account disabled");
            } else {
                System.out.println("Account unsuccessfully disabled");
            }
        }
        catch (SQLException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            System.out.println("Account could not be enabled, a SQL exception occurred");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            System.out.println("Account could not be enabled, no database connection exists");
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Username is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[2]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

