/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class EnableUserCommand
extends ConsoleCommand {
    public EnableUserCommand(Application application, String ... names) {
        super("<username>", "Enables the user", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        long userId;
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length < 2) {
            System.out.println("Error: too few arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        UserManagement userManagement = new UserManagement(this.application);
        try {
            userId = userManagement.getUserID(input[1]);
        }
        catch (SQLException e) {
            System.out.println("Account could not be enabled, a SQL exception occurred");
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            System.out.println("Account could not be enabled, no database connection exists");
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Username is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        if (userId < 0L) {
            System.out.println("No user exists with the name given");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[1]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        try {
            if (userManagement.enableAccount(userId)) {
                System.out.println("Account enabled");
            } else {
                System.out.println("Account unsuccessfully enabled");
            }
        }
        catch (SQLException e) {
            System.out.println("Account could not be enabled, a SQL exception occurred");
            this.application.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (NoDatabaseConnectionException e) {
            System.out.println("Account could not be enabled, no database connection exists");
            this.application.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            return ConsoleCommand.CommandResult.ERROR;
        }
        catch (InputValidationException e) {
            System.out.println("Username is illegal (contains disallowed characters)");
            this.application.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, input[2]));
            return ConsoleCommand.CommandResult.ERROR;
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

