/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogViewer;

public class EventLogLastCommand
extends ConsoleCommand {
    private static final int MAX_TO_DISPLAY = 100;

    public EventLogLastCommand(Application application, String ... names) {
        super("<number to display> (<event name filter>)", "List the last few event log messages", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        int entriesCount = 10;
        String contentFilter = null;
        if (input.length > 3) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        try {
            if (input.length >= 2) {
                entriesCount = Integer.parseInt(input[1]);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Error: The number of entries to list is not a valid integer");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (entriesCount > 100) {
            System.out.println("Warning: Cannot display more than 100 entries, only 100 will be shown");
            entriesCount = 100;
        } else if (entriesCount <= 0) {
            System.out.println("Error: The number of entries to list must be greater then 0");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length >= 3) {
            contentFilter = input[2];
        }
        Vector<String[]> tableData = new Vector<String[]>(entriesCount + 2);
        EventLogViewer.EventLogFilter filter = new EventLogViewer.EventLogFilter(entriesCount);
        if (contentFilter != null) {
            filter.setContentFilter(contentFilter);
        }
        filter.setEntryID(Integer.MAX_VALUE, false);
        EventLogViewer viewer = new EventLogViewer(this.application);
        EventLogViewer.EventLogEntry[] entries = viewer.getEntries(filter);
        tableData.add(new String[]{"Severity", "Date", "Entry ID", "Message", "Details"});
        int c = entries.length - 1;
        while (c >= 0) {
            tableData.add(new String[]{entries[c].getSeverity().toString(), entries[c].getDate().toString(), String.valueOf(entries[c].getEntryID()), entries[c].getMessage(), GenericUtils.shortenString(entries[c].getNotes(), 32)});
            entries[c].getSeverity().toString();
            --c;
        }
        if (entries.length > 0) {
            System.out.println(EventLogLastCommand.getTableFromString(tableData, true));
        } else {
            System.out.println("No entries found");
        }
        return null;
    }
}

