/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.console.ConsoleCommand;

public class HelpCommand
extends ConsoleCommand {
    private ConsoleCommand[] consoleCommands = null;

    public HelpCommand(Application application, String ... names) {
        super(null, "Display the interactive console command syntax", application, names);
    }

    public void setCommands(ConsoleCommand[] consoleCommands) {
        this.consoleCommands = new ConsoleCommand[consoleCommands.length];
        System.arraycopy(consoleCommands, 0, this.consoleCommands, 0, this.consoleCommands.length);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (!(input.length >= 1 && !this.matchesName(input[0]) && this.similarCommands(input) || input.length == 2 && this.listCommandHelp(input[1]))) {
            System.out.println("Interactive console help: type \"help <command>\" for command details");
            this.listCommands();
            if (Application.VERSION_STATUS == null) {
                System.out.println("\nThreatFactor NSIA version 1.0.6");
            } else {
                System.out.println("\nThreatFactor NSIA version 1.0.6 (" + Application.VERSION_STATUS + ")");
            }
            System.out.println("http://ThreatFactor.com/");
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }

    private boolean similarCommands(String[] input) {
        Vector<String[]> commands = new Vector<String[]>();
        commands.add(new String[]{"Similar Command", "Usage"});
        int c = 0;
        while (c < this.consoleCommands.length) {
            if (this.consoleCommands[c].getName().toLowerCase().startsWith(input[0].toLowerCase())) {
                commands.add(new String[]{this.consoleCommands[c].getName(), this.consoleCommands[c].description});
            }
            ++c;
        }
        if (commands.size() > 0) {
            System.out.println("Type \"help\" to see the available commands");
            if (commands.size() > 1) {
                String[][] commandsArray = new String[commands.size()][];
                commands.toArray((T[])commandsArray);
                System.out.println();
                System.out.println(ConsoleCommand.getTableFromString(commandsArray, true));
            }
            return true;
        }
        return false;
    }

    private boolean listCommandHelp(String name) {
        int c = 0;
        while (c < this.consoleCommands.length) {
            if (this.consoleCommands[c].matchesName(name)) {
                String[][] table = new String[][]{{"Command Help", ""}, {"Description:", this.consoleCommands[c].description}, {"Syntax:", this.consoleCommands[c].getSampleInvocation()}};
                System.out.println(ConsoleCommand.getTableFromString(table, true));
                return true;
            }
            ++c;
        }
        return false;
    }

    private void listCommands() {
        Vector<String[]> commands = new Vector<String[]>();
        commands.add(new String[]{"Command", "Description"});
        int c = 0;
        while (c < this.consoleCommands.length) {
            commands.add(new String[]{this.consoleCommands[c].getName(), this.consoleCommands[c].description});
            ++c;
        }
        String[][] commandsArray = new String[commands.size()][];
        commands.toArray((T[])commandsArray);
        System.out.println();
        System.out.println(ConsoleCommand.getTableFromString(commandsArray, true));
    }
}

